/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.event.listeners.AutoPopulateUtil;
import io.micronaut.data.runtime.event.listeners.AutoPopulatedEntityEventListener;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;

@Singleton
public class UUIDGeneratingEntityEventListener
extends AutoPopulatedEntityEventListener {
    private static final Predicate<RuntimePersistentProperty<Object>> UUID_PREDICATE = p -> p.getType() == UUID.class;

    @Override
    @NonNull
    protected final List<Class<? extends Annotation>> getEventTypes() {
        return Collections.singletonList(PrePersist.class);
    }

    @Override
    @NonNull
    protected Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate() {
        return UUID_PREDICATE;
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        RuntimePersistentProperty<Object>[] persistentProperties = this.getApplicableProperties(context);
        AutoPopulateUtil.applyTopLevel(context, persistentProperties, p -> UUID.randomUUID());
        AutoPopulateUtil.applyEmbedded(context, (embeddedPersistentProperty, current) -> {
            if (embeddedPersistentProperty.getType() != UUID.class) {
                return current;
            }
            if (!embeddedPersistentProperty.isAutoPopulated() && !embeddedPersistentProperty.getAnnotationMetadata().hasStereotype(AutoPopulated.class)) {
                return current;
            }
            BeanProperty prop = embeddedPersistentProperty.getProperty();
            if (!prop.hasSetterOrConstructorArgument()) {
                return current;
            }
            UUID value = UUID.randomUUID();
            if (prop.isReadOnly()) {
                return prop.withValue(current, (Object)value);
            }
            prop.set(current, (Object)value);
            return current;
        });
        return true;
    }
}

