/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.ReactiveCascadeOperations;
import io.micronaut.data.runtime.operations.internal.ReactiveEntityOperations;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@Internal
public abstract class AbstractReactiveEntityOperations<Ctx extends OperationContext, T, Exc extends Exception>
extends ReactiveEntityOperations<T, Exc> {
    protected final Ctx ctx;
    protected final ReactiveCascadeOperations<Ctx> cascadeOperations;
    protected final boolean insert;
    protected final boolean hasGeneratedId;
    protected Mono<Data> data;

    protected AbstractReactiveEntityOperations(Ctx ctx, ReactiveCascadeOperations<Ctx> cascadeOperations, ConversionService conversionService, EntityEventListener<Object> entityEventListener, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
        super(entityEventListener, persistentEntity, conversionService);
        this.cascadeOperations = cascadeOperations;
        this.ctx = ctx;
        this.insert = insert;
        this.hasGeneratedId = insert && persistentEntity.getIdentity() != null && persistentEntity.getIdentity().isGenerated();
        Data data = new Data();
        data.entity = entity;
        this.data = Mono.just((Object)data);
    }

    @Override
    protected void cascadePre(Relation.Cascade cascadeType) {
        this.doCascade(false, cascadeType);
    }

    @Override
    protected void cascadePost(Relation.Cascade cascadeType) {
        this.doCascade(true, cascadeType);
    }

    private void doCascade(boolean isPost, Relation.Cascade cascadeType) {
        this.data = this.data.flatMap(d -> {
            if (d.vetoed) {
                return Mono.just((Object)d);
            }
            Mono entity = this.cascadeOperations.cascadeEntity(this.ctx, d.entity, this.persistentEntity, isPost, cascadeType);
            return entity.map(e -> {
                d.entity = e;
                return d;
            });
        });
    }

    @Override
    protected boolean triggerPre(Function<EntityEventContext<Object>, Boolean> fn) {
        this.data = this.data.flatMap(d -> {
            if (d.vetoed) {
                return Mono.just((Object)d);
            }
            return Mono.deferContextual(contextView -> {
                try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                    DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                    d.vetoed = (Boolean)fn.apply(event) == false;
                    d.entity = event.getEntity();
                    Mono mono = Mono.just((Object)d);
                    return mono;
                }
            });
        });
        return false;
    }

    @Override
    protected void triggerPost(Consumer<EntityEventContext<Object>> fn) {
        this.data = this.data.flatMap(d -> {
            if (d.vetoed) {
                return Mono.just((Object)d);
            }
            return Mono.deferContextual(contextView -> {
                try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                    DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                    fn.accept(event);
                    Mono mono = Mono.just((Object)d);
                    return mono;
                }
            });
        });
    }

    @Override
    public void veto(Predicate<T> predicate) {
        this.data = this.data.map(d -> {
            if (d.vetoed) {
                return d;
            }
            d.vetoed = predicate.test(d.entity);
            return d;
        });
    }

    private boolean notVetoed(Data data) {
        return !data.vetoed;
    }

    @Override
    public Mono<T> getEntity() {
        return this.data.filter(this::notVetoed).map(d -> d.entity);
    }

    public Mono<Number> getRowsUpdated() {
        return this.data.filter(this::notVetoed).map(d -> d.rowsUpdated).switchIfEmpty(Mono.just((Object)0L));
    }

    protected final class Data {
        public T entity;
        public Object filter;
        public Map<QueryParameterBinding, Object> previousValues;
        public long rowsUpdated;
        public boolean vetoed = false;

        protected Data() {
        }
    }
}

