/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.AssociationUtils;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.operations.CriteriaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.jpa.criteria.CriteriaDeleteBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaQueryBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaUpdateBuilder;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.data.runtime.criteria.RuntimeCriteriaBuilder;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.intercept.criteria.PreparedQueryCriteriaRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected static final String PREPARED_QUERY_KEY = "PREPARED_QUERY";
    protected final CriteriaRepositoryOperations criteriaRepositoryOperations;
    protected final CriteriaBuilder criteriaBuilder;
    private final Map<RepositoryMethodKey, QueryBuilder> sqlQueryBuilderForRepositories = new ConcurrentHashMap<RepositoryMethodKey, QueryBuilder>();
    private final Map<RepositoryMethodKey, Set<JoinPath>> methodsJoinPaths = new ConcurrentHashMap<RepositoryMethodKey, Set<JoinPath>>();

    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (operations instanceof CriteriaRepositoryOperations) {
            CriteriaRepositoryOperations criteriaOps;
            this.criteriaRepositoryOperations = criteriaOps = (CriteriaRepositoryOperations)operations;
            this.criteriaBuilder = this.criteriaRepositoryOperations.getCriteriaBuilder();
        } else {
            this.criteriaRepositoryOperations = null;
            this.criteriaBuilder = (CriteriaBuilder)operations.getApplicationContext().getBean(RuntimeCriteriaBuilder.class);
        }
    }

    final CriteriaRepositoryOperations getCriteriaRepositoryOperations(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable) {
        if (this.criteriaRepositoryOperations != null) {
            return this.criteriaRepositoryOperations;
        }
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        return new PreparedQueryCriteriaRepositoryOperations(this.criteriaBuilder, this.operations, context, sqlQueryBuilder, this.getRequiredRootEntity(context), pageable);
    }

    protected final <T> List<T> findAll(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable, CriteriaQuery<T> criteriaQuery) {
        pageable = this.applyPaginationAndSort(pageable, criteriaQuery, false);
        if (this.criteriaRepositoryOperations != null) {
            if (pageable != null) {
                if (pageable.getMode() != Pageable.Mode.OFFSET) {
                    throw new UnsupportedOperationException("Pageable mode " + pageable.getMode() + " is not supported by hibernate operations");
                }
                return this.criteriaRepositoryOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize());
            }
            int offset = this.getOffset(context);
            int limit = this.getLimit(context);
            if (offset > 0 || limit > 0) {
                return this.criteriaRepositoryOperations.findAll(criteriaQuery, offset, limit);
            }
            return this.criteriaRepositoryOperations.findAll(criteriaQuery);
        }
        return this.getCriteriaRepositoryOperations(methodKey, context, pageable).findAll(criteriaQuery);
    }

    protected final Set<JoinPath> getMethodJoinPaths(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.methodsJoinPaths.computeIfAbsent(methodKey, repositoryMethodKey -> AssociationUtils.getJoinPaths((AnnotationMetadata)context));
    }

    @Override
    @NonNull
    protected Pageable getPageable(MethodInvocationContext<?, ?> context) {
        for (Object param : context.getParameterValues()) {
            if (!(param instanceof Pageable)) continue;
            Pageable pageable = (Pageable)param;
            return pageable;
        }
        for (Object param : context.getParameterValues()) {
            if (!(param instanceof Sort)) continue;
            Sort sort = (Sort)param;
            return Pageable.UNPAGED.orders(sort.getOrderBy());
        }
        return Pageable.UNPAGED;
    }

    @NonNull
    protected final QueryBuilder getQueryBuilder(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.sqlQueryBuilderForRepositories.computeIfAbsent(methodKey, repositoryMethodKey -> {
            Class builder = (Class)context.getAnnotationMetadata().classValue(RepositoryConfiguration.class, "queryBuilder").orElseThrow(() -> new IllegalStateException("Cannot determine QueryBuilder"));
            BeanIntrospection introspection = BeanIntrospection.getIntrospection((Class)builder);
            if (introspection.getConstructorArguments().length == 1 && introspection.getConstructorArguments()[0].getType() == AnnotationMetadata.class) {
                return (QueryBuilder)introspection.instantiate(new Object[]{context.getAnnotationMetadata()});
            }
            return (QueryBuilder)introspection.instantiate();
        });
    }

    @NonNull
    protected final <E> CriteriaQuery<E> buildExistsQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.getCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context)).build(this.criteriaBuilder);
    }

    @NonNull
    protected final <E> CriteriaUpdate<E> buildUpdateQuery(MethodInvocationContext<?, ?> context) {
        return this.getCriteriaUpdateBuilder(context).build(this.criteriaBuilder);
    }

    @NonNull
    protected final <E> CriteriaDelete<E> buildDeleteQuery(MethodInvocationContext<?, ?> context) {
        return this.getCriteriaDeleteBuilder(context).build(this.criteriaBuilder);
    }

    @NonNull
    protected final CriteriaQuery<Long> buildCountQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.getCountCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context)).build(this.criteriaBuilder);
    }

    @NonNull
    protected final <N> CriteriaQuery<N> buildQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.getCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context)).build(this.criteriaBuilder);
    }

    private <N> void appendSort(Sort sort, CriteriaQuery<N> criteriaQuery, Root<?> root) {
        if (sort.isSorted()) {
            criteriaQuery.orderBy(this.getOrders(sort, root, this.criteriaBuilder));
        }
    }

    protected final Pageable applyPaginationAndSort(Pageable pageable, CriteriaQuery<?> criteriaQuery, boolean singleResult) {
        Root root = (Root)criteriaQuery.getRoots().stream().findFirst().orElseThrow(() -> new IllegalStateException("The root not found!"));
        if (pageable instanceof CursoredPageable) {
            CursoredPageable cursored = (CursoredPageable)pageable;
            cursored = DefaultSqlPreparedQuery.enhancePageable(cursored, this.getPersistentEntity(root));
            pageable = cursored;
            this.buildCursorPagination(criteriaQuery, this.criteriaBuilder, cursored);
        }
        this.appendSort(pageable.getSort(), criteriaQuery, root);
        pageable = pageable.withoutSort();
        if (singleResult && pageable.getOffset() > 0L) {
            pageable = Pageable.from((int)pageable.getNumber(), (int)1);
        }
        if (pageable.isUnpaged()) {
            return pageable;
        }
        if (criteriaQuery instanceof PersistentEntityCriteriaQuery) {
            PersistentEntityCriteriaQuery persistentEntityCriteriaQuery = (PersistentEntityCriteriaQuery)criteriaQuery;
            long offset = pageable.getMode() == Pageable.Mode.OFFSET ? pageable.getOffset() : 0L;
            long limit = pageable.getSize();
            if (offset > 0L) {
                persistentEntityCriteriaQuery.offset((int)offset);
            }
            if (limit > 0L) {
                persistentEntityCriteriaQuery.limit((int)limit);
            }
            return Pageable.UNPAGED;
        }
        return pageable;
    }

    private void buildCursorPagination(CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder, CursoredPageable cursoredPageable) {
        if (cursoredPageable.cursor().isEmpty()) {
            return;
        }
        Pageable.Cursor cursor = (Pageable.Cursor)cursoredPageable.cursor().get();
        Sort sort = cursoredPageable.getSort();
        List orders = sort.getOrderBy();
        if (orders.size() != cursor.size()) {
            throw new IllegalArgumentException("The cursor must match the sorting size");
        }
        if (orders.isEmpty()) {
            throw new IllegalArgumentException("At least one sorting property must be supplied");
        }
        Root root = (Root)criteriaQuery.getRoots().iterator().next();
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>(orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(orders.size());
            for (int j = 0; j <= i; ++j) {
                String propertyName = ((Sort.Order)orders.get(j)).getProperty();
                Object value = cursor.get(i);
                Predicate predicate = ((Sort.Order)orders.get(i)).isAscending() ? (i == j ? criteriaBuilder.greaterThan((Expression)root.get(propertyName), (Comparable)value) : criteriaBuilder.equal((Expression)root.get(propertyName), value)) : (i == j ? criteriaBuilder.lessThan((Expression)root.get(propertyName), (Comparable)value) : criteriaBuilder.equal((Expression)root.get(propertyName), value));
                andPredicates.add(predicate);
            }
            orPredicates.add(criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        }
        Predicate predicate = criteriaBuilder.or(orPredicates.toArray(new Predicate[0]));
        Predicate restriction = criteriaQuery.getRestriction();
        if (restriction == null) {
            criteriaQuery.where((Expression)predicate);
        } else {
            criteriaQuery.where((Expression)criteriaBuilder.and((Expression)restriction, (Expression)predicate));
        }
    }

    protected final CriteriaQuery<Tuple> buildIdsQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Sort sort) {
        return this.getIdsCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context), sort).build(this.criteriaBuilder);
    }

    @Nullable
    protected <K> QuerySpecification<K> getQuerySpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)parameterValue;
            return querySpecification;
        }
        if (parameterValue instanceof PredicateSpecification) {
            PredicateSpecification predicateSpecification = (PredicateSpecification)parameterValue;
            return QuerySpecification.where((PredicateSpecification)predicateSpecification);
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(QuerySpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + QuerySpecification.class + " or " + PredicateSpecification.class);
    }

    @NonNull
    protected final <K> CriteriaQueryBuilder<K> getCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaQueryBuilder) {
            CriteriaQueryBuilder criteriaQueryBuilder = (CriteriaQueryBuilder)parameterValue;
            return criteriaQueryBuilder;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            QuerySpecification specification = this.getQuerySpecification(context);
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(rootEntity);
            Root root = criteriaQuery.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, criteriaBuilder)) != null) {
                criteriaQuery.where((Expression)predicate);
            }
            if (CollectionUtils.isNotEmpty((Collection)joinPaths)) {
                for (JoinPath joinPath : this.sortJoinPaths(joinPaths)) {
                    this.join(root, joinPath);
                }
            }
            return criteriaQuery;
        };
    }

    @NonNull
    protected final CriteriaQueryBuilder<Tuple> getIdsCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths, Sort sort) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaQueryBuilder) {
            throw new IllegalStateException("Criteria pagination doesn't support CriteriaQueryBuilder!");
        }
        return criteriaBuilder -> this.createSelectIdsCriteriaQuery(context, joinPaths, sort);
    }

    @NonNull
    private <K> CriteriaQuery<Tuple> createSelectIdsCriteriaQuery(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths, Sort sort) {
        Predicate predicate;
        Class rootEntity = this.getRequiredRootEntity(context);
        QuerySpecification<K> specification = this.getQuerySpecification(context);
        CriteriaQuery criteriaQuery = this.criteriaBuilder.createTupleQuery();
        Root root = criteriaQuery.from(rootEntity);
        ArrayList<Object> selection = new ArrayList<Object>();
        selection.add(this.getIdExpression(root));
        for (Sort.Order order : sort.getOrderBy()) {
            Root path = root;
            Iterator iterator = StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.').iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                if (iterator.hasNext()) {
                    path = ((From)path).join(next);
                    continue;
                }
                path = path.get(next);
            }
            selection.add(path);
        }
        criteriaQuery.multiselect(selection).distinct(true);
        if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, this.criteriaBuilder)) != null) {
            criteriaQuery.where((Expression)predicate);
        }
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            for (JoinPath joinPath : this.sortJoinPaths(joinPaths)) {
                this.join(root, joinPath);
            }
        }
        return criteriaQuery;
    }

    @NonNull
    private CriteriaQueryBuilder<Long> getCountCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, final Set<JoinPath> joinPaths) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaQueryBuilder) {
            final CriteriaQueryBuilder providedCriteriaQueryBuilder = (CriteriaQueryBuilder)parameterValue;
            return new CriteriaQueryBuilder<Long>(){

                public CriteriaQuery<Long> build(CriteriaBuilder criteriaBuilder) {
                    CriteriaQuery criteriaQuery = providedCriteriaQueryBuilder.build(criteriaBuilder);
                    Root root = (Root)criteriaQuery.getRoots().iterator().next();
                    Expression countExpression = !root.getJoins().isEmpty() || !joinPaths.isEmpty() ? criteriaBuilder.countDistinct(AbstractSpecificationInterceptor.this.getIdExpression(root)) : criteriaBuilder.count(AbstractSpecificationInterceptor.this.getIdExpression(root));
                    return criteriaQuery.select((Selection)countExpression);
                }
            };
        }
        return criteriaBuilder -> this.createPageCountCriteriaQuery(context, criteriaBuilder, joinPaths);
    }

    private <E> CriteriaQuery createPageCountCriteriaQuery(MethodInvocationContext<?, ?> context, CriteriaBuilder criteriaBuilder, Set<JoinPath> joinPaths) {
        Predicate predicate;
        Class rootEntity = this.getRequiredRootEntity(context);
        QuerySpecification specification = this.getQuerySpecification(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(rootEntity);
        if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, criteriaBuilder)) != null) {
            criteriaQuery.where((Expression)predicate);
        }
        Expression countExpression = !root.getJoins().isEmpty() || !joinPaths.isEmpty() ? criteriaBuilder.countDistinct(this.getIdExpression(root)) : criteriaBuilder.count(this.getIdExpression(root));
        return criteriaQuery.select((Selection)countExpression);
    }

    protected final Expression<?> getIdExpression(Root<?> root) {
        if (root instanceof PersistentEntityRoot) {
            PersistentEntityRoot persistentEntityRoot = (PersistentEntityRoot)root;
            return persistentEntityRoot.id();
        }
        return root.get(this.getPersistentEntity(root).getIdentity().getName());
    }

    final PersistentEntity getPersistentEntity(Root<?> root) {
        if (root instanceof PersistentEntityRoot) {
            PersistentEntityRoot persistentEntityRoot = (PersistentEntityRoot)root;
            return persistentEntityRoot.getPersistentEntity();
        }
        return this.operations.getEntity(root.getModel().getJavaType());
    }

    private void join(Root<?> root, JoinPath joinPath) {
        if (root instanceof PersistentEntityFrom) {
            PersistentEntityFrom persistentEntityFrom = (PersistentEntityFrom)root;
            Optional optAlias = joinPath.getAlias();
            if (optAlias.isPresent()) {
                persistentEntityFrom.join(joinPath.getPath(), joinPath.getJoinType(), (String)optAlias.get());
            } else {
                persistentEntityFrom.join(joinPath.getPath(), joinPath.getJoinType());
            }
        }
    }

    @Nullable
    protected <K> DeleteSpecification<K> getDeleteSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof DeleteSpecification) {
            DeleteSpecification deleteSpecification = (DeleteSpecification)parameterValue;
            return deleteSpecification;
        }
        if (parameterValue instanceof PredicateSpecification) {
            PredicateSpecification predicateSpecification = (PredicateSpecification)parameterValue;
            return DeleteSpecification.where((PredicateSpecification)predicateSpecification);
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(DeleteSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + DeleteSpecification.class + " or " + PredicateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaDeleteBuilder<K> getCriteriaDeleteBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaDeleteBuilder) {
            CriteriaDeleteBuilder criteriaDeleteBuilder = (CriteriaDeleteBuilder)parameterValue;
            return criteriaDeleteBuilder;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            DeleteSpecification specification = this.getDeleteSpecification(context);
            CriteriaDelete criteriaDelete = criteriaBuilder.createCriteriaDelete(rootEntity);
            Root root = criteriaDelete.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaDelete, criteriaBuilder)) != null) {
                criteriaDelete.where((Expression)predicate);
            }
            return criteriaDelete;
        };
    }

    @Nullable
    protected <K> UpdateSpecification<K> getUpdateSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof UpdateSpecification) {
            UpdateSpecification updateSpecification = (UpdateSpecification)parameterValue;
            return updateSpecification;
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(UpdateSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + UpdateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaUpdateBuilder<K> getCriteriaUpdateBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaUpdateBuilder) {
            CriteriaUpdateBuilder criteriaUpdateBuilder = (CriteriaUpdateBuilder)parameterValue;
            return criteriaUpdateBuilder;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            UpdateSpecification specification = this.getUpdateSpecification(context);
            CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(rootEntity);
            Root root = criteriaUpdate.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaUpdate, criteriaBuilder)) != null) {
                criteriaUpdate.where((Expression)predicate);
            }
            return criteriaUpdate;
        };
    }

    private List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Expression path = root;
            Iterator iterator = StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.').iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                if (iterator.hasNext()) {
                    path = ((From)path).join(next);
                    continue;
                }
                path = path.get(next);
            }
            Expression expression = order.isIgnoreCase() ? cb.lower(path.type().as(String.class)) : path;
            orders.add(order.isAscending() ? cb.asc(expression) : cb.desc(expression));
        }
        return orders;
    }

    private List<JoinPath> sortJoinPaths(Collection<JoinPath> joinPaths) {
        ArrayList<JoinPath> sortedJoinPaths = new ArrayList<JoinPath>(joinPaths);
        sortedJoinPaths.sort((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare(o1.getPath(), o2.getPath()));
        return sortedJoinPaths;
    }

    protected static enum Type {
        COUNT,
        FIND_ONE,
        FIND_PAGE,
        FIND_ALL,
        DELETE_ALL,
        UPDATE_ALL,
        EXISTS;

    }
}

