/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.FindCursoredAsyncPageInterceptor;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractConvertCompletionStageInterceptor;
import java.util.List;
import java.util.concurrent.CompletionStage;

@Internal
public final class DefaultFindCursoredPageAsyncInterceptor
extends AbstractConvertCompletionStageInterceptor<CursoredPage<Object>>
implements FindCursoredAsyncPageInterceptor<Object> {
    public DefaultFindCursoredPageAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    @Override
    protected CompletionStage<?> interceptCompletionStage(RepositoryMethodKey methodKey, MethodInvocationContext<Object, CompletionStage<CursoredPage<Object>>> context) {
        Argument returnArgument;
        ReturnType returnType = context.getReturnType();
        Argument argument = returnArgument = returnType.isSuspended() ? returnType.asArgument() : returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            return this.asyncDatastoreOperations.findPage(preparedQuery).thenApply(page -> {
                if (!page.hasTotalSize() && preparedQuery.getPageable().requestTotal()) {
                    PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
                    Number n = (Number)this.operations.findOne(countQuery);
                    Long totalCount = n != null ? n.longValue() : -1L;
                    if (page instanceof CursoredPage) {
                        CursoredPage cursoredPage = (CursoredPage)page;
                        page = CursoredPage.of((List)cursoredPage.getContent(), (Pageable)cursoredPage.getPageable(), (List)cursoredPage.getCursors(), (Long)totalCount);
                    } else {
                        page = Page.of((List)page.getContent(), (Pageable)page.getPageable(), (Long)totalCount);
                    }
                }
                if (returnArgument.isInstance(page)) {
                    return page;
                }
                return this.operations.getConversionService().convert(page, returnArgument).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnArgument));
            });
        }
        return this.asyncDatastoreOperations.findPage(this.getPagedQuery(context)).thenApply(page -> {
            if (returnArgument.isInstance(page)) {
                return page;
            }
            return this.operations.getConversionService().convert(page, returnArgument).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnArgument));
        });
    }
}

