/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.FindSliceReactiveInterceptor;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Slice;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractPublisherInterceptor;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DefaultFindSliceReactiveInterceptor
extends AbstractPublisherInterceptor
implements FindSliceReactiveInterceptor<Object, Object> {
    protected DefaultFindSliceReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    @Override
    public Publisher<?> interceptPublisher(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            Pageable pageable = preparedQuery.getPageable();
            return Flux.from((Publisher)this.reactiveOperations.findAll(preparedQuery)).collectList().map(objects -> Slice.of((List)objects, (Pageable)pageable));
        }
        PagedQuery pagedQuery = this.getPagedQuery(context);
        return Flux.from((Publisher)this.reactiveOperations.findAll(pagedQuery)).collectList().map(objects -> Slice.of((List)objects, (Pageable)pagedQuery.getPageable()));
    }
}

