/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.operations.CriteriaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractPreparedQueryCriteriaRepositoryOperations;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.List;
import java.util.Optional;

@Internal
final class PreparedQueryCriteriaRepositoryOperations
extends AbstractPreparedQueryCriteriaRepositoryOperations
implements CriteriaRepositoryOperations {
    private final CriteriaBuilder criteriaBuilder;
    private final RepositoryOperations operations;

    public PreparedQueryCriteriaRepositoryOperations(CriteriaBuilder criteriaBuilder, RepositoryOperations operations, MethodInvocationContext<?, ?> context, QueryBuilder queryBuilder, Class<?> entityRoot, Pageable pageable) {
        super(operations, context, queryBuilder, entityRoot, pageable);
        this.criteriaBuilder = criteriaBuilder;
        this.operations = operations;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public boolean exists(CriteriaQuery<?> query) {
        return this.operations.exists(this.createExists(query));
    }

    public <K> K findOne(CriteriaQuery<K> query) {
        return (K)this.operations.findOne(this.createFindOne(query));
    }

    public <K> List<K> findAll(CriteriaQuery<K> query) {
        return CollectionUtils.iterableToList((Iterable)this.operations.findAll(this.createFindAll(query)));
    }

    public <K> List<K> findAll(CriteriaQuery<K> query, int offset, int limit) {
        throw new IllegalStateException("Not supported!");
    }

    public Optional<Number> updateAll(CriteriaUpdate<Number> query) {
        return this.operations.executeUpdate(this.createUpdateAll(query));
    }

    public Optional<Number> deleteAll(CriteriaDelete<Number> query) {
        return this.operations.executeDelete(this.createDeleteAll(query));
    }
}

