/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.intercept.DataInterceptorResolver;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.transaction.interceptor.TxCompletionStageDataIntroductionHelper;
import jakarta.inject.Inject;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

@InterceptorBean(value={Repository.class})
@Prototype
@Internal
public final class DataIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private final DataInterceptorResolver dataInterceptorResolver;
    private final TxCompletionStageDataIntroductionHelper completionStageHelper;
    @Nullable
    private final InjectionPoint<?> injectionPoint;
    private final DataConversionService conversionService;

    @Inject
    public DataIntroductionAdvice(@NonNull DataInterceptorResolver dataInterceptorResolver, @Nullable TxCompletionStageDataIntroductionHelper completionStageHelper, @Nullable InjectionPoint<?> injectionPoint, DataConversionService conversionService) {
        this.dataInterceptorResolver = dataInterceptorResolver;
        this.completionStageHelper = completionStageHelper;
        this.injectionPoint = injectionPoint;
        this.conversionService = conversionService;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        RepositoryMethodKey key = new RepositoryMethodKey(context.getTarget(), context.getExecutableMethod());
        DataInterceptor<Object, Object> dataInterceptor = this.dataInterceptorResolver.resolve(key, context, this.injectionPoint);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            return switch (interceptedMethod.resultType()) {
                default -> throw new IncompatibleClassChangeError();
                case InterceptedMethod.ResultType.PUBLISHER -> interceptedMethod.handleResult(dataInterceptor.intercept(key, context));
                case InterceptedMethod.ResultType.COMPLETION_STAGE -> interceptedMethod.handleResult(this.interceptCompletionStage(interceptedMethod, context, dataInterceptor, key));
                case InterceptedMethod.ResultType.SYNCHRONOUS -> dataInterceptor.intercept(key, context);
            };
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    private Object interceptCompletionStage(InterceptedMethod interceptedMethod, MethodInvocationContext<Object, Object> context, DataInterceptor<Object, Object> dataInterceptor, RepositoryMethodKey key) {
        CompletionStage completionStage = this.completionStageHelper != null ? this.completionStageHelper.decorate(interceptedMethod, () -> (CompletionStage)dataInterceptor.intercept(key, context)) : (CompletionStage)dataInterceptor.intercept(key, context);
        CompletableFuture completableFuture = new CompletableFuture();
        completionStage.whenComplete((value, throwable) -> {
            if (throwable == null) {
                completableFuture.complete(value);
            } else {
                Throwable finalThrowable = throwable;
                if (finalThrowable instanceof CompletionException) {
                    finalThrowable = finalThrowable.getCause();
                }
                if (finalThrowable instanceof EmptyResultException && context.isSuspend() && context.isNullable()) {
                    completableFuture.complete(null);
                } else {
                    completableFuture.completeExceptionally(finalThrowable);
                }
            }
        });
        return completableFuture;
    }
}

