/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.jpa.criteria.CriteriaDeleteBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaQueryBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaUpdateBuilder;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.data.runtime.criteria.RuntimeCriteriaBuilder;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import io.micronaut.data.runtime.query.internal.QueryResultStoredQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    private final Map<RepositoryMethodKey, QueryBuilder> sqlQueryBuilderForRepositories = new ConcurrentHashMap<RepositoryMethodKey, QueryBuilder>();
    private final RuntimeCriteriaBuilder criteriaBuilder;
    private final MethodContextAwareStoredQueryDecorator storedQueryDecorator;
    private final PreparedQueryDecorator preparedQueryDecorator;

    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        this.criteriaBuilder = (RuntimeCriteriaBuilder)((Object)operations.getApplicationContext().getBean(RuntimeCriteriaBuilder.class));
        if (operations instanceof MethodContextAwareStoredQueryDecorator) {
            this.storedQueryDecorator = (MethodContextAwareStoredQueryDecorator)operations;
        } else if (operations instanceof StoredQueryDecorator) {
            final StoredQueryDecorator decorator = (StoredQueryDecorator)operations;
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return decorator.decorate(storedQuery);
                }
            };
        } else {
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return storedQuery;
                }
            };
        }
        this.preparedQueryDecorator = operations instanceof PreparedQueryDecorator ? (PreparedQueryDecorator)operations : new PreparedQueryDecorator(){

            public <E, K> PreparedQuery<E, K> decorate(PreparedQuery<E, K> preparedQuery) {
                return preparedQuery;
            }
        };
    }

    @NonNull
    protected final <E, QR> PreparedQuery<E, QR> preparedQueryForCriteria(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type) {
        Object storedQuery;
        Pageable pageable = Pageable.UNPAGED;
        for (Object param : context.getParameterValues()) {
            if (!(param instanceof Pageable)) continue;
            pageable = (Pageable)param;
            break;
        }
        QueryBuilder sqlQueryBuilder = this.sqlQueryBuilderForRepositories.computeIfAbsent(methodKey, repositoryMethodKey -> {
            Class builder = (Class)context.getAnnotationMetadata().classValue(RepositoryConfiguration.class, "queryBuilder").orElseThrow(() -> new IllegalStateException("Cannot determine QueryBuilder"));
            BeanIntrospection introspection = BeanIntrospection.getIntrospection((Class)builder);
            if (introspection.getConstructorArguments().length == 1 && introspection.getConstructorArguments()[0].getType() == AnnotationMetadata.class) {
                return (QueryBuilder)introspection.instantiate(new Object[]{context.getAnnotationMetadata()});
            }
            return (QueryBuilder)introspection.instantiate();
        });
        if (type == Type.FIND_ALL || type == Type.FIND_ONE || type == Type.FIND_PAGE) {
            storedQuery = this.buildFind(context, type, pageable, sqlQueryBuilder);
        } else if (type == Type.COUNT) {
            storedQuery = this.buildCount(context, sqlQueryBuilder);
        } else if (type == Type.DELETE_ALL) {
            storedQuery = this.buildDeleteAll(context, sqlQueryBuilder);
        } else if (type == Type.UPDATE_ALL) {
            storedQuery = this.buildUpdateAll(context, sqlQueryBuilder);
        } else {
            throw new IllegalStateException("Unknown criteria type: " + (Object)((Object)type));
        }
        storedQuery = this.storedQueryDecorator.decorate(context, storedQuery);
        PreparedQuery<E, Object> preparedQuery = this.preparedQueryResolver.resolveQuery(context, storedQuery, pageable);
        return this.preparedQueryDecorator.decorate(preparedQuery);
    }

    private <E> StoredQuery<E, ?> buildUpdateAll(MethodInvocationContext<T, R> context, QueryBuilder sqlQueryBuilder) {
        CriteriaUpdateBuilder criteriaUpdateBuilder = this.getCriteriaUpdateBuilder(context);
        CriteriaUpdate criteriaUpdate = criteriaUpdateBuilder.build((CriteriaBuilder)this.criteriaBuilder);
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaUpdate).buildQuery(sqlQueryBuilder);
        return QueryResultStoredQuery.single(DataMethod.OperationType.UPDATE, context.getName(), context.getAnnotationMetadata(), queryResult, criteriaUpdate.getRoot().getJavaType());
    }

    private <E> StoredQuery<E, ?> buildDeleteAll(MethodInvocationContext<T, R> context, QueryBuilder sqlQueryBuilder) {
        CriteriaDeleteBuilder criteriaDeleteBuilder = this.getCriteriaDeleteBuilder(context);
        CriteriaDelete criteriaDelete = criteriaDeleteBuilder.build((CriteriaBuilder)this.criteriaBuilder);
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaDelete).buildQuery(sqlQueryBuilder);
        return QueryResultStoredQuery.single(DataMethod.OperationType.DELETE, context.getName(), context.getAnnotationMetadata(), queryResult, criteriaDelete.getRoot().getJavaType());
    }

    private <E> StoredQuery<E, ?> buildCount(MethodInvocationContext<T, R> context, QueryBuilder sqlQueryBuilder) {
        Predicate predicate;
        Class rootEntity = this.getRequiredRootEntity(context);
        QuerySpecification specification = this.getQuerySpecification(context);
        PersistentEntityCriteriaQuery<Long> criteriaQuery = this.criteriaBuilder.createQuery(Long.class);
        PersistentEntityRoot root = criteriaQuery.from(rootEntity);
        if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaQuery, (CriteriaBuilder)this.criteriaBuilder)) != null) {
            criteriaQuery.where((Expression)predicate);
        }
        criteriaQuery.select((Selection)this.criteriaBuilder.count((Expression)root));
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery(sqlQueryBuilder);
        QueryResultStoredQuery storedQuery = QueryResultStoredQuery.count(context.getName(), context.getAnnotationMetadata(), queryResult, rootEntity);
        return storedQuery;
    }

    private <E> StoredQuery<E, Object> buildFind(MethodInvocationContext<T, R> context, Type type, Pageable pageable, QueryBuilder sqlQueryBuilder) {
        Class rootEntity = this.getRequiredRootEntity(context);
        CriteriaQueryBuilder builder = this.getCriteriaQueryBuilder(context);
        CriteriaQuery criteriaQuery = builder.build((CriteriaBuilder)this.criteriaBuilder);
        if (type == Type.FIND_ALL) {
            for (Object param : context.getParameterValues()) {
                Sort sort;
                if (!(param instanceof Sort) || param == pageable || !(sort = (Sort)param).isSorted()) continue;
                Root root = (Root)criteriaQuery.getRoots().stream().findFirst().orElseThrow(() -> new IllegalStateException("The root not found!"));
                criteriaQuery.orderBy(this.getOrders(sort, root, (CriteriaBuilder)this.criteriaBuilder));
                break;
            }
        }
        QueryResultPersistentEntityCriteriaQuery queryModelCriteriaQuery = (QueryResultPersistentEntityCriteriaQuery)criteriaQuery;
        QueryModel queryModel = queryModelCriteriaQuery.getQueryModel();
        Collection joinPaths = queryModel.getJoinPaths();
        QueryResult queryResult = sqlQueryBuilder.buildQuery(queryModel);
        if (type == Type.FIND_ONE) {
            return QueryResultStoredQuery.single(DataMethod.OperationType.QUERY, context.getName(), context.getAnnotationMetadata(), queryResult, rootEntity, criteriaQuery.getResultType(), joinPaths);
        }
        return QueryResultStoredQuery.many(context.getName(), context.getAnnotationMetadata(), queryResult, rootEntity, criteriaQuery.getResultType(), !pageable.isUnpaged(), joinPaths);
    }

    @Nullable
    protected <K> QuerySpecification<K> getQuerySpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof QuerySpecification) {
            return (QuerySpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return QuerySpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(QuerySpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + QuerySpecification.class + " or " + PredicateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaQueryBuilder<K> getCriteriaQueryBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaQueryBuilder) {
            return (CriteriaQueryBuilder)parameterValue;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            QuerySpecification specification = this.getQuerySpecification(context);
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(rootEntity);
            Root root = criteriaQuery.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, criteriaBuilder)) != null) {
                criteriaQuery.where((Expression)predicate);
            }
            return criteriaQuery;
        };
    }

    @Nullable
    protected <K> DeleteSpecification<K> getDeleteSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof DeleteSpecification) {
            return (DeleteSpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return DeleteSpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(DeleteSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + DeleteSpecification.class + " or " + PredicateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaDeleteBuilder<K> getCriteriaDeleteBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaDeleteBuilder) {
            return (CriteriaDeleteBuilder)parameterValue;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            DeleteSpecification specification = this.getDeleteSpecification(context);
            CriteriaDelete criteriaDelete = criteriaBuilder.createCriteriaDelete(rootEntity);
            Root root = criteriaDelete.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaDelete, criteriaBuilder)) != null) {
                criteriaDelete.where((Expression)predicate);
            }
            return criteriaDelete;
        };
    }

    @Nullable
    protected <K> UpdateSpecification<K> getUpdateSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof UpdateSpecification) {
            return (UpdateSpecification)parameterValue;
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(UpdateSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + UpdateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaUpdateBuilder<K> getCriteriaUpdateBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaUpdateBuilder) {
            return (CriteriaUpdateBuilder)parameterValue;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            UpdateSpecification specification = this.getUpdateSpecification(context);
            CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(rootEntity);
            Root root = criteriaUpdate.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaUpdate, criteriaBuilder)) != null) {
                criteriaUpdate.where((Expression)predicate);
            }
            return criteriaUpdate;
        };
    }

    private List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root.get(order.getProperty());
            orders.add(order.isAscending() ? cb.asc((Expression)propertyPath) : cb.desc((Expression)propertyPath));
        }
        return orders;
    }

    protected static enum Type {
        COUNT,
        FIND_ONE,
        FIND_PAGE,
        FIND_ALL,
        DELETE_ALL,
        UPDATE_ALL;

    }
}

