/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
final class DefaultSqlStoredQuery<E, R>
implements SqlStoredQuery<E, R>,
DelegateStoredQuery<E, R> {
    private final StoredQuery<E, R> storedQuery;
    private final RuntimePersistentEntity<E> runtimePersistentEntity;
    private final boolean expandableQuery;
    private final SqlQueryBuilder queryBuilder;

    public DefaultSqlStoredQuery(StoredQuery<E, R> storedQuery, RuntimePersistentEntity<E> runtimePersistentEntity, SqlQueryBuilder queryBuilder) {
        this.storedQuery = storedQuery;
        this.runtimePersistentEntity = runtimePersistentEntity;
        this.queryBuilder = queryBuilder;
        Objects.requireNonNull(storedQuery, "Query cannot be null");
        Objects.requireNonNull(queryBuilder, "Builder cannot be null");
        Object[] expandableQueryParts = storedQuery.getExpandableQueryParts();
        List queryParameterBindings = storedQuery.getQueryBindings();
        boolean bl = this.expandableQuery = expandableQueryParts.length > 1 && queryParameterBindings.stream().anyMatch(QueryParameterBinding::isExpandable);
        if (this.expandableQuery && expandableQueryParts.length != queryParameterBindings.size() + 1) {
            throw new IllegalStateException("Expandable query parts size should be the same as parameters size + 1. " + expandableQueryParts.length + " != 1 + " + queryParameterBindings.size() + " " + storedQuery.getQuery() + " " + Arrays.toString(expandableQueryParts));
        }
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.runtimePersistentEntity;
    }

    @Override
    public boolean isExpandableQuery() {
        return this.expandableQuery;
    }

    @Override
    public StoredQuery<E, R> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    @Override
    public Dialect getDialect() {
        return this.queryBuilder.getDialect();
    }

    @Override
    public SqlQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Override
    public Map<QueryParameterBinding, Object> collectAutoPopulatedPreviousValues(E entity) {
        if (this.storedQuery.getQueryBindings().isEmpty()) {
            return null;
        }
        return this.storedQuery.getQueryBindings().stream().filter(b -> b.isAutoPopulated() && b.isRequiresPreviousPopulatedValue()).map(b -> {
            if (b.getPropertyPath() == null) {
                throw new IllegalStateException("Missing property path for query parameter: " + b);
            }
            Object value = entity;
            for (String property : b.getPropertyPath()) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return new AbstractMap.SimpleEntry<QueryParameterBinding, Object>((QueryParameterBinding)b, value);
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    @Override
    public void bindParameters(SqlStoredQuery.Binder binder, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity, @Nullable Map<QueryParameterBinding, Object> previousValues) {
        for (QueryParameterBinding queryParameterBinding : this.storedQuery.getQueryBindings()) {
            this.bindParameter(binder, invocationContext, entity, previousValues, queryParameterBinding);
        }
    }

    private void bindParameter(SqlStoredQuery.Binder binder, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity, @Nullable Map<QueryParameterBinding, Object> previousValues, QueryParameterBinding binding) {
        List<Object> values;
        RuntimePersistentEntity<E> persistentEntity = this.getPersistentEntity();
        Class parameterConverter = binding.getParameterConverterClass();
        DataType dataType = binding.getDataType();
        Object value = binding.getValue();
        RuntimePersistentProperty persistentProperty = null;
        Argument argument = null;
        if (value == null) {
            PersistentPropertyPath pp;
            if (binding.getParameterIndex() != -1) {
                this.requireInvocationContext(invocationContext);
                value = this.resolveParameterValue(binding, invocationContext.getParameterValues());
                argument = invocationContext.getArguments()[binding.getParameterIndex()];
            } else if (binding.isAutoPopulated()) {
                pp = this.getRequiredPropertyPath(binding, persistentEntity);
                persistentProperty = (RuntimePersistentProperty)pp.getProperty();
                if (binding.isRequiresPreviousPopulatedValue()) {
                    if (previousValues != null) {
                        value = previousValues.get(binding);
                    }
                } else if (entity == null) {
                    Object previousValue = null;
                    QueryParameterBinding previousPopulatedValueParameter = binding.getPreviousPopulatedValueParameter();
                    if (previousPopulatedValueParameter != null) {
                        if (previousPopulatedValueParameter.getParameterIndex() == -1) {
                            throw new IllegalStateException("Previous value parameter cannot be bind!");
                        }
                        this.requireInvocationContext(invocationContext);
                        previousValue = this.resolveParameterValue(previousPopulatedValueParameter, invocationContext.getParameterValues());
                    }
                    value = binder.autoPopulateRuntimeProperty(persistentProperty, previousValue);
                } else {
                    value = pp.getPropertyValue(entity);
                }
                value = binder.convert(value, persistentProperty);
                parameterConverter = null;
            } else if (entity != null) {
                pp = this.getRequiredPropertyPath(binding, persistentEntity);
                value = pp.getPropertyValue(entity);
                persistentProperty = (RuntimePersistentProperty)pp.getProperty();
            } else {
                throw new IllegalStateException("Invalid query [" + this.getQuery() + "]. Unable to establish parameter value for parameter at position: " + binder.currentIndex());
            }
        }
        if (persistentProperty != null) {
            argument = persistentProperty.getArgument();
            dataType = persistentProperty.getDataType();
        }
        List<Object> list = values = binding.isExpandable() ? this.expandValue(value, dataType) : Collections.singletonList(value);
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        }
        if (values == null) {
            if (parameterConverter != null) {
                value = binder.convert(parameterConverter, value, argument);
            } else if (persistentProperty != null) {
                value = binder.convert(value, persistentProperty);
            }
            binder.bind(dataType, value);
        } else {
            for (Object v : values) {
                if (parameterConverter != null) {
                    v = binder.convert(parameterConverter, v, argument);
                } else if (persistentProperty != null) {
                    v = binder.convert(v, persistentProperty);
                }
                binder.bind(dataType, v);
            }
        }
    }

    private Object resolveParameterValue(QueryParameterBinding queryParameterBinding, Object[] parameterArray) {
        Object value = parameterArray[queryParameterBinding.getParameterIndex()];
        String[] parameterBindingPath = queryParameterBinding.getParameterBindingPath();
        if (parameterBindingPath != null) {
            for (String prop : parameterBindingPath) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(prop, Argument.OBJECT_ARGUMENT);
            }
        }
        return value;
    }

    private List<Object> expandValue(Object value, DataType dataType) {
        if (value == null || dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            return CollectionUtils.iterableToList((Iterable)((Iterable)value));
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    private <T> PersistentPropertyPath getRequiredPropertyPath(QueryParameterBinding queryParameterBinding, RuntimePersistentEntity<T> persistentEntity) {
        CharSequence[] propertyPath = queryParameterBinding.getRequiredPropertyPath();
        PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])propertyPath);
        if (pp == null) {
            throw new IllegalStateException("Cannot find property: " + String.join((CharSequence)".", propertyPath));
        }
        return pp;
    }

    private void requireInvocationContext(InvocationContext<?, ?> invocationContext) {
        if (invocationContext == null) {
            throw new IllegalStateException("Invocation context is required!");
        }
    }
}

