/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
public class StoredSqlOperation
extends DBOperation {
    protected final List<QueryParameterBinding> queryParameterBindings;
    protected final boolean isOptimisticLock;
    protected final String[] expandableQueryParts;
    protected final boolean expandableQuery;
    protected final SqlQueryBuilder queryBuilder;

    protected StoredSqlOperation(SqlQueryBuilder queryBuilder, String query, @Nullable String[] expandableQueryParts, List<QueryParameterBinding> queryParameterBindings, boolean isOptimisticLock) {
        super(query, queryBuilder.dialect());
        this.queryBuilder = queryBuilder;
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(this.dialect, "Dialect cannot be null");
        this.queryParameterBindings = queryParameterBindings;
        this.isOptimisticLock = isOptimisticLock;
        this.expandableQueryParts = expandableQueryParts;
        boolean bl = this.expandableQuery = expandableQueryParts != null && expandableQueryParts.length > 1 && queryParameterBindings.stream().anyMatch(QueryParameterBinding::isExpandable);
        if (this.expandableQuery && expandableQueryParts.length != queryParameterBindings.size() + 1) {
            throw new IllegalStateException("Expandable query parts size should be the same as parameters size + 1. " + expandableQueryParts.length + " != 1 + " + queryParameterBindings.size() + " " + query + " " + Arrays.toString(expandableQueryParts));
        }
    }

    @Override
    public boolean isOptimisticLock() {
        return this.isOptimisticLock;
    }

    @Override
    public <T> Map<QueryParameterBinding, Object> collectAutoPopulatedPreviousValues(RuntimePersistentEntity<T> persistentEntity, T entity) {
        if (this.queryParameterBindings.isEmpty()) {
            return null;
        }
        return this.queryParameterBindings.stream().filter(b -> b.isAutoPopulated() && b.isRequiresPreviousPopulatedValue()).map(b -> {
            if (b.getPropertyPath() == null) {
                throw new IllegalStateException("Missing property path for query parameter: " + b);
            }
            Object value = entity;
            for (String property : b.getPropertyPath()) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return new AbstractMap.SimpleEntry<QueryParameterBinding, Object>((QueryParameterBinding)b, value);
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public <T> void checkForParameterToBeExpanded(RuntimePersistentEntity<T> persistentEntity, T entity) {
        if (this.expandableQuery) {
            String positionalParameterFormat = this.queryBuilder.positionalParameterFormat();
            StringBuilder q = new StringBuilder(this.expandableQueryParts[0]);
            int queryParamIndex = 1;
            int inx = 1;
            for (QueryParameterBinding parameter : this.queryParameterBindings) {
                if (!parameter.isExpandable()) {
                    q.append(String.format(positionalParameterFormat, inx++));
                } else {
                    int size = Math.max(1, this.getQueryParameterValueSize(parameter, persistentEntity, entity));
                    for (int k = 0; k < size; ++k) {
                        q.append(String.format(positionalParameterFormat, inx++));
                        if (k + 1 == size) continue;
                        q.append(",");
                    }
                }
                q.append(this.expandableQueryParts[queryParamIndex++]);
            }
            this.query = q.toString();
        }
    }

    protected <T> int getQueryParameterValueSize(QueryParameterBinding parameter, RuntimePersistentEntity<T> persistentEntity, T entity) {
        CharSequence[] stringPropertyPath = parameter.getRequiredPropertyPath();
        PersistentPropertyPath propertyPath = persistentEntity.getPropertyPath((String[])stringPropertyPath);
        if (propertyPath == null) {
            throw new IllegalStateException("Unrecognized path: " + String.join((CharSequence)".", stringPropertyPath));
        }
        return this.sizeOf(propertyPath.getPropertyValue(entity));
    }

    @Override
    public <T, Cnt, PS> void setParameters(OpContext<Cnt, PS> context, Cnt connection, PS stmt, RuntimePersistentEntity<T> persistentEntity, T entity, Map<QueryParameterBinding, Object> previousValues) {
        int index = context.shiftIndex(0);
        for (QueryParameterBinding binding : this.queryParameterBindings) {
            CharSequence[] stringPropertyPath = binding.getRequiredPropertyPath();
            PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])stringPropertyPath);
            if (pp == null) {
                throw new IllegalStateException("Unrecognized path: " + String.join((CharSequence)".", stringPropertyPath));
            }
            if (binding.isAutoPopulated() && binding.isRequiresPreviousPopulatedValue()) {
                Object previousValue;
                if (previousValues == null || (previousValue = previousValues.get(binding)) == null) continue;
                index = this.setStatementParameter(context, stmt, index, pp.getProperty().getDataType(), previousValue, this.dialect, binding.isExpandable());
                continue;
            }
            Object value = pp.getPropertyValue(entity);
            RuntimePersistentProperty property = (RuntimePersistentProperty)pp.getProperty();
            DataType type = property.getDataType();
            if (value == null && type == DataType.ENTITY) {
                RuntimePersistentEntity referencedEntity = context.getEntity(property.getType());
                RuntimePersistentProperty identity = referencedEntity.getIdentity();
                if (identity == null) {
                    throw new IllegalStateException("Cannot set an entity value without identity: " + referencedEntity);
                }
                property = identity;
                type = identity.getDataType();
            }
            value = context.convert(connection, value, property);
            index = this.setStatementParameter(context, stmt, index, type, value, this.dialect, binding.isExpandable());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <PS> int setStatementParameter(OpContext<?, PS> context, PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect, boolean isExpandable) {
        List<Object> values;
        if (!this.expandableQuery) {
            context.setStatementParameter(preparedStatement, index, dataType, value, dialect);
            return index + 1;
        }
        List<Object> list = values = isExpandable ? this.expandValue(value, dataType) : Collections.singletonList(value);
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        }
        if (values == null) {
            context.setStatementParameter(preparedStatement, index, dataType, value, dialect);
            return index + 1;
        }
        Iterator<Object> iterator = values.iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            context.setStatementParameter(preparedStatement, index, dataType, v, dialect);
            ++index;
        }
        return index;
    }

    List<Object> expandValue(Object value, DataType dataType) {
        if (value == null || dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            return CollectionUtils.iterableToList((Iterable)((Iterable)value));
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    protected int sizeOf(Object value) {
        if (value == null) {
            return 1;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object ignored : (Iterable)value) {
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    public SqlQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }
}

