/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Optional;

public class DefaultDeleteAllInterceptor<T>
extends AbstractQueryInterceptor<T, Number>
implements DeleteAllInterceptor<T> {
    protected DefaultDeleteAllInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Number> context) {
        Argument resultType = context.getReturnType().asArgument();
        Optional<Iterable<Object>> deleteEntities = this.findEntitiesParameter(context, Object.class);
        Optional<Object> deleteEntity = this.findEntityParameter(context, Object.class);
        if (!deleteEntity.isPresent() && !deleteEntities.isPresent()) {
            if (context.hasAnnotation(Query.class)) {
                PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
                Number result = this.operations.executeDelete(preparedQuery).orElse(0);
                return this.convertIfNecessary((Argument<Number>)resultType, result);
            }
            Number result = this.operations.deleteAll(this.getDeleteAllBatchOperation(context)).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, result);
        }
        Number result = this.operations.deleteAll(this.getDeleteBatchOperation(context, deleteEntities.get())).orElse(0);
        return this.convertIfNecessary((Argument<Number>)resultType, result);
    }

    private Number convertIfNecessary(Argument<Number> resultType, Number result) {
        if (!resultType.getType().isInstance(result)) {
            return this.operations.getConversionService().convert((Object)result, resultType).orElse(0);
        }
        return result;
    }
}

