/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.AbstractPreparedDataOperation;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.DefaultStoredDataOperation;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.EntityInstanceOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredDataOperation;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.inject.ExecutableMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public abstract class AbstractQueryInterceptor<T, R>
implements DataInterceptor<T, R> {
    private static final String DATA_METHOD_ANN_NAME = DataMethod.class.getName();
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    protected final RepositoryOperations operations;
    private final ConcurrentMap<RepositoryMethodKey, StoredQuery> countQueries = new ConcurrentHashMap<RepositoryMethodKey, StoredQuery>(50);
    private final ConcurrentMap<RepositoryMethodKey, StoredQuery> queries = new ConcurrentHashMap<RepositoryMethodKey, StoredQuery>(50);

    protected AbstractQueryInterceptor(@NonNull RepositoryOperations operations) {
        ArgumentUtils.requireNonNull((String)"operations", (Object)operations);
        this.operations = operations;
    }

    protected Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return context.getReturnType().asArgument();
    }

    @Nullable
    protected final Object convertOne(MethodInvocationContext<?, ?> context, @Nullable Object o) {
        Argument argumentType = this.getReturnType(context);
        Class type = argumentType.getType();
        if (o == null) {
            if (type == Optional.class) {
                return Optional.empty();
            }
            if (argumentType.isDeclaredNonNull() || !argumentType.isNullable() && !context.getReturnType().asArgument().isNullable()) {
                throw new EmptyResultException();
            }
            return null;
        }
        boolean isOptional = false;
        if (type == Optional.class) {
            argumentType = argumentType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            type = argumentType.getType();
            isOptional = true;
        }
        if (!type.isInstance(o)) {
            Object finalO = o;
            o = this.operations.getConversionService().convert(o, argumentType).orElseThrow(() -> new IllegalStateException("Unexpected return type: " + finalO));
        }
        if (isOptional) {
            return Optional.of(o);
        }
        return o;
    }

    protected final PreparedQuery<?, ?> prepareQuery(RepositoryMethodKey key, MethodInvocationContext<T, R> context) {
        return this.prepareQuery(key, context, null);
    }

    protected final <RT> PreparedQuery<?, RT> prepareQuery(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Class<RT> resultType) {
        this.validateNullArguments(context);
        StoredQuery storedQuery = this.findStoreQuery(methodKey, context, resultType);
        Pageable pageable = storedQuery.hasPageable() ? this.getPageable(context) : Pageable.UNPAGED;
        String query = storedQuery.getQuery();
        return new DefaultPreparedQuery(context, storedQuery, query, pageable, storedQuery.isDtoProjection());
    }

    private <E, RT> StoredQuery<E, RT> findStoreQuery(MethodInvocationContext<?, ?> context) {
        RepositoryMethodKey key = new RepositoryMethodKey(context.getTarget(), context.getExecutableMethod());
        return this.findStoreQuery(key, context, null);
    }

    private <E, RT> StoredQuery<E, RT> findStoreQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Class<RT> resultType) {
        DefaultStoredQuery storedQuery = (DefaultStoredQuery)((Object)this.queries.get(methodKey));
        if (storedQuery == null) {
            Class rootEntity = (Class)context.classValue(DATA_METHOD_ANN_NAME, "rootEntity").orElseThrow(() -> new IllegalStateException("No root entity present in method"));
            if (resultType == null) {
                resultType = context.classValue(DATA_METHOD_ANN_NAME, "resultType").orElse(rootEntity);
            }
            String query = (String)context.stringValue(Query.class).orElseThrow(() -> new IllegalStateException("No query present in method"));
            storedQuery = new DefaultStoredQuery(this, context.getExecutableMethod(), resultType, rootEntity, query, false);
            this.queries.put(methodKey, storedQuery);
        }
        return storedQuery;
    }

    protected final PreparedQuery<?, Number> prepareCountQuery(RepositoryMethodKey methodKey, @NonNull MethodInvocationContext<T, R> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        DefaultStoredQuery storedQuery = (DefaultStoredQuery)((Object)this.countQueries.get(methodKey));
        if (storedQuery == null) {
            String query = (String)context.stringValue(Query.class, "countQuery").orElseThrow(() -> new IllegalStateException("No query present in method"));
            Class rootEntity = this.getRequiredRootEntity(context);
            storedQuery = new DefaultStoredQuery(this, executableMethod, Long.class, rootEntity, query, true);
            this.countQueries.put(methodKey, storedQuery);
        }
        Pageable pageable = storedQuery.hasPageable() ? this.getPageable(context) : Pageable.UNPAGED;
        return new DefaultPreparedQuery(context, storedQuery, storedQuery.getQuery(), pageable, false);
    }

    @NonNull
    protected <E> Class<E> getRequiredRootEntity(MethodInvocationContext context) {
        Class aClass = context.classValue(DATA_METHOD_ANN_NAME, "rootEntity").orElse(null);
        if (aClass != null) {
            return aClass;
        }
        AnnotationValue ann = context.getDeclaredAnnotation(DATA_METHOD_ANN_NAME);
        if (ann != null && (aClass = (Class)ann.classValue("rootEntity").orElse(null)) != null) {
            return aClass;
        }
        throw new IllegalStateException("No root entity present in method");
    }

    protected <RT> RT getEntityParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        return this.getRequiredParameterInRole(context, "entity", type);
    }

    protected <RT> Iterable<RT> getEntitiesParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        return this.getRequiredParameterInRole(context, "entities", Iterable.class);
    }

    protected <RT> Optional<RT> findEntityParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        return this.getParameterInRole(context, "entity", type);
    }

    protected <RT> Optional<Iterable<RT>> findEntitiesParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        Optional<Iterable<RT>> parameterInRole = this.getParameterInRole(context, "entities", Iterable.class);
        return parameterInRole;
    }

    private <RT> RT getRequiredParameterInRole(MethodInvocationContext<?, ?> context, @NonNull String role, @NonNull Class<RT> type) {
        return this.getParameterInRole(context, role, type).orElseThrow(() -> new IllegalStateException("Cannot find parameter with role: " + role));
    }

    private <RT> Optional<RT> getParameterInRole(MethodInvocationContext<?, ?> context, @NonNull String role, @NonNull Class<RT> type) {
        return context.stringValue(DATA_METHOD_ANN_NAME, role).flatMap(name -> {
            Object o;
            Object parameterValue = null;
            Map params = context.getParameters();
            MutableArgumentValue arg = (MutableArgumentValue)params.get(name);
            if (arg != null && (o = arg.getValue()) != null) {
                parameterValue = type.isInstance(o) ? o : this.operations.getConversionService().convert(o, type).orElse(null);
            }
            return Optional.ofNullable(parameterValue);
        });
    }

    @NonNull
    protected Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Pageable pageable = this.getParameterInRole(context, "pageable", Pageable.class).orElse(null);
        if (pageable == null) {
            Sort sort = this.getParameterInRole(context, "sort", Sort.class).orElse(null);
            if (sort != null) {
                int max = context.intValue(DATA_METHOD_ANN_NAME, "pageSize").orElse(-1);
                int pageIndex = context.intValue(DATA_METHOD_ANN_NAME, "pageIndex").orElse(0);
                pageable = max > 0 ? Pageable.from((int)pageIndex, (int)max, (Sort)sort) : Pageable.from((Sort)sort);
            } else {
                int max = context.intValue(DATA_METHOD_ANN_NAME, "pageSize").orElse(-1);
                if (max > -1) {
                    return Pageable.from((int)0, (int)max);
                }
            }
        }
        return pageable != null ? pageable : Pageable.UNPAGED;
    }

    protected boolean isNullable(@NonNull AnnotationMetadata metadata) {
        return metadata.getDeclaredAnnotationNames().stream().anyMatch(n -> NameUtils.getSimpleName((String)n).equalsIgnoreCase("nullable"));
    }

    @NonNull
    protected Object getRequiredEntity(MethodInvocationContext<T, ?> context) {
        String entityParam = (String)context.stringValue(DATA_METHOD_ANN_NAME, "entity").orElseThrow(() -> new IllegalStateException("No entity parameter specified"));
        Object o = context.getParameterValueMap().get(entityParam);
        if (o == null) {
            throw new IllegalArgumentException("Entity argument cannot be null");
        }
        return o;
    }

    private <RT> Map buildParameterValues(MethodInvocationContext<T, R> context, StoredQuery<?, RT> storedQuery) {
        Map parameterValueMap = context.getParameterValueMap();
        Map parameterBinding = storedQuery.getParameterBinding();
        HashMap parameterValues = new HashMap(parameterBinding.size());
        for (Map.Entry entry : parameterBinding.entrySet()) {
            Object name = entry.getKey();
            String argument = (String)entry.getValue();
            this.storeInParameterValues(context, storedQuery, parameterValueMap, name, argument, parameterValues);
        }
        return parameterValues;
    }

    private <RT> void storeInParameterValues(MethodInvocationContext<T, R> context, StoredQuery<?, RT> storedQuery, Map<String, Object> namedValues, Object index, String argument, Map parameterValues) {
        if (namedValues.containsKey(argument)) {
            parameterValues.put(index, namedValues.get(argument));
        } else {
            int i = argument.indexOf(46);
            if (i > -1) {
                String argumentName = argument.substring(0, i);
                Object o = namedValues.get(argumentName);
                if (o != null) {
                    try {
                        BeanWrapper wrapper = BeanWrapper.getWrapper((Object)o);
                        String prop = argument.substring(i + 1);
                        Object val = wrapper.getRequiredProperty(prop, Object.class);
                        parameterValues.put(index, val);
                    }
                    catch (IntrospectionException e) {
                        throw new DataAccessException("Embedded value [" + o + "] should be annotated with introspected");
                    }
                }
            } else {
                for (Argument a : context.getArguments()) {
                    String n = a.getAnnotationMetadata().stringValue(Parameter.class).orElse(a.getName());
                    if (!n.equals(argument)) continue;
                    parameterValues.put(index, namedValues.get(a.getName()));
                    return;
                }
                throw new IllegalArgumentException("Missing query arguments: " + argument);
            }
        }
    }

    @NonNull
    protected Object instantiateEntity(@NonNull Class<?> rootEntity, @NonNull Map<String, Object> parameterValues) {
        Object instance;
        RuntimePersistentEntity entity = this.operations.getEntity(rootEntity);
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(rootEntity);
        Object[] constructorArguments = introspection.getConstructorArguments();
        if (ArrayUtils.isNotEmpty((Object[])constructorArguments)) {
            Object[] arguments = new Object[constructorArguments.length];
            for (int i = 0; i < constructorArguments.length; ++i) {
                PersistentProperty prop;
                Object argument = constructorArguments[i];
                String argumentName = argument.getName();
                Object v = parameterValues.get(argumentName);
                AnnotationMetadata argMetadata = argument.getAnnotationMetadata();
                if (v == null && !PersistentProperty.isNullableMetadata((AnnotationMetadata)argMetadata) && ((prop = entity.getPropertyByName(argumentName)) == null || prop.isRequired())) {
                    throw new IllegalArgumentException("Argument [" + argumentName + "] cannot be null");
                }
                arguments[i] = v;
            }
            instance = introspection.instantiate(arguments);
        } else {
            instance = introspection.instantiate();
        }
        BeanWrapper wrapper = BeanWrapper.getWrapper((Object)instance);
        Collection persistentProperties = entity.getPersistentProperties();
        for (PersistentProperty prop : persistentProperties) {
            Optional p;
            if (prop.isReadOnly() || prop.isGenerated()) continue;
            String propName = prop.getName();
            if (parameterValues.containsKey(propName)) {
                Object v = parameterValues.get(propName);
                if (v == null && !prop.isOptional()) {
                    throw new IllegalArgumentException("Argument [" + propName + "] cannot be null");
                }
                wrapper.setProperty(propName, v);
                continue;
            }
            if (!prop.isRequired() || (p = wrapper.getProperty(propName, Object.class)).isPresent()) continue;
            throw new IllegalArgumentException("Argument [" + propName + "] cannot be null");
        }
        return instance;
    }

    @Deprecated
    @Nullable
    protected Number convertNumberArgumentIfNecessary(Number number, Argument<?> argument) {
        Argument firstTypeVar = argument.getFirstTypeVariable().orElse(Argument.of(Long.class));
        Class type = firstTypeVar.getType();
        if (type == Object.class || type == Void.class) {
            return null;
        }
        if (number == null) {
            number = 0;
        }
        if (!type.isInstance(number)) {
            return (Number)this.operations.getConversionService().convert((Object)number, firstTypeVar).orElseThrow(() -> new IllegalStateException("Unsupported number type for return type: " + firstTypeVar));
        }
        return number;
    }

    @NonNull
    protected <E> PagedQuery<E> getPagedQuery(@NonNull MethodInvocationContext context) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        Pageable pageable = this.getPageable(context);
        return new DefaultPagedQuery<E>(context.getExecutableMethod(), rootEntity, pageable);
    }

    @NonNull
    protected <E> InsertBatchOperation<E> getInsertBatchOperation(@NonNull MethodInvocationContext context, @NonNull Iterable<E> iterable) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        return this.getInsertBatchOperation(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> InsertBatchOperation<E> getInsertBatchOperation(@NonNull MethodInvocationContext context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultInsertBatchOperation<E>(context, rootEntity, iterable);
    }

    protected <E> InsertOperation<E> getInsertOperation(@NonNull MethodInvocationContext context) {
        Object o = this.getRequiredEntity(context);
        return new DefaultInsertOperation<Object>(context, o);
    }

    protected <E> UpdateOperation<E> getUpdateOperation(@NonNull MethodInvocationContext<T, ?> context) {
        return this.getUpdateOperation(context, this.getRequiredEntity(context));
    }

    protected <E> UpdateOperation<E> getUpdateOperation(@NonNull MethodInvocationContext<T, ?> context, E entity) {
        return new DefaultUpdateOperation<E>(context, entity);
    }

    @NonNull
    protected <E> UpdateBatchOperation<E> getUpdateAllBatchOperation(@NonNull MethodInvocationContext<T, ?> context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultUpdateBatchOperation<E>(context, rootEntity, iterable);
    }

    protected <E> DeleteOperation<E> getDeleteOperation(@NonNull MethodInvocationContext<T, ?> context, @NonNull E entity) {
        return new DefaultDeleteOperation<E>(context, entity);
    }

    @NonNull
    protected <E> DeleteBatchOperation<E> getDeleteBatchOperation(@NonNull MethodInvocationContext<T, ?> context, @NonNull Iterable<E> iterable) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        return this.getDeleteBatchOperation(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> DeleteBatchOperation<E> getDeleteBatchOperation(@NonNull MethodInvocationContext<T, ?> context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultDeleteBatchOperation<E>(context, rootEntity, iterable);
    }

    protected <E> InsertOperation<E> getInsertOperation(@NonNull MethodInvocationContext<T, ?> context, E entity) {
        return new DefaultInsertOperation<E>(context, entity);
    }

    protected final void validateNullArguments(MethodInvocationContext<T, R> context) {
        Object[] parameterValues = context.getParameterValues();
        for (int i = 0; i < parameterValues.length; ++i) {
            Object o = parameterValues[i];
            if (o != null || context.getArguments()[i].isNullable()) continue;
            throw new IllegalArgumentException("Argument [" + context.getArguments()[i].getName() + "] value is null and the method parameter is not declared as nullable");
        }
    }

    protected int count(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> iterator = iterable.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        return i;
    }

    protected boolean isNumber(@Nullable Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return ClassUtils.getPrimitiveType((String)type.getName()).map(aClass -> Number.class.isAssignableFrom(ReflectionUtils.getWrapperType((Class)aClass))).orElse(false);
        }
        return Number.class.isAssignableFrom(type);
    }

    private static final class StoredQueryParameter
    implements QueryParameterBinding {
        private final String name;
        private final DataType dataType;
        private final int parameterIndex;
        private final String[] parameterBindingPath;
        private final String[] propertyPath;
        private final boolean autoPopulated;
        private final boolean requiresPreviousPopulatedValue;
        private final Class<?> parameterConverterClass;
        private final boolean expandable;
        private final List<? extends QueryParameterBinding> all;
        private boolean previousInitialized;
        private QueryParameterBinding previousPopulatedValueParameter;

        private StoredQueryParameter(String name, DataType dataType, int parameterIndex, String[] parameterBindingPath, String[] propertyPath, boolean autoPopulated, boolean requiresPreviousPopulatedValue, Class<?> parameterConverterClass, boolean expandable, List<? extends QueryParameterBinding> all) {
            this.name = name;
            this.dataType = dataType;
            this.parameterIndex = parameterIndex;
            this.parameterBindingPath = parameterBindingPath;
            this.propertyPath = propertyPath;
            this.autoPopulated = autoPopulated;
            this.requiresPreviousPopulatedValue = requiresPreviousPopulatedValue;
            this.parameterConverterClass = parameterConverterClass;
            this.expandable = expandable;
            this.all = all;
        }

        public String getName() {
            return this.name;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public Class<?> getParameterConverterClass() {
            return this.parameterConverterClass;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String[] getParameterBindingPath() {
            return this.parameterBindingPath;
        }

        public String[] getPropertyPath() {
            return this.propertyPath;
        }

        public boolean isAutoPopulated() {
            return this.autoPopulated;
        }

        public boolean isRequiresPreviousPopulatedValue() {
            return this.requiresPreviousPopulatedValue;
        }

        public QueryParameterBinding getPreviousPopulatedValueParameter() {
            if (!this.previousInitialized) {
                for (QueryParameterBinding queryParameterBinding : this.all) {
                    if (queryParameterBinding == this || queryParameterBinding.getParameterIndex() == -1 || !Arrays.equals(this.propertyPath, queryParameterBinding.getPropertyPath())) continue;
                    this.previousPopulatedValueParameter = queryParameterBinding;
                    break;
                }
                this.previousInitialized = true;
            }
            return this.previousPopulatedValueParameter;
        }

        public boolean isExpandable() {
            return this.expandable;
        }

        public String toString() {
            return "StoredQueryParameter{name='" + this.name + '\'' + ", dataType=" + this.dataType + ", parameterIndex=" + this.parameterIndex + ", parameterBindingPath=" + Arrays.toString(this.parameterBindingPath) + ", propertyPath=" + Arrays.toString(this.propertyPath) + ", autoPopulated=" + this.autoPopulated + ", requiresPreviousPopulatedValue=" + this.requiresPreviousPopulatedValue + ", previousPopulatedValueParameter=" + this.previousPopulatedValueParameter + ", expandable=" + this.expandable + '}';
        }
    }

    protected final class DefaultPreparedQuery<E, RT>
    extends DefaultStoredDataOperation<RT>
    implements PreparedQuery<E, RT> {
        private final Pageable pageable;
        private final StoredQuery<E, RT> storedQuery;
        private final String query;
        private final boolean dto;
        private final MethodInvocationContext<T, R> context;

        public DefaultPreparedQuery(MethodInvocationContext<T, R> context, StoredQuery<E, RT> storedQuery, @NonNull String finalQuery, Pageable pageable, boolean dtoProjection) {
            super(context);
            this.context = context;
            this.query = finalQuery;
            this.storedQuery = storedQuery;
            this.pageable = pageable;
            this.dto = dtoProjection;
        }

        public String[] getExpandableQueryParts() {
            return this.storedQuery.getExpandableQueryParts();
        }

        public List<QueryParameterBinding> getQueryBindings() {
            return this.storedQuery.getQueryBindings();
        }

        public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
            return AbstractQueryInterceptor.this.getParameterInRole(this.context, role, type);
        }

        public boolean hasResultConsumer() {
            return this.storedQuery.hasResultConsumer();
        }

        @NonNull
        public Set<JoinPath> getJoinFetchPaths() {
            return this.storedQuery.getJoinFetchPaths();
        }

        public boolean isSingleResult() {
            return this.storedQuery.isSingleResult();
        }

        @NonNull
        public Map<String, Object> getQueryHints() {
            return this.storedQuery.getQueryHints();
        }

        public Class<?> getRepositoryType() {
            return this.context.getTarget().getClass();
        }

        @NonNull
        public Map<String, Object> getParameterValues() {
            return Collections.emptyMap();
        }

        public Object[] getParameterArray() {
            return this.context.getParameterValues();
        }

        public Argument[] getArguments() {
            return this.context.getArguments();
        }

        @NonNull
        public Pageable getPageable() {
            if (this.storedQuery.isCount()) {
                return Pageable.UNPAGED;
            }
            return this.pageable;
        }

        public boolean isNative() {
            return this.storedQuery.isNative();
        }

        public boolean useNumericPlaceholders() {
            return this.storedQuery.useNumericPlaceholders();
        }

        public boolean isDtoProjection() {
            return this.dto;
        }

        @NonNull
        public Class<RT> getResultType() {
            return this.storedQuery.getResultType();
        }

        @NonNull
        public DataType getResultDataType() {
            return this.storedQuery.getResultDataType();
        }

        @Nullable
        public Optional<Class<?>> getEntityIdentifierType() {
            return this.storedQuery.getEntityIdentifierType();
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.storedQuery.getRootEntity();
        }

        @Deprecated
        public boolean hasInExpression() {
            return this.storedQuery.hasInExpression();
        }

        public boolean hasPageable() {
            return this.storedQuery.hasPageable();
        }

        @NonNull
        public String getQuery() {
            return this.query;
        }

        @NonNull
        public Class<?>[] getArgumentTypes() {
            return this.storedQuery.getArgumentTypes();
        }

        @NonNull
        public Map<String, String> getParameterBinding() {
            return this.storedQuery.getParameterBinding();
        }

        public boolean isCount() {
            return this.storedQuery.isCount();
        }

        @NonNull
        public String getName() {
            return this.storedQuery.getName();
        }

        @NonNull
        public ConvertibleValues<Object> getAttributes() {
            return this.context.getAttributes();
        }

        @NonNull
        public Optional<Object> getAttribute(CharSequence name) {
            return this.context.getAttribute(name);
        }

        @NonNull
        public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
            return this.context.getAttribute(name, type);
        }

        @Nullable
        public String[] getIndexedParameterAutoPopulatedPropertyPaths() {
            return this.storedQuery.getIndexedParameterAutoPopulatedPropertyPaths();
        }

        public String[] getIndexedParameterAutoPopulatedPreviousPropertyPaths() {
            return this.storedQuery.getIndexedParameterAutoPopulatedPreviousPropertyPaths();
        }

        public int[] getIndexedParameterAutoPopulatedPreviousPropertyIndexes() {
            return this.storedQuery.getIndexedParameterAutoPopulatedPreviousPropertyIndexes();
        }

        public boolean isOptimisticLock() {
            return this.storedQuery.isOptimisticLock();
        }
    }

    private final class DefaultStoredQuery<E, RT>
    extends DefaultStoredDataOperation<RT>
    implements StoredQuery<E, RT> {
        @NonNull
        private final Class<RT> resultType;
        @NonNull
        private final Class<E> rootEntity;
        @NonNull
        private final String query;
        private final String[] queryParts;
        private final ExecutableMethod<?, ?> method;
        private final boolean isDto;
        private final boolean isOptimisticLock;
        private final boolean isNative;
        private final boolean isNumericPlaceHolder;
        private final boolean hasPageable;
        private final AnnotationMetadata annotationMetadata;
        private final boolean isCount;
        private final DataType[] indexedDataTypes;
        private final boolean hasResultConsumer;
        private Map<String, Object> queryHints;
        private Set<JoinPath> joinFetchPaths;
        private final List<StoredQueryParameter> queryParameters;
        final /* synthetic */ AbstractQueryInterceptor this$0;

        /*
         * Exception decompiling
         */
        DefaultStoredQuery(@NonNull AbstractQueryInterceptor var1_1, @NonNull ExecutableMethod<?, ?> method, @NonNull Class<RT> resultType, @NonNull Class<E> rootEntity, String query, boolean isCount) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public List<QueryParameterBinding> getQueryBindings() {
            return this.queryParameters;
        }

        public String[] getParameterNames() {
            return StringUtils.EMPTY_STRING_ARRAY;
        }

        public String[] getIndexedParameterPaths() {
            return StringUtils.EMPTY_STRING_ARRAY;
        }

        @NonNull
        public Set<JoinPath> getJoinFetchPaths() {
            if (this.joinFetchPaths == null) {
                Set set = this.method.getAnnotationValuesByType(Join.class).stream().filter(this::isJoinFetch).map(av -> {
                    String path = (String)av.stringValue().orElseThrow(() -> new IllegalStateException("Should not include annotations without a value definition"));
                    String alias = av.stringValue("alias").orElse(null);
                    return new JoinPath(path, new Association[0], Join.Type.DEFAULT, alias);
                }).collect(Collectors.toSet());
                this.joinFetchPaths = set.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(set);
            }
            return this.joinFetchPaths;
        }

        public boolean isSingleResult() {
            return !this.isCount() && this.getJoinFetchPaths().isEmpty();
        }

        public boolean hasResultConsumer() {
            return this.hasResultConsumer;
        }

        private boolean isJoinFetch(AnnotationValue<Join> av) {
            if (!av.stringValue().isPresent()) {
                return false;
            }
            Optional type = av.stringValue("type");
            return !type.isPresent() || ((String)type.get()).contains("FETCH");
        }

        public boolean isCount() {
            return this.isCount;
        }

        @NonNull
        public DataType[] getIndexedParameterTypes() {
            if (this.indexedDataTypes == null) {
                return DataType.EMPTY_DATA_TYPE_ARRAY;
            }
            return this.indexedDataTypes;
        }

        @NonNull
        public int[] getIndexedParameterBinding() {
            return EMPTY_INT_ARRAY;
        }

        @NonNull
        public Map<String, Object> getQueryHints() {
            if (this.queryHints != null) {
                return this.queryHints;
            }
            return Collections.emptyMap();
        }

        public boolean isNative() {
            return this.isNative;
        }

        public boolean useNumericPlaceholders() {
            return this.isNumericPlaceHolder;
        }

        public boolean isDtoProjection() {
            return this.isDto;
        }

        @NonNull
        public Class<RT> getResultType() {
            return this.resultType;
        }

        @NonNull
        public DataType getResultDataType() {
            if (this.isCount) {
                return DataType.LONG;
            }
            return this.annotationMetadata.enumValue(DATA_METHOD_ANN_NAME, "resultDataType", DataType.class).orElse(DataType.OBJECT);
        }

        public Optional<Class<?>> getEntityIdentifierType() {
            Optional o = this.annotationMetadata.classValue(DATA_METHOD_ANN_NAME, "idType");
            return o;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @Deprecated
        public boolean hasInExpression() {
            return false;
        }

        public boolean hasPageable() {
            return this.hasPageable;
        }

        @NonNull
        public String getQuery() {
            return this.query;
        }

        public String[] getExpandableQueryParts() {
            return this.queryParts;
        }

        @NonNull
        public String getName() {
            return this.method.getMethodName();
        }

        @NonNull
        public Class<?>[] getArgumentTypes() {
            return this.method.getArgumentTypes();
        }

        @NonNull
        public Map<String, String> getParameterBinding() {
            return Collections.emptyMap();
        }

        public String[] getIndexedParameterAutoPopulatedPropertyPaths() {
            return StringUtils.EMPTY_STRING_ARRAY;
        }

        public int[] getIndexedParameterAutoPopulatedPreviousPropertyIndexes() {
            return new int[0];
        }

        public String[] getIndexedParameterAutoPopulatedPreviousPropertyPaths() {
            return StringUtils.EMPTY_STRING_ARRAY;
        }

        public boolean isOptimisticLock() {
            return this.isOptimisticLock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DefaultStoredQuery that = (DefaultStoredQuery)((Object)o);
            return this.resultType.equals(that.resultType) && this.method.equals(that.method);
        }

        public int hashCode() {
            return Objects.hash(this.resultType, this.method);
        }
    }

    private static final class DefaultPagedQuery<E>
    implements PagedQuery<E> {
        private final ExecutableMethod<?, ?> method;
        @NonNull
        private final Class<E> rootEntity;
        private final Pageable pageable;

        DefaultPagedQuery(ExecutableMethod<?, ?> method, @NonNull Class<E> rootEntity, Pageable pageable) {
            this.method = method;
            this.rootEntity = rootEntity;
            this.pageable = pageable;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @NonNull
        public Pageable getPageable() {
            return this.pageable;
        }

        @NonNull
        public String getName() {
            return this.method.getMethodName();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }

    private class DefaultBatchOperation<E>
    extends AbstractEntityOperation<E>
    implements BatchOperation<E> {
        protected final Iterable<E> iterable;

        public DefaultBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity);
            this.iterable = iterable;
        }

        public Iterator<E> iterator() {
            return this.iterable.iterator();
        }
    }

    private class DefaultUpdateBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements UpdateBatchOperation<E> {
        DefaultUpdateBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        public List<UpdateOperation<E>> split() {
            ArrayList updates = new ArrayList(10);
            for (Object e : this.iterable) {
                updates.add(new DefaultUpdateOperation(this.method, e));
            }
            return updates;
        }
    }

    private class DefaultDeleteBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements DeleteBatchOperation<E> {
        DefaultDeleteBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity) {
            this(method, rootEntity, Collections.emptyList());
        }

        DefaultDeleteBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        public List<DeleteOperation<E>> split() {
            ArrayList deletes = new ArrayList(10);
            for (Object e : this.iterable) {
                deletes.add(new DefaultDeleteOperation(this.method, e));
            }
            return deletes;
        }
    }

    private class DefaultInsertBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements InsertBatchOperation<E> {
        DefaultInsertBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        public List<InsertOperation<E>> split() {
            ArrayList inserts = new ArrayList(10);
            for (Object e : this.iterable) {
                inserts.add(new DefaultInsertOperation(this.method, e));
            }
            return inserts;
        }
    }

    private abstract class AbstractEntityOperation<E>
    extends AbstractPreparedDataOperation<E>
    implements EntityOperation<E> {
        protected final MethodInvocationContext<?, ?> method;
        protected final Class<E> rootEntity;
        protected StoredQuery<E, ?> storedQuery;

        AbstractEntityOperation(MethodInvocationContext<?, ?> method, Class<E> rootEntity) {
            super(method, (StoredDataOperation)new DefaultStoredDataOperation(method.getExecutableMethod()));
            this.method = method;
            this.rootEntity = rootEntity;
        }

        public StoredQuery<E, ?> getStoredQuery() {
            if (this.storedQuery == null) {
                String queryString = this.method.stringValue(Query.class).orElse(null);
                if (queryString == null) {
                    return null;
                }
                this.storedQuery = AbstractQueryInterceptor.this.findStoreQuery(this.method);
            }
            return this.storedQuery;
        }

        public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
            return AbstractQueryInterceptor.this.getParameterInRole(this.method, role, type);
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @NonNull
        public Class<?> getRepositoryType() {
            return this.method.getTarget().getClass();
        }

        @NonNull
        public String getName() {
            return this.method.getMethodName();
        }
    }

    private abstract class AbstractEntityInstanceOperation<E>
    extends AbstractEntityOperation<E>
    implements EntityInstanceOperation<E> {
        private final E entity;

        AbstractEntityInstanceOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity.getClass());
            this.entity = entity;
        }

        @NonNull
        public E getEntity() {
            return this.entity;
        }
    }

    private final class DefaultUpdateOperation<E>
    extends AbstractEntityOperation<E>
    implements UpdateOperation<E> {
        private final E entity;

        DefaultUpdateOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity.getClass());
            this.entity = entity;
        }

        public E getEntity() {
            return this.entity;
        }
    }

    private class DefaultDeleteOperation<E>
    extends AbstractEntityInstanceOperation<E>
    implements DeleteOperation<E> {
        DefaultDeleteOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity);
        }
    }

    private final class DefaultInsertOperation<E>
    extends AbstractEntityOperation<E>
    implements InsertOperation<E> {
        private final E entity;

        DefaultInsertOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity.getClass());
            this.entity = entity;
        }

        public E getEntity() {
            return this.entity;
        }
    }
}

