/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreRemove;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.runtime.PropertyAutoPopulator;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;

@Singleton
public class VersionGeneratingEntityEventListener
implements EntityEventListener<Object>,
PropertyAutoPopulator<Version> {
    private static final List<Class<? extends Annotation>> SUPPORTED_EVENTS = Arrays.asList(PrePersist.class, PreUpdate.class, PreRemove.class);
    private final DateTimeProvider dateTimeProvider;
    private final DataConversionService<?> conversionService;

    public VersionGeneratingEntityEventListener(DateTimeProvider dateTimeProvider, DataConversionService<?> conversionService) {
        this.dateTimeProvider = dateTimeProvider;
        this.conversionService = conversionService;
    }

    public boolean supports(RuntimePersistentEntity<Object> entity, Class<? extends Annotation> eventType) {
        return entity.getVersion() != null && SUPPORTED_EVENTS.contains(eventType);
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        Object entity = context.getEntity();
        BeanProperty property = context.getPersistentEntity().getVersion().getProperty();
        Object newVersion = this.init(property.getType());
        property.set(entity, newVersion);
        return true;
    }

    public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
        Object entity = context.getEntity();
        BeanProperty property = context.getPersistentEntity().getVersion().getProperty();
        Object newVersion = this.increment(property.get(entity), property.getType());
        property.set(entity, newVersion);
        return true;
    }

    public boolean preRemove(@NonNull EntityEventContext<Object> context) {
        return this.preUpdate(context);
    }

    @NonNull
    public Object populate(RuntimePersistentProperty<?> property, @Nullable Object previousValue) {
        Class type = property.getType();
        return this.increment(previousValue, type);
    }

    private Object increment(Object previousValue, Class<?> type) {
        if (previousValue == null) {
            throw new IllegalStateException("@Version value cannot be null");
        }
        if (Temporal.class.isAssignableFrom(type)) {
            return this.newTemporal(type);
        }
        if (type == Integer.class) {
            return (Integer)previousValue + 1;
        }
        if (type == Long.class) {
            return (Long)previousValue + 1L;
        }
        if (type == Short.class) {
            return (Short)previousValue + 1;
        }
        throw new DataAccessException("Unsupported @Version type: " + type);
    }

    private Object init(Class<?> valueType) {
        if (Temporal.class.isAssignableFrom(valueType)) {
            return this.newTemporal(valueType);
        }
        if (valueType == Integer.class) {
            return 0;
        }
        if (valueType == Long.class) {
            return 0L;
        }
        if (valueType == Short.class) {
            return (short)0;
        }
        throw new DataAccessException("Unsupported @Version type: " + valueType);
    }

    private Object newTemporal(Class<?> type) {
        Object now = this.dateTimeProvider.getNow();
        return this.conversionService.convertRequired(now, type);
    }
}

