/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.runtime.mapper.TypeMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

@FunctionalInterface
public interface BeanIntrospectionMapper<D, R>
extends TypeMapper<D, R> {
    @Override
    @NonNull
    default public R map(@NonNull D object, @NonNull Class<R> type) throws InstantiationException {
        ArgumentUtils.requireNonNull((String)"resultSet", object);
        ArgumentUtils.requireNonNull((String)"type", type);
        try {
            Object instance;
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
            ConversionService<?> conversionService = this.getConversionService();
            Object[] arguments = introspection.getConstructorArguments();
            if (ArrayUtils.isEmpty((Object[])arguments)) {
                instance = introspection.instantiate();
            } else {
                Object[] args = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    Object argument = arguments[i];
                    Set<Object> o = this.read(object, (Argument<?>)argument);
                    if (o == null) {
                        args[i] = o;
                        continue;
                    }
                    if (argument.getType().isInstance(o)) {
                        args[i] = o;
                        continue;
                    }
                    Set<Object> convertFrom = Collection.class.isAssignableFrom(argument.getType()) && !(o instanceof Collection) ? Collections.singleton(o) : o;
                    ArgumentConversionContext acc = ConversionContext.of((Argument)argument);
                    args[i] = conversionService.convert(convertFrom, acc).orElseThrow(() -> BeanIntrospectionMapper.lambda$map$2(acc, (Argument)argument, o));
                }
                instance = introspection.instantiate(args);
            }
            Collection properties = introspection.getBeanProperties();
            for (BeanProperty property : properties) {
                Object v;
                if (property.isReadOnly() || (v = this.read(object, property.getName())) == null) continue;
                if (property.getType().isInstance(v)) {
                    property.set(instance, v);
                    continue;
                }
                if (Iterable.class.isAssignableFrom(property.getType())) {
                    Object value = property.get(instance);
                    if (value instanceof Collection) {
                        ((Collection)value).add(v);
                        continue;
                    }
                    if (value instanceof Iterable) {
                        ArrayList<Object> list = new ArrayList<Object>(CollectionUtils.iterableToList((Iterable)((Iterable)value)));
                        list.add(v);
                        property.convertAndSet(instance, list);
                        continue;
                    }
                    property.convertAndSet(instance, Collections.singleton(v));
                    continue;
                }
                property.convertAndSet(instance, v);
            }
            return (R)instance;
        }
        catch (IntrospectionException | InstantiationException e) {
            throw new DataAccessException("Error instantiating type [" + type.getName() + "] from introspection: " + e.getMessage(), e);
        }
    }

    private static /* synthetic */ RuntimeException lambda$map$2(ArgumentConversionContext acc, Argument argument, Object o) {
        Optional lastError = acc.getLastError();
        return lastError.map(conversionError -> new ConversionErrorException(argument, conversionError)).orElseGet(() -> new IllegalArgumentException("Cannot convert object type " + o.getClass() + " to required type: " + argument.getType()));
    }
}

