/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;

public class DefaultFindOneInterceptor<T>
extends AbstractQueryInterceptor<T, Object>
implements FindOneInterceptor<T> {
    protected DefaultFindOneInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Object> context) {
        PreparedQuery preparedQuery = this.prepareQuery(methodKey, context, null);
        Object result = this.operations.findOne(preparedQuery);
        if (result != null) {
            ReturnType returnType = context.getReturnType();
            if (!returnType.getType().isInstance(result)) {
                return ConversionService.SHARED.convert(result, returnType.asArgument()).orElseThrow(() -> new IllegalStateException("Unexpected return type: " + result));
            }
            return result;
        }
        if (!this.isNullable(context.getAnnotationMetadata())) {
            throw new EmptyResultException();
        }
        return result;
    }
}

