/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.data.annotation.event.PostLoad;
import io.micronaut.data.annotation.event.PostPersist;
import io.micronaut.data.annotation.event.PostRemove;
import io.micronaut.data.annotation.event.PostUpdate;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreRemove;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.event.PersistenceEventException;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.inject.Singleton;

@Singleton
public class AnnotatedMethodInvokingEntityEventListener
implements EntityEventListener<Object> {
    public boolean supports(RuntimePersistentEntity<Object> entity, Class<? extends Annotation> eventType) {
        BeanIntrospection introspection = entity.getIntrospection();
        Collection beanMethods = introspection.getBeanMethods();
        return beanMethods.stream().anyMatch(beanMethod -> beanMethod.isAnnotationPresent(eventType));
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PrePersist.class.getName());
        return true;
    }

    public void postPersist(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PostPersist.class.getName());
    }

    public void postLoad(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PostLoad.class.getName());
    }

    public boolean preRemove(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PreRemove.class.getName());
        return true;
    }

    public void postRemove(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PostRemove.class.getName());
    }

    public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PreUpdate.class.getName());
        return true;
    }

    public void postUpdate(@NonNull EntityEventContext<Object> context) {
        this.triggerEvent(context, PostUpdate.class.getName());
    }

    private void triggerEvent(@NonNull EntityEventContext<Object> context, String annotationName) {
        if (context.supportsEventSystem()) {
            RuntimePersistentEntity persistentEntity = context.getPersistentEntity();
            persistentEntity.getIntrospection().getBeanMethods().forEach(beanMethod -> {
                if (beanMethod.getAnnotationMetadata().hasAnnotation(annotationName)) {
                    try {
                        beanMethod.invoke(context.getEntity(), new Object[0]);
                    }
                    catch (Exception e) {
                        throw new PersistenceEventException("Error invoking persistence event method [" + beanMethod.getName() + "] on entity [" + persistentEntity.getName() + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }
}

