/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;

public class DefaultDeleteOneInterceptor<T>
extends AbstractQueryInterceptor<T, Object>
implements DeleteOneInterceptor<T> {
    protected DefaultDeleteOneInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Object> context) {
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 1) {
            Number deleted;
            Object o = parameterValues[0];
            Class returnType = context.getReturnType().getType();
            if (o instanceof Iterable) {
                DeleteBatchOperation batchOperation = this.getDeleteBatchOperation(context, (Iterable)o);
                deleted = this.operations.deleteAll(batchOperation).orElse(null);
            } else {
                if (o == null) {
                    throw new IllegalArgumentException("Entity to delete cannot be null");
                }
                Class<?> rootEntity = this.getRequiredRootEntity(context);
                if (!rootEntity.isInstance(o)) {
                    throw new IllegalArgumentException("Entity argument must be an instance of " + rootEntity.getName());
                }
                deleted = this.operations.delete(this.getDeleteOperation(context, o));
                if (returnType.equals(rootEntity)) {
                    if (deleted.intValue() > 0) {
                        return o;
                    }
                    return null;
                }
            }
            if (Number.class.isAssignableFrom(returnType)) {
                return ConversionService.SHARED.convertRequired((Object)deleted, returnType);
            }
            return null;
        }
        throw new IllegalStateException("Expected exactly one argument");
    }
}

