/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.SaveAllAsyncInterceptor;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractAsyncInterceptor;
import java.util.concurrent.CompletionStage;

public class DefaultSaveAllAsyncInterceptor<T>
extends AbstractAsyncInterceptor<T, Iterable<Object>>
implements SaveAllAsyncInterceptor<T> {
    protected DefaultSaveAllAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public CompletionStage<Iterable<Object>> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, CompletionStage<Iterable<Object>>> context) {
        Object[] parameterValues = context.getParameterValues();
        if (ArrayUtils.isNotEmpty((Object[])parameterValues) && parameterValues[0] instanceof Iterable) {
            BatchOperation batchOperation = this.getBatchOperation(context, (Iterable)parameterValues[0]);
            return this.asyncDatastoreOperations.persistAll(batchOperation);
        }
        throw new IllegalArgumentException("First argument should be an iterable");
    }
}

