/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.FindPageAsyncInterceptor;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractAsyncInterceptor;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class DefaultFindPageAsyncInterceptor<T>
extends AbstractAsyncInterceptor<T, Page<Object>>
implements FindPageAsyncInterceptor<T> {
    protected DefaultFindPageAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public CompletionStage<Page<Object>> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, CompletionStage<Page<Object>>> context) {
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
            return this.asyncDatastoreOperations.findOne(countQuery).thenCompose(total -> this.asyncDatastoreOperations.findAll(preparedQuery).thenApply(objects -> {
                List resultList = CollectionUtils.iterableToList((Iterable)objects);
                return Page.of((List)resultList, (Pageable)this.getPageable(context), (long)total.longValue());
            }));
        }
        return this.asyncDatastoreOperations.findPage(this.getPagedQuery(context));
    }
}

