/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Collections;

public class DefaultDeleteOneInterceptor<T>
extends AbstractQueryInterceptor<T, Object>
implements DeleteOneInterceptor<T> {
    protected DefaultDeleteOneInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Object> context) {
        BatchOperation<Object> batchOperation;
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 1) {
            Object o = parameterValues[0];
            if (context.hasAnnotation(Query.class)) {
                PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
                Class rootEntity = preparedQuery.getRootEntity();
                if (rootEntity.isInstance(o)) {
                    RuntimePersistentEntity entity = this.operations.getEntity(rootEntity);
                    RuntimePersistentProperty identity = entity.getIdentity();
                    if (identity != null) {
                        if (identity instanceof Embedded) {
                            BeanProperty idProp = identity.getProperty();
                            Object idValue = idProp.get(o);
                            if (idValue == null) {
                                throw new IllegalStateException("Cannot delete an entity with null ID: " + o);
                            }
                            preparedQuery.getParameterArray()[0] = idValue;
                        }
                        Number result = this.operations.executeDelete(preparedQuery).orElse(0);
                        Class returnType = context.getReturnType().getType();
                        if (returnType.equals(rootEntity)) {
                            if (result.longValue() > 0L) {
                                return o;
                            }
                            return null;
                        }
                        if (Number.class.isAssignableFrom(returnType)) {
                            return ConversionService.SHARED.convertRequired((Object)result, returnType);
                        }
                        return result;
                    }
                    throw new IllegalStateException("Cannot delete an entity which defines no ID: " + rootEntity.getName());
                }
                if (o == null) {
                    throw new IllegalArgumentException("Entity to delete cannot be null");
                }
                throw new IllegalArgumentException("Entity argument must be an instance of " + rootEntity.getName());
            }
            batchOperation = this.getBatchOperation(context, Collections.singletonList(o));
            if (o == null) {
                throw new IllegalArgumentException("Entity to delete cannot be null");
            }
        } else {
            throw new IllegalStateException("Expected exactly one argument");
        }
        this.operations.deleteAll(batchOperation);
        return null;
    }
}

