/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.reactivex.Flowable;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;

public class ExecutorReactiveOperations
implements ReactiveRepositoryOperations {
    private final ExecutorAsyncOperations asyncOperations;

    public ExecutorReactiveOperations(@NonNull RepositoryOperations datastore, @NonNull Executor executor) {
        this(new ExecutorAsyncOperations(datastore, executor));
    }

    public ExecutorReactiveOperations(@NonNull ExecutorAsyncOperations asyncOperations) {
        ArgumentUtils.requireNonNull((String)"asyncOperations", (Object)asyncOperations);
        this.asyncOperations = asyncOperations;
    }

    @NonNull
    public <T> Publisher<T> findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.findOne(type, id));
    }

    public <T> Publisher<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.exists(preparedQuery));
    }

    @NonNull
    public <T, R> Publisher<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.findOne(preparedQuery));
    }

    @NonNull
    public <T> Publisher<T> findOptional(@NonNull Class<T> type, @NonNull Serializable id) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.findOptional(type, id));
    }

    @NonNull
    public <T, R> Publisher<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.findOptional(preparedQuery));
    }

    @NonNull
    public <T> Publisher<T> findAll(PagedQuery<T> pagedQuery) {
        return Flowable.fromPublisher((Publisher)Publishers.fromCompletableFuture(() -> this.asyncOperations.findAll(pagedQuery))).flatMap(Flowable::fromIterable);
    }

    @NonNull
    public <T> Publisher<Long> count(PagedQuery<T> pagedQuery) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.count(pagedQuery));
    }

    @NonNull
    public <R> Publisher<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.findPage(pagedQuery));
    }

    @NonNull
    public <T, R> Publisher<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return Flowable.fromPublisher((Publisher)Publishers.fromCompletableFuture(() -> this.asyncOperations.findAll(preparedQuery))).flatMap(Flowable::fromIterable);
    }

    @NonNull
    public <T> Publisher<T> persist(@NonNull InsertOperation<T> entity) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.persist(entity));
    }

    @NonNull
    public <T> Publisher<T> persistAll(@NonNull BatchOperation<T> operation) {
        return Flowable.fromPublisher((Publisher)Publishers.fromCompletableFuture(() -> this.asyncOperations.persistAll(operation))).flatMap(Flowable::fromIterable);
    }

    @NonNull
    public Publisher<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.executeUpdate((PreparedQuery)preparedQuery));
    }

    @NonNull
    public <T> Publisher<Number> deleteAll(BatchOperation<T> operation) {
        return Publishers.fromCompletableFuture(() -> this.asyncOperations.deleteAll(operation));
    }
}

