/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.inject.ExecutableMethod;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class AbstractQueryInterceptor<T, R>
implements DataInterceptor<T, R> {
    private static final String PREDATOR_ANN_NAME = DataMethod.class.getName();
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    protected final RepositoryOperations operations;
    private final ConcurrentMap<Class, Class> lastUpdatedTypes = new ConcurrentHashMap<Class, Class>(10);
    private final ConcurrentMap<RepositoryMethodKey, StoredQuery> findQueries = new ConcurrentHashMap<RepositoryMethodKey, StoredQuery>(50);
    private final ConcurrentMap<RepositoryMethodKey, StoredQuery> countQueries = new ConcurrentHashMap<RepositoryMethodKey, StoredQuery>(50);

    protected AbstractQueryInterceptor(@NonNull RepositoryOperations operations) {
        ArgumentUtils.requireNonNull((String)"operations", (Object)operations);
        this.operations = operations;
    }

    protected final PreparedQuery<?, ?> prepareQuery(RepositoryMethodKey key, MethodInvocationContext<T, R> context) {
        return this.prepareQuery(key, context, null);
    }

    protected final <RT> PreparedQuery<?, RT> prepareQuery(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Class<RT> resultType) {
        String query;
        this.validateNullArguments(context);
        DefaultStoredQuery storedQuery = (DefaultStoredQuery)this.findQueries.get(methodKey);
        if (storedQuery == null) {
            Class rootEntity = (Class)context.classValue(PREDATOR_ANN_NAME, "rootEntity").orElseThrow(() -> new IllegalStateException("No root entity present in method"));
            if (resultType == null) {
                resultType = context.classValue(PREDATOR_ANN_NAME, "resultType").orElse(rootEntity);
            }
            query = (String)context.stringValue(Query.class).orElseThrow(() -> new IllegalStateException("No query present in method"));
            storedQuery = new DefaultStoredQuery(context.getExecutableMethod(), resultType, rootEntity, query, "parameterBinding", false);
            this.findQueries.put(methodKey, storedQuery);
        }
        Pageable pageable = storedQuery.hasPageable() ? this.getPageable(context) : Pageable.UNPAGED;
        query = storedQuery.getQuery();
        return new DefaultPreparedQuery(context, storedQuery, query, pageable, storedQuery.isDtoProjection());
    }

    protected final PreparedQuery<?, Number> prepareCountQuery(RepositoryMethodKey methodKey, @NonNull MethodInvocationContext<T, R> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        DefaultStoredQuery storedQuery = (DefaultStoredQuery)this.countQueries.get(methodKey);
        if (storedQuery == null) {
            String query = (String)context.stringValue(Query.class, "countQuery").orElseThrow(() -> new IllegalStateException("No query present in method"));
            Class<?> rootEntity = this.getRequiredRootEntity(context);
            storedQuery = new DefaultStoredQuery(executableMethod, Long.class, rootEntity, query, "parameterBinding", true);
            this.countQueries.put(methodKey, storedQuery);
        }
        Pageable pageable = storedQuery.hasPageable() ? this.getPageable(context) : Pageable.UNPAGED;
        return new DefaultPreparedQuery(context, storedQuery, storedQuery.getQuery(), pageable, false);
    }

    @NonNull
    protected Class<?> getRequiredRootEntity(MethodInvocationContext context) {
        return (Class)context.classValue(PREDATOR_ANN_NAME, "rootEntity").orElseThrow(() -> new IllegalStateException("No root entity present in method"));
    }

    private <RT> Optional<RT> getParameterInRole(MethodInvocationContext<?, ?> context, @NonNull String role, @NonNull Class<RT> type) {
        return context.stringValue(PREDATOR_ANN_NAME, role).flatMap(name -> {
            Object o;
            Object parameterValue = null;
            Map params = context.getParameters();
            MutableArgumentValue arg = (MutableArgumentValue)params.get(name);
            if (arg != null && (o = arg.getValue()) != null) {
                parameterValue = type.isInstance(o) ? o : ConversionService.SHARED.convert(o, type).orElse(null);
            }
            return Optional.ofNullable(parameterValue);
        });
    }

    @NonNull
    protected Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Pageable pageable = this.getParameterInRole(context, "pageable", Pageable.class).orElse(null);
        if (pageable == null) {
            Sort sort = this.getParameterInRole(context, "sort", Sort.class).orElse(null);
            if (sort != null) {
                int max = context.intValue(PREDATOR_ANN_NAME, "pageSize").orElse(-1);
                int pageIndex = context.intValue(PREDATOR_ANN_NAME, "pageIndex").orElse(0);
                pageable = max > 0 ? Pageable.from((int)pageIndex, (int)max, (Sort)sort) : Pageable.from((Sort)sort);
            } else {
                int max = context.intValue(PREDATOR_ANN_NAME, "pageSize").orElse(-1);
                if (max > -1) {
                    return Pageable.from((int)0, (int)max);
                }
            }
        }
        return pageable != null ? pageable : Pageable.UNPAGED;
    }

    protected boolean isNullable(@NonNull AnnotationMetadata metadata) {
        return metadata.getDeclaredAnnotationNames().stream().anyMatch(n -> NameUtils.getSimpleName((String)n).equalsIgnoreCase("nullable"));
    }

    @NonNull
    protected Object getRequiredEntity(MethodInvocationContext<T, ?> context) {
        String entityParam = (String)context.stringValue(PREDATOR_ANN_NAME, "entity").orElseThrow(() -> new IllegalStateException("No entity parameter specified"));
        Object o = context.getParameterValueMap().get(entityParam);
        if (o == null) {
            throw new IllegalArgumentException("Entity argument cannot be null");
        }
        return o;
    }

    private <RT> Map buildParameterValues(MethodInvocationContext<T, R> context, StoredQuery<?, RT> storedQuery) {
        Map parameterValueMap = context.getParameterValueMap();
        Map parameterBinding = storedQuery.getParameterBinding();
        HashMap parameterValues = new HashMap(parameterBinding.size());
        for (Map.Entry entry : parameterBinding.entrySet()) {
            Object name = entry.getKey();
            String argument = (String)entry.getValue();
            this.storeInParameterValues(context, storedQuery, parameterValueMap, name, argument, parameterValues);
        }
        return parameterValues;
    }

    private <RT> void storeInParameterValues(MethodInvocationContext<T, R> context, StoredQuery<?, RT> storedQuery, Map<String, Object> namedValues, Object index, String argument, Map parameterValues) {
        if (namedValues.containsKey(argument)) {
            parameterValues.put(index, namedValues.get(argument));
        } else {
            String v = storedQuery.getLastUpdatedProperty();
            if (v != null && v.equals(argument)) {
                Class rootEntity = storedQuery.getRootEntity();
                Class<?> lastUpdatedType = this.getLastUpdatedType(rootEntity, v);
                if (lastUpdatedType == null) {
                    throw new IllegalStateException("Could not establish last updated time for entity: " + rootEntity);
                }
                Object timestamp = ConversionService.SHARED.convert((Object)OffsetDateTime.now(), lastUpdatedType).orElse(null);
                if (timestamp == null) {
                    throw new IllegalStateException("Unsupported date type: " + lastUpdatedType);
                }
                parameterValues.put(index, timestamp);
            } else {
                int i = argument.indexOf(46);
                if (i > -1) {
                    String argumentName = argument.substring(0, i);
                    Object o = namedValues.get(argumentName);
                    if (o != null) {
                        try {
                            BeanWrapper wrapper = BeanWrapper.getWrapper((Object)o);
                            String prop = argument.substring(i + 1);
                            Object val = wrapper.getRequiredProperty(prop, Object.class);
                            parameterValues.put(index, val);
                        }
                        catch (IntrospectionException e) {
                            throw new DataAccessException("Embedded value [" + o + "] should be annotated with introspected");
                        }
                    }
                } else {
                    Optional<Argument> named = Arrays.stream(context.getArguments()).filter(arg -> {
                        String n = arg.getAnnotationMetadata().stringValue(Parameter.class).orElse(arg.getName());
                        return n.equals(argument);
                    }).findFirst();
                    if (named.isPresent()) {
                        parameterValues.put(index, namedValues.get(named.get().getName()));
                    } else {
                        throw new IllegalArgumentException("Missing query arguments: " + argument);
                    }
                }
            }
        }
    }

    private Class<?> getLastUpdatedType(Class<?> rootEntity, String property) {
        Class type = (Class)this.lastUpdatedTypes.get(rootEntity);
        if (type == null && (type = (Class)BeanIntrospector.SHARED.findIntrospection(rootEntity).flatMap(bp -> bp.getProperty(property)).map(BeanProperty::getType).orElse(null)) != null) {
            this.lastUpdatedTypes.put(rootEntity, type);
        }
        return type;
    }

    @NonNull
    protected Object instantiateEntity(@NonNull Class<?> rootEntity, @NonNull Map<String, Object> parameterValues) {
        Object instance;
        RuntimePersistentEntity entity = this.operations.getEntity(rootEntity);
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(rootEntity);
        Object[] constructorArguments = introspection.getConstructorArguments();
        if (ArrayUtils.isNotEmpty((Object[])constructorArguments)) {
            Object[] arguments = new Object[constructorArguments.length];
            for (int i = 0; i < constructorArguments.length; ++i) {
                PersistentProperty prop;
                Object argument = constructorArguments[i];
                String argumentName = argument.getName();
                Object v = parameterValues.get(argumentName);
                AnnotationMetadata argMetadata = argument.getAnnotationMetadata();
                if (v == null && !PersistentProperty.isNullableMetadata((AnnotationMetadata)argMetadata) && ((prop = entity.getPropertyByName(argumentName)) == null || prop.isRequired())) {
                    throw new IllegalArgumentException("Argument [" + argumentName + "] cannot be null");
                }
                arguments[i] = v;
            }
            instance = introspection.instantiate(arguments);
        } else {
            instance = introspection.instantiate();
        }
        BeanWrapper wrapper = BeanWrapper.getWrapper((Object)instance);
        Collection persistentProperties = entity.getPersistentProperties();
        for (PersistentProperty prop : persistentProperties) {
            Optional p;
            if (prop.isReadOnly() || prop.isGenerated()) continue;
            String propName = prop.getName();
            if (parameterValues.containsKey(propName)) {
                Object v = parameterValues.get(propName);
                if (v == null && !prop.isOptional()) {
                    throw new IllegalArgumentException("Argument [" + propName + "] cannot be null");
                }
                wrapper.setProperty(propName, v);
                continue;
            }
            if (!prop.isRequired() || (p = wrapper.getProperty(propName, Object.class)).isPresent()) continue;
            throw new IllegalArgumentException("Argument [" + propName + "] cannot be null");
        }
        return instance;
    }

    @Nullable
    protected Number convertNumberArgumentIfNecessary(Number number, Argument<?> argument) {
        Argument firstTypeVar = argument.getFirstTypeVariable().orElse(Argument.of(Long.class));
        Class type = firstTypeVar.getType();
        if (type == Object.class || type == Void.class) {
            return null;
        }
        if (number == null) {
            number = 0;
        }
        if (!type.isInstance(number)) {
            return (Number)ConversionService.SHARED.convert((Object)number, firstTypeVar).orElseThrow(() -> new IllegalStateException("Unsupported number type for return type: " + firstTypeVar));
        }
        return number;
    }

    @NonNull
    protected <E> PagedQuery<E> getPagedQuery(@NonNull MethodInvocationContext context) {
        Class<?> rootEntity = this.getRequiredRootEntity(context);
        Pageable pageable = this.getPageable(context);
        return new DefaultPagedQuery(context.getExecutableMethod(), rootEntity, pageable);
    }

    @NonNull
    protected <E> BatchOperation<E> getBatchOperation(@NonNull MethodInvocationContext context, @NonNull Iterable<E> iterable) {
        Class<?> rootEntity = this.getRequiredRootEntity(context);
        return this.getBatchOperation(context, rootEntity, iterable);
    }

    protected <E> BatchOperation<E> getBatchOperation(@NonNull MethodInvocationContext context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultBatchOperation<E>(context.getExecutableMethod(), rootEntity, iterable);
    }

    @NonNull
    protected <E> BatchOperation<E> getBatchOperation(@NonNull MethodInvocationContext context) {
        Class<?> rootEntity = this.getRequiredRootEntity(context);
        return this.getBatchOperation(context, rootEntity);
    }

    protected <E> BatchOperation<E> getBatchOperation(@NonNull MethodInvocationContext context, @NonNull Class<E> rootEntity) {
        return new AllBatchOperation<E>(context.getExecutableMethod(), rootEntity);
    }

    protected <E> InsertOperation<E> getInsertOperation(@NonNull MethodInvocationContext context) {
        Object o = this.getRequiredEntity(context);
        return new DefaultInsertOperation<Object>(context.getExecutableMethod(), o);
    }

    protected <E> InsertOperation<E> getInsertOperation(@NonNull MethodInvocationContext context, E entity) {
        return new DefaultInsertOperation<E>(context.getExecutableMethod(), entity);
    }

    protected final void validateNullArguments(MethodInvocationContext<T, R> context) {
        Object[] parameterValues = context.getParameterValues();
        for (int i = 0; i < parameterValues.length; ++i) {
            Object o = parameterValues[i];
            if (o != null || context.getArguments()[i].isNullable()) continue;
            throw new IllegalArgumentException("Argument [" + context.getArguments()[i].getName() + "] value is null and the method parameter is not declared as nullable");
        }
    }

    private final class DefaultPreparedQuery<E, RT>
    implements PreparedQuery<E, RT> {
        private final Pageable pageable;
        private final StoredQuery<E, RT> storedQuery;
        private final String query;
        private final boolean dto;
        private final MethodInvocationContext<T, R> context;

        DefaultPreparedQuery(MethodInvocationContext<T, R> context, StoredQuery<E, RT> storedQuery, @NonNull String finalQuery, Pageable pageable, boolean dtoProjection) {
            this.context = context;
            this.query = finalQuery;
            this.storedQuery = storedQuery;
            this.pageable = pageable;
            this.dto = dtoProjection;
        }

        public String[] getParameterNames() {
            return this.storedQuery.getParameterNames();
        }

        public String[] getIndexedParameterPaths() {
            return this.storedQuery.getIndexedParameterPaths();
        }

        public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
            return AbstractQueryInterceptor.this.getParameterInRole(this.context, role, type);
        }

        public Class<?> getLastUpdatedType() {
            return AbstractQueryInterceptor.this.getLastUpdatedType(this.getRootEntity(), this.getLastUpdatedProperty());
        }

        public boolean hasResultConsumer() {
            return this.storedQuery.hasResultConsumer();
        }

        @NonNull
        public int[] getIndexedParameterBinding() {
            return this.storedQuery.getIndexedParameterBinding();
        }

        @NonNull
        public Set<JoinPath> getJoinFetchPaths() {
            return this.storedQuery.getJoinFetchPaths();
        }

        public boolean isSingleResult() {
            return this.storedQuery.isSingleResult();
        }

        @NonNull
        public DataType[] getIndexedParameterTypes() {
            return this.storedQuery.getIndexedParameterTypes();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.storedQuery.getAnnotationMetadata();
        }

        @NonNull
        public Map<String, Object> getQueryHints() {
            return this.storedQuery.getQueryHints();
        }

        public Class<?> getRepositoryType() {
            return this.context.getTarget().getClass();
        }

        @NonNull
        public Map<String, Object> getParameterValues() {
            return AbstractQueryInterceptor.this.buildParameterValues(this.context, (StoredQuery)this);
        }

        public Object[] getParameterArray() {
            return this.context.getParameterValues();
        }

        public Argument[] getArguments() {
            return this.context.getArguments();
        }

        @NonNull
        public Pageable getPageable() {
            if (this.storedQuery.isCount()) {
                return Pageable.UNPAGED;
            }
            return this.pageable;
        }

        public boolean isNative() {
            return this.storedQuery.isNative();
        }

        public boolean useNumericPlaceholders() {
            return this.storedQuery.useNumericPlaceholders();
        }

        public boolean isDtoProjection() {
            return this.dto;
        }

        @NonNull
        public Class<RT> getResultType() {
            return this.storedQuery.getResultType();
        }

        @NonNull
        public DataType getResultDataType() {
            return this.storedQuery.getResultDataType();
        }

        @Nullable
        public Optional<Class<?>> getEntityIdentifierType() {
            return this.storedQuery.getEntityIdentifierType();
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.storedQuery.getRootEntity();
        }

        public boolean hasInExpression() {
            return this.storedQuery.hasInExpression();
        }

        public boolean hasPageable() {
            return this.storedQuery.hasPageable();
        }

        @NonNull
        public String getQuery() {
            return this.query;
        }

        @NonNull
        public Class<?>[] getArgumentTypes() {
            return this.storedQuery.getArgumentTypes();
        }

        @NonNull
        public Map<String, String> getParameterBinding() {
            return this.storedQuery.getParameterBinding();
        }

        public boolean isCount() {
            return this.storedQuery.isCount();
        }

        public String getLastUpdatedProperty() {
            return this.storedQuery.getLastUpdatedProperty();
        }

        @Nonnull
        public String getName() {
            return this.storedQuery.getName();
        }
    }

    private final class DefaultStoredQuery<E, RT>
    implements StoredQuery<E, RT> {
        @NonNull
        private final Class<RT> resultType;
        @NonNull
        private final Class<E> rootEntity;
        @NonNull
        private final String query;
        @Nullable
        private final Map<String, String> parameterBinding;
        @Nullable
        private final int[] indexedParameterBinding;
        @Nullable
        private final String[] parameterPaths;
        private final ExecutableMethod<?, ?> method;
        private final String lastUpdatedProp;
        private final boolean isDto;
        private final boolean isNative;
        private final boolean isNumericPlaceHolder;
        private final boolean hasPageable;
        private final AnnotationMetadata annotationMetadata;
        private final boolean hasIn;
        private final boolean isCount;
        private final DataType[] indexedDataTypes;
        private final String[] parameterNames;
        private final boolean hasResultConsumer;
        private Map<String, Object> queryHints;
        private Set<JoinPath> joinFetchPaths = null;

        DefaultStoredQuery(@NonNull ExecutableMethod<?, ?> method, @NonNull Class<RT> resultType, @NonNull Class<E> rootEntity, @Nullable String query, String parameterBindingMember, boolean isCount) {
            Map queryHints;
            this.resultType = ReflectionUtils.getWrapperType(resultType);
            this.rootEntity = rootEntity;
            this.annotationMetadata = method.getAnnotationMetadata();
            this.isNative = method.isTrue(Query.class, "nativeQuery");
            this.hasResultConsumer = method.stringValue(PREDATOR_ANN_NAME, "sqlMappingFunction").isPresent();
            this.isNumericPlaceHolder = method.classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
            this.hasIn = this.isNumericPlaceHolder && query.contains(" ?$IN(");
            boolean bl = this.hasPageable = method.stringValue(PREDATOR_ANN_NAME, "pageable").isPresent() || method.stringValue(PREDATOR_ANN_NAME, "sort").isPresent() || method.intValue(PREDATOR_ANN_NAME, "pageSize").orElse(-1) > -1;
            if (this.isNumericPlaceHolder && method.isTrue(Query.class, "rawQuery")) {
                Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(query);
                this.query = matcher.replaceAll("?");
            } else {
                this.query = query;
            }
            this.method = method;
            this.lastUpdatedProp = method.stringValue(PREDATOR_ANN_NAME, "lastUpdatedProperty").orElse(null);
            this.isDto = method.isTrue(PREDATOR_ANN_NAME, "dto");
            this.isCount = isCount;
            AnnotationValue annotation = this.annotationMetadata.getAnnotation(DataMethod.class);
            if (parameterBindingMember != null && annotation != null) {
                this.indexedParameterBinding = annotation.get((CharSequence)parameterBindingMember, int[].class).orElse(EMPTY_INT_ARRAY);
                if (this.isNumericPlaceHolder) {
                    String[] strArray = annotation.stringValues(parameterBindingMember + "Paths");
                    if (strArray.length == this.indexedParameterBinding.length) {
                        for (int i = 0; i < strArray.length; ++i) {
                            String s = strArray[i];
                            if (!StringUtils.isEmpty((CharSequence)s)) continue;
                            strArray[i] = null;
                        }
                        this.parameterPaths = strArray;
                    } else {
                        this.parameterPaths = new String[this.indexedParameterBinding.length];
                    }
                    this.parameterBinding = null;
                    this.parameterNames = null;
                } else {
                    this.parameterBinding = null;
                    this.parameterPaths = annotation.stringValues(parameterBindingMember + "Paths");
                    this.parameterNames = annotation.stringValues(parameterBindingMember + "Names");
                }
            } else {
                this.indexedParameterBinding = EMPTY_INT_ARRAY;
                this.parameterPaths = null;
                this.parameterBinding = null;
                this.parameterNames = null;
            }
            if (method.hasAnnotation(QueryHint.class)) {
                List values = method.getAnnotationValuesByType(QueryHint.class);
                this.queryHints = new HashMap<String, Object>(values.size());
                for (AnnotationValue value : values) {
                    String n = value.stringValue("name").orElse(null);
                    String v = value.stringValue("value").orElse(null);
                    if (!StringUtils.isNotEmpty((CharSequence)n) || !StringUtils.isNotEmpty((CharSequence)v)) continue;
                    this.queryHints.put(n, v);
                }
            }
            if ((queryHints = AbstractQueryInterceptor.this.operations.getQueryHints((StoredQuery)this)) != Collections.EMPTY_MAP) {
                if (this.queryHints != null) {
                    this.queryHints.putAll(queryHints);
                } else {
                    this.queryHints = queryHints;
                }
            }
            this.indexedDataTypes = this.isNumericPlaceHolder ? this.annotationMetadata.getValue(DataMethod.class, "parameterTypeDefs", DataType[].class).orElse(DataType.EMPTY_DATA_TYPE_ARRAY) : null;
        }

        public String[] getParameterNames() {
            if (this.parameterNames == null) {
                return StringUtils.EMPTY_STRING_ARRAY;
            }
            return this.parameterNames;
        }

        public String[] getIndexedParameterPaths() {
            if (this.parameterPaths != null) {
                return this.parameterPaths;
            }
            return StringUtils.EMPTY_STRING_ARRAY;
        }

        @NonNull
        public Set<JoinPath> getJoinFetchPaths() {
            if (this.joinFetchPaths == null) {
                Set set = this.method.getAnnotationValuesByType(Join.class).stream().filter(this::isJoinFetch).map(av -> {
                    String path = (String)av.stringValue().orElseThrow(() -> new IllegalStateException("Should not include annotations without a value definition"));
                    String alias = av.stringValue("alias").orElse(null);
                    return new JoinPath(path, new Association[0], Join.Type.DEFAULT, alias);
                }).collect(Collectors.toSet());
                this.joinFetchPaths = set.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(set);
            }
            return this.joinFetchPaths;
        }

        public boolean isSingleResult() {
            return !this.isCount() && this.getJoinFetchPaths().isEmpty();
        }

        public boolean hasResultConsumer() {
            return this.hasResultConsumer;
        }

        private boolean isJoinFetch(AnnotationValue<Join> av) {
            if (!av.stringValue().isPresent()) {
                return false;
            }
            Optional type = av.stringValue("type");
            return !type.isPresent() || ((String)type.get()).contains("FETCH");
        }

        public boolean isCount() {
            return this.isCount;
        }

        @NonNull
        public DataType[] getIndexedParameterTypes() {
            if (this.indexedDataTypes == null) {
                return DataType.EMPTY_DATA_TYPE_ARRAY;
            }
            return this.indexedDataTypes;
        }

        @NonNull
        public int[] getIndexedParameterBinding() {
            if (this.indexedParameterBinding != null) {
                return this.indexedParameterBinding;
            }
            return EMPTY_INT_ARRAY;
        }

        @NonNull
        public Map<String, Object> getQueryHints() {
            if (this.queryHints != null) {
                return this.queryHints;
            }
            return Collections.emptyMap();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.annotationMetadata;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public boolean useNumericPlaceholders() {
            return this.isNumericPlaceHolder;
        }

        public boolean isDtoProjection() {
            return this.isDto;
        }

        @NonNull
        public Class<RT> getResultType() {
            return this.resultType;
        }

        @NonNull
        public DataType getResultDataType() {
            return this.annotationMetadata.enumValue(PREDATOR_ANN_NAME, "resultDataType", DataType.class).orElse(DataType.OBJECT);
        }

        public Optional<Class<?>> getEntityIdentifierType() {
            Optional o = this.annotationMetadata.classValue(PREDATOR_ANN_NAME, "idType");
            return o;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        public boolean hasInExpression() {
            return this.hasIn;
        }

        public boolean hasPageable() {
            return this.hasPageable;
        }

        @NonNull
        public String getQuery() {
            return this.query;
        }

        @Nonnull
        public String getName() {
            return this.method.getMethodName();
        }

        @NonNull
        public Class<?>[] getArgumentTypes() {
            return this.method.getArgumentTypes();
        }

        @NonNull
        public Map<String, String> getParameterBinding() {
            if (this.parameterBinding == null) {
                return Collections.emptyMap();
            }
            return this.parameterBinding;
        }

        public String getLastUpdatedProperty() {
            return this.lastUpdatedProp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultStoredQuery that = (DefaultStoredQuery)o;
            return this.resultType.equals(that.resultType) && this.method.equals(that.method);
        }

        public int hashCode() {
            return Objects.hash(this.resultType, this.method);
        }
    }

    private final class DefaultPagedQuery<E>
    implements PagedQuery<E> {
        private final ExecutableMethod<?, ?> method;
        @NonNull
        private final Class<E> rootEntity;
        private final Pageable pageable;

        DefaultPagedQuery(@NonNull ExecutableMethod<?, ?> method, Class<E> rootEntity, Pageable pageable) {
            this.method = method;
            this.rootEntity = rootEntity;
            this.pageable = pageable;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @NonNull
        public Pageable getPageable() {
            return this.pageable;
        }

        @Nonnull
        public String getName() {
            return this.method.getMethodName();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }

    private final class AllBatchOperation<E>
    implements BatchOperation<E> {
        private final ExecutableMethod<?, ?> method;
        @NonNull
        private final Class<E> rootEntity;

        public AllBatchOperation(@NonNull ExecutableMethod<?, ?> method, Class<E> rootEntity) {
            this.method = method;
            this.rootEntity = rootEntity;
        }

        public boolean all() {
            return true;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @Nonnull
        public String getName() {
            return this.method.getMethodName();
        }

        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }

    private final class DefaultBatchOperation<E>
    implements BatchOperation<E> {
        private final ExecutableMethod<?, ?> method;
        @NonNull
        private final Class<E> rootEntity;
        private final Iterable<E> iterable;

        public DefaultBatchOperation(@NonNull ExecutableMethod<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            this.method = method;
            this.rootEntity = rootEntity;
            this.iterable = iterable;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @Nonnull
        public String getName() {
            return this.method.getMethodName();
        }

        public Iterator<E> iterator() {
            return this.iterable.iterator();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }

    private final class DefaultInsertOperation<E>
    implements InsertOperation<E> {
        private final ExecutableMethod<?, ?> method;
        private final E entity;

        DefaultInsertOperation(ExecutableMethod<?, ?> method, E entity) {
            this.method = method;
            this.entity = entity;
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.entity.getClass();
        }

        public E getEntity() {
            return this.entity;
        }

        @Nonnull
        public String getName() {
            return this.method.getMethodName();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }
}

