/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper.sql;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public final class SqlResultEntityTypeMapper<RS, R>
implements SqlTypeMapper<RS, R> {
    private final RuntimePersistentEntity<R> entity;
    private final ResultReader<RS, String> resultReader;
    private final Map<String, JoinPath> joinPaths;
    private final String startingPrefix;
    private boolean callNext = true;

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader) {
        this(entity, resultReader, Collections.emptySet());
    }

    public SqlResultEntityTypeMapper(String prefix, @NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader) {
        this(entity, resultReader, Collections.emptySet(), prefix);
    }

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths) {
        this(entity, resultReader, joinPaths, null);
    }

    private SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, String startingPrefix) {
        ArgumentUtils.requireNonNull((String)"entity", entity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.entity = entity;
        this.resultReader = resultReader;
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            this.joinPaths = new HashMap<String, JoinPath>(joinPaths.size());
            for (JoinPath joinPath : joinPaths) {
                this.joinPaths.put(joinPath.getPath(), joinPath);
            }
        } else {
            this.joinPaths = Collections.emptyMap();
        }
        this.startingPrefix = startingPrefix;
    }

    @NonNull
    public RuntimePersistentEntity<R> getEntity() {
        return this.entity;
    }

    @NonNull
    public ResultReader<RS, String> getResultReader() {
        return this.resultReader;
    }

    @Override
    @NonNull
    public R map(@NonNull RS object, @NonNull Class<R> type) throws DataAccessException {
        return this.readEntity(this.startingPrefix, null, object, this.entity, false);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull String name) {
        RuntimePersistentProperty property = this.entity.getPropertyByName(name);
        if (property == null) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.entity.getName());
        }
        return this.resultReader.readDynamic(resultSet, property.getPersistedName(), property.getDataType());
    }

    private R readEntity(String prefix, String path, RS rs, RuntimePersistentEntity<R> persistentEntity, boolean isEmbedded) {
        BeanIntrospection introspection = persistentEntity.getIntrospection();
        Object[] constructorArguments = persistentEntity.getConstructorArguments();
        try {
            Association association;
            Object entity;
            boolean hasPath;
            Object id = null;
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            boolean hasPrefix = prefix != null;
            boolean bl = hasPath = path != null;
            if (identity != null) {
                if (identity instanceof Embedded) {
                    PersistentEntity embeddedEntity = ((Embedded)identity).getAssociatedEntity();
                    id = this.readEntity(identity.getPersistedName() + "_", (hasPath ? path : "") + identity.getName() + '.', rs, (RuntimePersistentEntity)embeddedEntity, true);
                } else {
                    String columnName = this.resolveColumnName(identity, prefix, isEmbedded, hasPrefix);
                    id = this.resultReader.readDynamic(rs, columnName, DataType.OBJECT);
                    if (id == null) {
                        return null;
                    }
                }
            }
            if (ArrayUtils.isEmpty((Object[])constructorArguments)) {
                entity = introspection.instantiate();
            } else {
                int len = constructorArguments.length;
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object prop = constructorArguments[i];
                    if (prop != null) {
                        if (prop instanceof Association) {
                            Object associated;
                            args[i] = associated = this.readAssociation(hasPrefix ? prefix : "", hasPath ? path : "", rs, (Association)prop, hasPrefix);
                            continue;
                        }
                        String columnName = this.resolveColumnName((RuntimePersistentProperty<R>)prop, prefix, isEmbedded, hasPrefix);
                        Object v = this.resultReader.readDynamic(rs, columnName, prop.getDataType());
                        if (v == null) {
                            if (!prop.isOptional()) {
                                throw new DataAccessException("Null value read for non-null constructor argument [" + prop.getName() + "] of type: " + persistentEntity.getName());
                            }
                            args[i] = null;
                            continue;
                        }
                        Class t = prop.getType();
                        if (!t.isInstance(v)) {
                            args[i] = this.resultReader.convertRequired(v, t);
                            continue;
                        }
                        args[i] = v;
                        continue;
                    }
                    throw new DataAccessException("Constructor argument [" + constructorArguments[i].getName() + "] must have an associated getter.");
                }
                entity = introspection.instantiate(args);
            }
            HashMap toManyJoins = null;
            for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
                RuntimePersistentProperty rpp = (RuntimePersistentProperty)persistentProperty;
                if (persistentProperty.isReadOnly() || persistentProperty.isConstructorArgument()) continue;
                BeanProperty property = rpp.getProperty();
                if (persistentProperty instanceof Association) {
                    association = (Association)persistentProperty;
                    if (!association.isForeignKey()) {
                        Object associated = this.readAssociation(prefix, hasPath ? path : "", rs, association, hasPrefix);
                        if (associated == null) continue;
                        property.set(entity, associated);
                        continue;
                    }
                    Relation.Kind kind = association.getKind();
                    boolean hasJoin = this.joinPaths.containsKey((hasPath ? path : "") + association.getName());
                    if (!hasJoin) continue;
                    if (kind == Relation.Kind.ONE_TO_ONE && association.isForeignKey()) {
                        Object associated = this.readAssociation(prefix, hasPath ? path : "", rs, association, hasPrefix);
                        if (associated == null) continue;
                        property.set(entity, associated);
                        continue;
                    }
                    if (id == null || kind != Relation.Kind.ONE_TO_MANY && kind != Relation.Kind.MANY_TO_MANY) continue;
                    if (toManyJoins == null) {
                        toManyJoins = new HashMap(3);
                    }
                    toManyJoins.put(association, new ArrayList());
                    continue;
                }
                String columnName = this.resolveColumnName((RuntimePersistentProperty)persistentProperty, prefix, isEmbedded, hasPrefix);
                Object v = this.resultReader.readDynamic(rs, columnName, persistentProperty.getDataType());
                if (rpp.getType().isInstance(v)) {
                    property.set(entity, v);
                    continue;
                }
                property.convertAndSet(entity, v);
            }
            if (id != null) {
                BeanProperty property;
                Object currentId = id;
                if (CollectionUtils.isNotEmpty(toManyJoins)) {
                    while (currentId != null && currentId.equals(id)) {
                        Iterator persistentProperty = toManyJoins.entrySet().iterator();
                        while (persistentProperty.hasNext()) {
                            Map.Entry entry;
                            Association association2;
                            Object associated = this.readAssociation(hasPrefix ? prefix : "", hasPath ? path : "", rs, association2 = (Association)(entry = persistentProperty.next()).getKey(), hasPrefix);
                            if (associated == null) continue;
                            ((List)entry.getValue()).add(associated);
                        }
                        currentId = this.nextId(identity, rs);
                    }
                    if (currentId != null) {
                        this.callNext = false;
                    }
                    for (Map.Entry entry : toManyJoins.entrySet()) {
                        List value = (List)entry.getValue();
                        association = (RuntimePersistentProperty)entry.getKey();
                        BeanProperty property2 = association.getProperty();
                        if (property2.getType().isInstance(value)) {
                            property2.set(entity, (Object)value);
                            continue;
                        }
                        property2.convertAndSet(entity, (Object)value);
                    }
                }
                if (!(property = identity.getProperty()).isReadOnly()) {
                    if (property.getType().isInstance(id)) {
                        property.set(entity, id);
                    } else {
                        property.convertAndSet(entity, id);
                    }
                }
            }
            return (R)entity;
        }
        catch (InstantiationException e) {
            throw new DataAccessException("Error instantiating entity [" + persistentEntity.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private String resolveColumnName(RuntimePersistentProperty<R> identity, String prefix, boolean isEmbedded, boolean hasPrefix) {
        String persistedName = identity.getPersistedName();
        String columnName = hasPrefix ? (isEmbedded && identity.getAnnotationMetadata().stringValue(MappedProperty.class).isPresent() ? persistedName : prefix + persistedName) : persistedName;
        return columnName;
    }

    Object nextId(@NonNull RuntimePersistentProperty<R> identity, @NonNull RS resultSet) {
        return this.resultReader.readNextDynamic(resultSet, identity.getPersistedName(), identity.getDataType());
    }

    @Nullable
    private Object readAssociation(String prefix, String path, RS resultSet, Association association, boolean hasPrefix) {
        RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
        Object associated = null;
        String associationName = association.getName();
        if (association instanceof Embedded) {
            associated = this.readEntity(association.getPersistedName() + "_", path + associationName + '.', resultSet, associatedEntity, true);
        } else {
            String persistedName = association.getPersistedName();
            RuntimePersistentProperty identity = associatedEntity.getIdentity();
            String joinPath = path + associationName;
            if (this.joinPaths.containsKey(joinPath)) {
                JoinPath jp = this.joinPaths.get(joinPath);
                String newPrefix = jp.getAlias().orElseGet(() -> !hasPrefix ? "_" + association.getAliasName() : prefix + association.getAliasName());
                associated = this.readEntity(newPrefix, path + associationName + '.', resultSet, associatedEntity, false);
            } else {
                Argument arg;
                BeanIntrospection associatedIntrospection = associatedEntity.getIntrospection();
                Argument[] constructorArgs = associatedIntrospection.getConstructorArguments();
                if (constructorArgs.length == 0) {
                    associated = associatedIntrospection.instantiate();
                    if (identity != null) {
                        Object v = this.resultReader.readDynamic(resultSet, hasPrefix ? prefix + persistedName : persistedName, identity.getDataType());
                        BeanWrapper.getWrapper((Object)associated).setProperty(identity.getName(), v);
                    }
                } else if (constructorArgs.length == 1 && identity != null && (arg = constructorArgs[0]).getName().equals(identity.getName()) && arg.getType() == identity.getType()) {
                    Object v = this.resultReader.readDynamic(resultSet, hasPrefix ? prefix + persistedName : persistedName, identity.getDataType());
                    associated = associatedIntrospection.instantiate(new Object[]{this.resultReader.convertRequired(v, identity.getType())});
                }
            }
        }
        return associated;
    }

    @Override
    public boolean hasNext(RS resultSet) {
        if (this.callNext) {
            return this.resultReader.next(resultSet);
        }
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            this.callNext = true;
        }
    }
}

