/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;

public class DefaultDeleteAllInterceptor<T>
extends AbstractQueryInterceptor<T, Number>
implements DeleteAllInterceptor<T> {
    protected DefaultDeleteAllInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Number> context) {
        Argument resultType = context.getReturnType().asArgument();
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            Number result = this.operations.executeUpdate(preparedQuery).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, result);
        }
        Object[] parameterValues = context.getParameterValues();
        Class<?> rootEntity = this.getRequiredRootEntity(context);
        if (parameterValues.length == 1 && parameterValues[0] instanceof Iterable) {
            Iterable iterable = (Iterable)parameterValues[0];
            BatchOperation<?> batchOperation = this.getBatchOperation(context, rootEntity, iterable);
            Number deleted = this.operations.deleteAll(batchOperation).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, deleted);
        }
        if (parameterValues.length == 0) {
            BatchOperation<?> batchOperation = this.getBatchOperation(context, rootEntity);
            Number result = this.operations.deleteAll(batchOperation).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, result);
        }
        throw new IllegalArgumentException("Unexpected argument types received to deleteAll method");
    }

    private Number convertIfNecessary(Argument<Number> resultType, Number result) {
        if (!resultType.getType().isInstance(result)) {
            return ConversionService.SHARED.convert((Object)result, resultType).orElse(0);
        }
        return result;
    }
}

