/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ExecutorAsyncOperations
implements AsyncRepositoryOperations {
    private final RepositoryOperations datastore;
    private final Executor executor;

    public ExecutorAsyncOperations(@NonNull RepositoryOperations operations, @NonNull Executor executor) {
        ArgumentUtils.requireNonNull((String)"operations", (Object)operations);
        ArgumentUtils.requireNonNull((String)"executor", (Object)executor);
        this.datastore = operations;
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @NonNull
    public <T> CompletableFuture<T> findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Object r = this.datastore.findOne(type, id);
                if (r != null) {
                    future.complete(r);
                } else {
                    future.completeExceptionally((Throwable)new EmptyResultException());
                }
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T, R> CompletableFuture<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Object r = this.datastore.findOne(preparedQuery);
                if (r != null) {
                    future.complete(r);
                } else {
                    future.completeExceptionally((Throwable)new EmptyResultException());
                }
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T> CompletableFuture<T> findOptional(@NonNull Class<T> type, @NonNull Serializable id) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Object r = this.datastore.findOne(type, id);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T, R> CompletableFuture<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Object r = this.datastore.findOne(preparedQuery);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T> CompletableFuture<Iterable<T>> findAll(@NonNull PagedQuery<T> pagedQuery) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Iterable r = this.datastore.findAll(pagedQuery);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public <T> CompletableFuture<Long> count(@NonNull PagedQuery<T> pagedQuery) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.executor.execute(() -> {
            try {
                long r = this.datastore.count(pagedQuery);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T, R> CompletableFuture<Iterable<R>> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Iterable r = this.datastore.findAll(preparedQuery);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T> CompletableFuture<T> persist(@NonNull InsertOperation<T> entity) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Object r = this.datastore.persist(entity);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T> CompletableFuture<Iterable<T>> persistAll(@NonNull BatchOperation<T> operation) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Iterable r = this.datastore.persistAll(operation);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public CompletableFuture<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        CompletableFuture<Number> future = new CompletableFuture<Number>();
        this.executor.execute(() -> {
            try {
                Number n = this.datastore.executeUpdate(preparedQuery).orElse(0);
                future.complete(n);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NonNull
    public <T> CompletableFuture<Number> deleteAll(@NonNull BatchOperation<T> operation) {
        CompletableFuture<Number> future = new CompletableFuture<Number>();
        this.executor.execute(() -> {
            try {
                Number total = this.datastore.deleteAll(operation).orElse(0);
                future.complete(total);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public <R> CompletableFuture<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                Page r = this.datastore.findPage(pagedQuery);
                future.complete(r);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

