/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodResult;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;

@Internal
public final class MatchUtils {
    private MatchUtils() {
    }

    public static MethodResult analyzeMethodResult(ClassElement repositoryClass, ClassElement rootEntity, @Nullable ClassElement queryResultType, FindersUtils.InterceptorMatch interceptorMatch, boolean allowEntityResultByDefault) {
        ClassElement resultType = interceptorMatch.returnType();
        if (resultType == null || queryResultType == null || MatchUtils.isVoid(resultType) || rootEntity.equals((Object)resultType)) {
            return new MethodResult(resultType, false, false);
        }
        boolean isRuntimeDto = false;
        boolean isDto = MatchUtils.isIsDto(repositoryClass, queryResultType, resultType);
        if (isDto) {
            isRuntimeDto = MatchUtils.isDtoType(repositoryClass, resultType);
        } else if (interceptorMatch.validateReturnType()) {
            if (TypeUtils.areTypesCompatible(resultType, queryResultType)) {
                if (!queryResultType.isPrimitive()) {
                    resultType = queryResultType;
                }
            } else if (!allowEntityResultByDefault) {
                throw new MatchFailedException("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + resultType.getName());
            }
        }
        return new MethodResult(resultType, isDto, isRuntimeDto);
    }

    private static boolean isIsDto(ClassElement repositoryClass, ClassElement queryResultType, ClassElement resultType) {
        if (TypeUtils.areTypesCompatible(resultType, queryResultType)) {
            return false;
        }
        return MatchUtils.isDtoType(repositoryClass, resultType) || MatchUtils.isDto(queryResultType, resultType);
    }

    public static boolean isDto(ClassElement entityType, ClassElement resultType) {
        return resultType.hasStereotype(Introspected.class) && entityType.hasStereotype(MappedEntity.class);
    }

    private static boolean isVoid(ClassElement resultType) {
        return resultType.isAssignable(Void.TYPE) || resultType.isAssignable(Void.class) || resultType.getName().equals("kotlin.Unit");
    }

    private static boolean isDtoType(ClassElement repositoryElement, ClassElement classElement) {
        return Arrays.stream(repositoryElement.stringValues(RepositoryConfiguration.class, "queryDtoTypes")).anyMatch(type -> classElement.getName().equals(type));
    }
}

