/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Projection;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCommonAbstractCriteria;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityQuery;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.processor.jdql.JDQLCriteriaBuilderUtils;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodResult;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import jakarta.persistence.criteria.Root;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public final class JakartaDataQueryMethodMatcher
implements MethodMatcher {
    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        Optional jdqlQuery = matchContext.getMethodElement().stringValue("jakarta.data.repository.Query");
        if (jdqlQuery.isPresent()) {
            Function<String, ClassElement> findClassElementFn = name -> {
                SourcePersistentEntity rootEntity = matchContext.getRootEntity();
                if (rootEntity != null && rootEntity.getSimpleName().equals(name)) {
                    return rootEntity.getClassElement();
                }
                SourcePersistentEntity persistentEntity = matchContext.getEntityBySimplyNameResolver().apply((String)name);
                if (persistentEntity != null) {
                    return persistentEntity.getClassElement();
                }
                return (ClassElement)matchContext.getVisitorContext().getClassElement(name).orElseThrow(() -> new ProcessingException((Element)matchContext.getMethodElement(), "Unable to find an entity: " + name));
            };
            PersistentEntityCommonAbstractCriteria criteriaQuery = JDQLCriteriaBuilderUtils.build((String)jdqlQuery.get(), matchContext.getRootEntity(), matchContext.getMethodElement(), findClassElementFn, new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext));
            matchContext.setRootEntity((SourcePersistentEntity)criteriaQuery.getPersistentEntity());
            if (criteriaQuery instanceof PersistentEntityCriteriaUpdate) {
                return JakartaDataQueryMethodMatcher.getUpdateQuery(criteriaQuery);
            }
            if (criteriaQuery instanceof PersistentEntityCriteriaDelete) {
                return JakartaDataQueryMethodMatcher.getDeleteQuery(criteriaQuery);
            }
            if (criteriaQuery instanceof PersistentEntityCriteriaQuery) {
                return JakartaDataQueryMethodMatcher.getSelectQuery(criteriaQuery, (String)jdqlQuery.get(), findClassElementFn);
            }
            return null;
        }
        return null;
    }

    private static AbstractCriteriaMethodMatch getUpdateQuery(final PersistentEntityCommonAbstractCriteria criteriaQuery) {
        return new AbstractCriteriaMethodMatch(List.of()){

            @Override
            protected DataMethod.OperationType getOperationType() {
                return DataMethod.OperationType.UPDATE;
            }

            @Override
            protected MethodMatchInfo build(MethodMatchContext matchContext) {
                FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
                ClassElement resultType = interceptorMatch.returnType();
                boolean isDto = false;
                ClassElement interceptorType = interceptorMatch.interceptor();
                AbstractPersistentEntityCriteriaUpdate query = (AbstractPersistentEntityCriteriaUpdate)criteriaQuery;
                boolean optimisticLock = query.hasVersionRestriction();
                AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
                QueryBuilder queryBuilder = matchContext.getQueryBuilder();
                QueryResult queryResult = criteriaQuery.build((AnnotationMetadata)annotationMetadataHierarchy, queryBuilder);
                return new MethodMatchInfo(this.getOperationType(), (TypedElement)resultType, interceptorType).dto(isDto).optimisticLock(optimisticLock).queryResult(queryResult);
            }
        };
    }

    private static AbstractCriteriaMethodMatch getDeleteQuery(final PersistentEntityCommonAbstractCriteria criteriaQuery) {
        return new AbstractCriteriaMethodMatch(List.of()){

            @Override
            protected DataMethod.OperationType getOperationType() {
                return DataMethod.OperationType.DELETE;
            }

            @Override
            protected MethodMatchInfo build(MethodMatchContext matchContext) {
                FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
                ClassElement resultType = interceptorMatch.returnType();
                ClassElement interceptorType = interceptorMatch.interceptor();
                boolean optimisticLock = ((AbstractPersistentEntityCriteriaDelete)criteriaQuery).hasVersionRestriction();
                AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
                QueryBuilder queryBuilder = matchContext.getQueryBuilder();
                QueryResult queryResult = criteriaQuery.build((AnnotationMetadata)annotationMetadataHierarchy, queryBuilder);
                return new MethodMatchInfo(this.getOperationType(), (TypedElement)resultType, interceptorType).optimisticLock(optimisticLock).queryResult(queryResult);
            }
        };
    }

    private static AbstractCriteriaMethodMatch getSelectQuery(final PersistentEntityCommonAbstractCriteria criteriaQuery, final String query, final Function<String, ClassElement> findClassElementFn) {
        return new AbstractCriteriaMethodMatch(List.of()){

            @Override
            protected DataMethod.OperationType getOperationType() {
                return DataMethod.OperationType.QUERY;
            }

            @Override
            protected MethodMatchInfo build(MethodMatchContext matchContext) {
                List<SourcePersistentProperty> dtoProjectionProperties;
                FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
                ClassElement interceptorType = interceptorMatch.interceptor();
                AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
                QueryBuilder queryBuilder = matchContext.getQueryBuilder();
                if (matchContext.hasParameterInRole("pageable")) {
                    Element pageableParameter = matchContext.findParameterInRole("pageable");
                    abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)criteriaQuery;
                    abstractPersistentEntityQuery.getParametersInRole().put(List.of(matchContext.getParameters()).indexOf(pageableParameter), "pageable");
                } else if (matchContext.hasParameterInRole("sort")) {
                    Element sortParameter = matchContext.findParameterInRole("sort");
                    abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)criteriaQuery;
                    abstractPersistentEntityQuery.getParametersInRole().put(List.of(matchContext.getParameters()).indexOf(sortParameter), "sort");
                } else if (matchContext.hasParameterInRole("querylimit")) {
                    Element limitParameter = matchContext.findParameterInRole("querylimit");
                    abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)criteriaQuery;
                    abstractPersistentEntityQuery.getParametersInRole().put(List.of(matchContext.getParameters()).indexOf(limitParameter), "querylimit");
                }
                SourcePersistentEntityCriteriaQuery criteriaQueryInternal = (SourcePersistentEntityCriteriaQuery)criteriaQuery;
                MethodResult result = this.analyzeMethodResult(matchContext, criteriaQueryInternal.getQueryResultTypeName(), matchContext.getRootEntity().getClassElement(), interceptorMatch, false);
                if (result.isDto() && criteriaQueryInternal.getSelection() == null && !(dtoProjectionProperties = this.getDtoProjectionProperties(matchContext.getRootEntity(), matchContext.getMethodElement(), result.resultType())).isEmpty()) {
                    Root root = (Root)criteriaQueryInternal.getRoots().iterator().next();
                    List selectionList = dtoProjectionProperties.stream().map(p -> {
                        matchContext.getMethodElement().annotate(Projection.class, b -> b.value(p.getName()));
                        if (matchContext.getQueryBuilder() instanceof SqlQueryBuilder) {
                            return root.get(p.getName());
                        }
                        return root.get(p.getName()).alias(p.getName());
                    }).collect(Collectors.toList());
                    criteriaQueryInternal.multiselect(selectionList);
                }
                QueryResult queryResult = criteriaQuery.build((AnnotationMetadata)annotationMetadataHierarchy, queryBuilder);
                ClassElement genericReturnType = matchContext.getReturnType();
                if (matchContext.isTypeInRole(genericReturnType, "page") || matchContext.isTypeInRole(genericReturnType, "cursoredPage")) {
                    PersistentEntityCriteriaQuery<?> countCriteriaQuery = JDQLCriteriaBuilderUtils.buildCount(query, matchContext.getRootEntity(), matchContext.getMethodElement(), findClassElementFn, new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext));
                    QueryResult countQueryResult = countCriteriaQuery.build((AnnotationMetadata)annotationMetadataHierarchy, queryBuilder);
                    return new MethodMatchInfo(this.getOperationType(), (TypedElement)result.resultType(), interceptorType).dto(result.isDto()).queryResult(queryResult).countQueryResult(countQueryResult);
                }
                return new MethodMatchInfo(this.getOperationType(), (TypedElement)result.resultType(), interceptorType).dto(result.isDto()).queryResult(queryResult);
            }
        };
    }

    @Override
    public int getOrder() {
        return -3000;
    }
}

