/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Delete;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.DeleteCriteriaMethodMatch;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.processing.ProcessingException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

@Internal
public final class DeleteMethodMatcher
extends AbstractMethodMatcher {
    public static final Pattern METHOD_PATTERN = Pattern.compile("^((delete|remove|erase|eliminate)(\\S*?))$");

    public DeleteMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "delete", "remove", "erase", "eliminate").tryMatch(QueryMatchId.ALL_OR_ONE, ALL_OR_ONE).tryMatchLastOccurrencePrefixed(QueryMatchId.RETURNING, null, "Returning").tryMatchFirstOccurrencePrefixed(QueryMatchId.PREDICATE, "By").failOnRest("Delete method doesn't support projections").build());
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (matchContext.getMethodElement().hasStereotype(Delete.class)) {
            if (matchContext.getRootEntity() == null) {
                matchContext.findImplicitRootEntity();
            }
            if (matchContext.getRootEntity() == null) {
                throw new ProcessingException((Element)matchContext.getMethodElement(), "Repository does not have a well-defined primary entity type");
            }
            return this.match(matchContext, List.of());
        }
        return super.match(matchContext);
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        ParameterElement[] parameters = matchContext.getParameters();
        boolean isSpecificDelete = matches.stream().anyMatch(m -> m.id() == QueryMatchId.PREDICATE);
        boolean isReturning = matches.stream().anyMatch(m -> m.id() == QueryMatchId.RETURNING);
        ParameterElement entityParameter = null;
        ParameterElement entitiesParameter = null;
        if (matchContext.getParametersNotInRole().size() == 1) {
            entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
            entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
        }
        if (isSpecificDelete) {
            if (entityParameter != null && matchContext.getRootEntity().getPropertyByName(this.getName(entityParameter)) != null) {
                entityParameter = null;
            }
            if (entitiesParameter != null && matchContext.getRootEntity().getPropertyByName(this.getName(entitiesParameter)) != null) {
                entitiesParameter = null;
            }
        }
        if (entityParameter == null && entitiesParameter == null) {
            if (!isReturning && !TypeUtils.isValidBatchUpdateReturnType(matchContext.getMethodElement())) {
                return null;
            }
            return new DeleteCriteriaMethodMatch(matches, isReturning);
        }
        SourcePersistentEntity rootEntity = matchContext.getRootEntity();
        if (!rootEntity.hasIdentity() && !rootEntity.hasCompositeIdentity()) {
            throw new MatchFailedException("Delete all not supported for entities with no ID");
        }
        final boolean supportedByImplicitQueries = !isSpecificDelete;
        final ParameterElement finalEntityParameter = entityParameter;
        final ParameterElement finalEntitiesParameter = entitiesParameter;
        return new DeleteCriteriaMethodMatch(this, matches, isReturning){

            @Override
            protected boolean supportedByImplicitQueries() {
                return supportedByImplicitQueries;
            }

            @Override
            protected ParameterElement getEntityParameter() {
                return finalEntityParameter;
            }

            @Override
            protected ParameterElement getEntitiesParameter() {
                return finalEntitiesParameter;
            }
        };
    }

    private String getName(ParameterElement entityParameter) {
        return entityParameter.stringValue(Parameter.class).orElseGet(() -> ((ParameterElement)entityParameter).getName());
    }
}

