/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public abstract class AbstractPrefixPatternMethodMatcher
implements MethodMatcher {
    private static final Comparator<String> PREFIX_COMPARATOR = Comparator.comparingInt(String::length).thenComparing(String::compareTo).reversed();
    protected final Pattern pattern;

    protected AbstractPrefixPatternMethodMatcher(@NonNull List<String> prefixes) {
        if (prefixes.isEmpty()) {
            throw new IllegalArgumentException("At least one prefix required");
        }
        this.pattern = AbstractPrefixPatternMethodMatcher.computePattern(prefixes);
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (this.matches(matchContext)) {
            return this.doMatch(matchContext);
        }
        return null;
    }

    protected boolean matches(MethodMatchContext matchContext) {
        String methodName = matchContext.getMethodElement().getName();
        Matcher matcher = this.pattern.matcher(methodName);
        return matcher.find();
    }

    protected abstract MethodMatcher.MethodMatch doMatch(MethodMatchContext var1);

    private static Pattern computePattern(List<String> prefixes) {
        String prefixPattern = prefixes.stream().sorted(PREFIX_COMPARATOR).collect(Collectors.joining("|"));
        return Pattern.compile("^((" + prefixPattern + ")(\\S*?))$");
    }
}

