/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Delete;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.Insert;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.ParameterExpression;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.QueryResult;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.annotation.TypeRole;
import io.micronaut.data.annotation.Update;
import io.micronaut.data.annotation.sql.Procedure;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.intercept.annotation.DataMethodQuery;
import io.micronaut.data.intercept.annotation.DataMethodQueryParameter;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Slice;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.AdditionalParameterBinding;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterExpressionImpl;
import io.micronaut.data.processor.visitors.FindInterceptorDef;
import io.micronaut.data.processor.visitors.MappedEntityVisitor;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.Utils;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.RawQueryMethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.repository.jpa.criteria.CriteriaDeleteBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaQueryBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaUpdateBuilder;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.inject.annotation.EvaluatedExpressionReferenceCounter;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.UnresolvedTypeKind;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.ElementPostponedToNextRoundException;
import io.micronaut.inject.visitor.TypeElementQuery;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public class RepositoryTypeElementVisitor
implements TypeElementVisitor<Repository, Object> {
    public static final String SPRING_REPO = "org.springframework.data.repository.Repository";
    public static final String JAKARTA_DATA_REPO = "jakarta.data.repository.DataRepository";
    private static final boolean IS_DOCUMENT_ANNOTATION_PROCESSOR = ClassUtils.isPresent((String)"io.micronaut.data.document.processor.mapper.MappedEntityMapper", (ClassLoader)RepositoryTypeElementVisitor.class.getClassLoader());
    private static final Map<String, String> COMMON_TYPE_ROLES;
    private static final List<Map.Entry<String, String>> COMMON_ANNOTATION_ROLES;
    private ClassElement currentClass;
    private ClassElement currentRepository;
    private QueryBuilder queryEncoder;
    private final List<MethodMatcher> methodsMatchers;
    private final Set<String> visitedRepositories = new HashSet<String>();
    private final Set<String> postponedRepositories = new HashSet<String>();
    private Map<String, DataType> dataTypes = Collections.emptyMap();
    private final Map<String, SourcePersistentEntity> entityMap = new HashMap<String, SourcePersistentEntity>(50);
    private Function<ClassElement, SourcePersistentEntity> entityResolver;
    private Function<String, SourcePersistentEntity> entityBySimplyNameResolver;
    private Map<String, String> currentClassTypeRoles;
    private @Nullable ClassElement jakartaDataConstraint;

    public RepositoryTypeElementVisitor() {
        ArrayList<MethodMatcher> matcherList = new ArrayList<MethodMatcher>(20);
        SoftServiceLoader.load(MethodMatcher.class).collectAll(matcherList);
        OrderUtil.sort(matcherList);
        this.methodsMatchers = matcherList;
    }

    public void finish(VisitorContext visitorContext) {
        this.postponedRepositories.clear();
        this.visitedRepositories.clear();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public TypeElementQuery query() {
        return TypeElementQuery.onlyClass();
    }

    private Map<ClassElement, FindInterceptorDef> createFindInterceptors(ClassElement element, VisitorContext visitorContext) {
        List<FindInterceptorDef> defaultInterceptors = FindersUtils.getDefaultInterceptors(visitorContext);
        ArrayList<FindInterceptorDef> interceptors = new ArrayList<FindInterceptorDef>(defaultInterceptors);
        AnnotationValue repositoryConfiguration = element.getAnnotationMetadata().getAnnotation(RepositoryConfiguration.class);
        if (repositoryConfiguration != null) {
            for (AnnotationValue interceptor : repositoryConfiguration.getAnnotations("findInterceptors", io.micronaut.data.annotation.FindInterceptorDef.class)) {
                interceptors.add(new FindInterceptorDef((ClassElement)interceptor.stringValue("returnType").flatMap(arg_0 -> ((VisitorContext)visitorContext).getClassElement(arg_0)).orElseThrow(), interceptor.booleanValue("isContainer").orElse(true), (ClassElement)interceptor.stringValue("interceptor").flatMap(arg_0 -> ((VisitorContext)visitorContext).getClassElement(arg_0)).orElseThrow()));
            }
        }
        return interceptors.stream().collect(Collectors.toMap(FindInterceptorDef::returnType, e -> e));
    }

    public void visitClass(ClassElement element, final VisitorContext context) {
        try {
            this.jakartaDataConstraint = context.getClassElement("jakarta.data.constraint.Constraint").orElse(null);
            this.currentClassTypeRoles = new LinkedHashMap<String, String>(COMMON_TYPE_ROLES);
            String interfaceName = element.getName();
            if (this.visitedRepositories.contains(interfaceName)) {
                this.currentRepository = null;
                this.currentClass = null;
                return;
            }
            if (element.hasStereotype("io.micronaut.data.document.annotation.DocumentProcessorRequired") && !IS_DOCUMENT_ANNOTATION_PROCESSOR) {
                throw new ProcessingException((Element)element, "Repository is required to be processed by the data-document-processor. Make sure it's included as a dependency to the annotation processor classpath!");
            }
            this.currentClass = element;
            this.entityResolver = new Function<ClassElement, SourcePersistentEntity>(this){
                final MappedEntityVisitor mappedEntityVisitor = new MappedEntityVisitor();
                final MappedEntityVisitor embeddedMappedEntityVisitor = new MappedEntityVisitor(false);
                final /* synthetic */ RepositoryTypeElementVisitor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public SourcePersistentEntity apply(ClassElement classElement) {
                    String classNameKey = this.this$0.getClassNameKey(classElement);
                    return this.this$0.entityMap.computeIfAbsent(classNameKey, s -> {
                        if (classElement.hasAnnotation("io.micronaut.data.annotation.Embeddable")) {
                            this.embeddedMappedEntityVisitor.visitClass(classElement, context);
                        } else {
                            this.mappedEntityVisitor.visitClass(classElement, context);
                        }
                        return new SourcePersistentEntity(classElement, this);
                    });
                }
            };
            this.entityBySimplyNameResolver = new Function<String, SourcePersistentEntity>(){

                @Override
                public SourcePersistentEntity apply(String entitySimpleName) {
                    for (SourcePersistentEntity persistentEntity : RepositoryTypeElementVisitor.this.entityMap.values()) {
                        if (!persistentEntity.getPersistedName().equalsIgnoreCase(entitySimpleName)) continue;
                        return persistentEntity;
                    }
                    return null;
                }
            };
            if (element.hasDeclaredStereotype(Repository.class)) {
                if (element.hasUnresolvedTypes(new UnresolvedTypeKind[]{UnresolvedTypeKind.INTERFACE, UnresolvedTypeKind.SUPERCLASS}) && !this.postponedRepositories.contains(interfaceName)) {
                    this.postponedRepositories.add(interfaceName);
                    throw new ElementPostponedToNextRoundException((Element)element);
                }
                this.visitedRepositories.add(interfaceName);
                this.currentRepository = element;
                this.queryEncoder = RepositoryTypeElementVisitor.newQueryBuilder(element.getAnnotationMetadata());
                this.dataTypes = Utils.getConfiguredDataTypes(this.currentRepository);
                AnnotationMetadata annotationMetadata = element.getAnnotationMetadata();
                List roleArray = annotationMetadata.findAnnotation(RepositoryConfiguration.class).map(av -> av.getAnnotations("typeRoles", TypeRole.class)).orElse(Collections.emptyList());
                for (AnnotationValue parameterRole : roleArray) {
                    String role = parameterRole.stringValue("role").orElse(null);
                    AnnotationClassValue cv = parameterRole.get((CharSequence)"type", AnnotationClassValue.class).orElse(null);
                    if (!StringUtils.isNotEmpty((CharSequence)role) || cv == null) continue;
                    context.getClassElement(cv.getName()).ifPresent(ce -> this.currentClassTypeRoles.put(ce.getName(), role));
                }
                this.annotateEntityRepresentationIfPresent(element);
                if (this.queryEncoder == null) {
                    throw new ProcessingException((Element)element, "QueryEncoder not present on annotation processor path");
                }
            }
            element.getMethods().forEach(method -> this.visitMethod((MethodElement)method, context));
        }
        catch (Exception e) {
            this.visitedRepositories.remove(element.getName());
            throw e;
        }
    }

    private static @NonNull QueryBuilder newQueryBuilder(@NonNull AnnotationMetadata annotationMetadata) {
        return (QueryBuilder)annotationMetadata.stringValue(RepositoryConfiguration.class, "queryBuilder").flatMap(type -> BeanIntrospector.SHARED.findIntrospections(ref -> ref.isPresent() && ref.getBeanType().getName().equals(type)).stream().findFirst().map(introspection -> {
            try {
                Argument[] constructorArguments = introspection.getConstructorArguments();
                if (constructorArguments.length == 0) {
                    return (QueryBuilder)introspection.instantiate();
                }
                if (constructorArguments.length == 1 && constructorArguments[0].getType() == AnnotationMetadata.class) {
                    return (QueryBuilder)introspection.instantiate(new Object[]{annotationMetadata});
                }
            }
            catch (InstantiationException e) {
                return new JpaQueryBuilder();
            }
            return new JpaQueryBuilder();
        })).orElse(new JpaQueryBuilder());
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.currentRepository == null) {
            return;
        }
        ClassElement genericReturnType = element.getGenericReturnType();
        if (this.queryEncoder != null && this.currentClass != null && element.isAbstract() && !element.isStatic()) {
            ParameterElement[] parameters = element.getParameters();
            Map<Element, String> parametersInRole = this.getParametersInRole(parameters);
            if (element.hasDeclaredAnnotation(DataMethod.class)) {
                return;
            }
            Map<ClassElement, FindInterceptorDef> findInterceptors = this.createFindInterceptors(this.currentClass, context);
            MatchContext matchContext = new MatchContext(this.queryEncoder, this.currentRepository, context, element, this.currentClassTypeRoles, COMMON_ANNOTATION_ROLES, genericReturnType, parameters, findInterceptors);
            try {
                List<ParameterElement> parametersNotInRole = Arrays.stream(parameters).filter(p -> !parametersInRole.containsKey(p)).toList();
                SourcePersistentEntity entity = this.resolvePersistentEntity(element, parametersInRole, parametersNotInRole);
                MethodMatchContext methodMatchContext = new MethodMatchContext(this.queryEncoder, this.currentRepository, entity, context, genericReturnType, element, parametersInRole, this.currentClassTypeRoles, COMMON_ANNOTATION_ROLES, parameters, this.entityResolver, findInterceptors, this.entityBySimplyNameResolver);
                for (MethodMatcher finder : this.methodsMatchers) {
                    MethodMatchInfo methodInfo;
                    MethodMatcher.MethodMatch matcher = finder.match(methodMatchContext);
                    if (matcher == null || (methodInfo = matcher.buildMatchInfo(methodMatchContext)) == null) continue;
                    this.processMethodInfo(methodMatchContext, methodInfo);
                    return;
                }
                if (matchContext.isPossiblyFailing()) {
                    matchContext.logPossibleFailures();
                    throw new ProcessingException((Element)element, "Failures found.");
                }
                String messageStart = matchContext.getUnableToImplementMessage();
                throw new ProcessingException((Element)element, messageStart + "No possible implementations found.");
            }
            catch (MatchFailedException e) {
                throw new ProcessingException((Element)(e.getElement() == null ? element : e.getElement()), matchContext.getUnableToImplementMessage() + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e instanceof ElementPostponedToNextRoundException || e.getClass().getSimpleName().equals("PostponeToNextRoundException")) {
                    throw e;
                }
                throw new ProcessingException((Element)element, "Exception occurred while processing: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map<Element, String> getParametersInRole(ParameterElement[] parameters) {
        LinkedHashMap<Element, String> parametersInRole = new LinkedHashMap<Element, String>(2);
        for (ParameterElement parameter : parameters) {
            parametersInRole.computeIfAbsent((Element)parameter, p -> {
                String typeRole = this.findTypeRole(parameter.getType());
                if (typeRole == null) {
                    typeRole = this.findAnnotationRole((Element)parameter);
                }
                if (typeRole == null && this.jakartaDataConstraint != null && parameter.getType().isAssignable(this.jakartaDataConstraint)) {
                    return "specificationConstraint";
                }
                return typeRole;
            });
        }
        return parametersInRole;
    }

    private String findTypeRole(ClassElement type) {
        Set<Map.Entry<String, String>> entries = this.currentClassTypeRoles.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!type.getName().equals(entry.getKey())) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, String> entry : entries) {
            if (!type.isAssignable(entry.getKey())) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, String> e : COMMON_ANNOTATION_ROLES) {
            if (!type.hasStereotype(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    private String findAnnotationRole(Element element) {
        for (Map.Entry<String, String> e : COMMON_ANNOTATION_ROLES) {
            if (!element.hasStereotype(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    private List<ParameterElement> getParametersNotInRole(ParameterElement[] parameters) {
        ArrayList<ParameterElement> parametersNotInRole = new ArrayList<ParameterElement>();
        for (ParameterElement parameter : parameters) {
            ClassElement type = parameter.getType();
            if (!this.currentClassTypeRoles.keySet().stream().noneMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0))) continue;
            parametersNotInRole.add(parameter);
        }
        return parametersNotInRole;
    }

    private void processMethodInfo(MethodMatchContext methodMatchContext, MethodMatchInfo methodInfo) {
        List parameterBinding;
        QueryBuilder queryEncoder = methodMatchContext.getQueryBuilder();
        MethodElement method = methodMatchContext.getMethodElement();
        for (Map.Entry<Element, String> entry : methodMatchContext.getParametersInRole().entrySet()) {
            methodInfo.addParameterRole((ParameterElement)entry.getKey(), entry.getValue());
        }
        QueryResult queryResult = methodInfo.getQueryResult();
        if (queryResult == null) {
            parameterBinding = null;
        } else {
            parameterBinding = queryResult.getParameterBindings();
            if (methodInfo.isRawQuery()) {
                method.annotate(Query.class, builder -> builder.member("rawQuery", (String)method.stringValue(Query.class).map(q -> this.addRawQueryParameterPlaceholders(queryEncoder, queryResult.getQuery(), queryResult.getQueryParts())).orElse(null)));
                ClassElement genericReturnType = methodMatchContext.getReturnType();
                if (methodMatchContext.isTypeInRole(genericReturnType, "page") || methodMatchContext.isTypeInRole(genericReturnType, "cursoredPage") || method.isPresent(Query.class, "countQuery")) {
                    QueryResult countQueryResult = methodInfo.getCountQueryResult();
                    if (countQueryResult == null) {
                        throw new ProcessingException((Element)method, "Query returns a Page and does not specify a 'countQuery' member.");
                    }
                    method.annotate(Query.class, builder -> builder.member("rawCountQuery", this.addRawQueryParameterPlaceholders(queryEncoder, countQueryResult.getQuery(), countQueryResult.getQueryParts())));
                }
            } else {
                this.bindAdditionalParameters(methodMatchContext, parameterBinding, queryResult.getAdditionalRequiredParameters());
                QueryResult preparedCount = methodInfo.getCountQueryResult();
                if (preparedCount != null) {
                    method.annotate(Query.class, annotationBuilder -> {
                        annotationBuilder.value(queryResult.getQuery());
                        annotationBuilder.member("countQuery", preparedCount.getQuery());
                    });
                } else {
                    method.annotate(Query.class, annotationBuilder -> {
                        annotationBuilder.value(queryResult.getQuery());
                        String update = queryResult.getUpdate();
                        if (StringUtils.isNotEmpty((CharSequence)update)) {
                            annotationBuilder.member("update", update);
                        }
                    });
                }
                Collection joinPaths = queryResult.getJoinPaths();
                if (CollectionUtils.isNotEmpty((Collection)joinPaths)) {
                    method.removeAnnotation(Join.class);
                    joinPaths.forEach(joinPath -> method.annotate(Join.class, builder -> {
                        builder.member("value", joinPath.getPath()).member("type", (Enum)joinPath.getJoinType());
                        if (joinPath.getAlias().isPresent()) {
                            builder.member("alias", (String)joinPath.getAlias().get());
                        }
                    }));
                }
            }
        }
        this.annotateQueryResultIfApplicable(method, methodInfo, methodMatchContext.getRootEntity());
        method.annotate(DataMethod.class.getName(), annotationBuilder -> {
            String returnTypeRole;
            ClassElement runtimeInterceptor = methodInfo.getRuntimeInterceptor();
            if (runtimeInterceptor == null) {
                throw new MatchFailedException("Unable to implement Repository method: " + this.currentRepository.getSimpleName() + "." + method.getName() + "(..). No possible runtime implementations found.", (Element)method);
            }
            annotationBuilder.member("interceptor", new AnnotationClassValue[]{new AnnotationClassValue(runtimeInterceptor.getName())});
            if (methodMatchContext.getRootEntity() != null) {
                annotationBuilder.member("rootEntity", new AnnotationClassValue[]{new AnnotationClassValue(methodMatchContext.getRootEntity().getName())});
            }
            if (methodInfo.isDto()) {
                annotationBuilder.member("dto", true);
            }
            if (methodInfo.isOptimisticLock()) {
                annotationBuilder.member("optimisticLock", true);
            }
            if (!methodInfo.getParameterRoles().isEmpty()) {
                for (Map.Entry<ParameterElement, String> e2 : methodInfo.getParameterRoles().entrySet()) {
                    ParameterElement parameter = e2.getKey();
                    annotationBuilder.member(e2.getValue(), parameter.stringValue(Parameter.class).orElse(parameter.getName()));
                }
                List<ParameterElement> parameters = List.of(method.getParameters());
                annotationBuilder.member("parametersTypeRoles", (AnnotationValue[])methodInfo.getParameterRoles().entrySet().stream().sorted(Comparator.comparingInt(o -> parameters.indexOf(o.getKey()))).map(e -> AnnotationValue.builder((String)"type").value((String)e.getValue()).member("parameterIndex", parameters.indexOf(e.getKey())).build()).toArray(AnnotationValue[]::new));
            }
            if ((returnTypeRole = this.findTypeRole(method.getReturnType().getType())) == null) {
                returnTypeRole = this.findAnnotationRole((Element)method.getReturnType());
            }
            if (returnTypeRole != null) {
                annotationBuilder.member("returnTypeRole", returnTypeRole);
            }
            this.addQueryDefinition(methodMatchContext, (AnnotationValueBuilder<Annotation>)annotationBuilder, methodInfo.getOperationType(), queryResult, methodInfo.getResultType(), parameterBinding, methodInfo.isEncodeEntityParameters());
            QueryResult countQuery = methodInfo.getCountQueryResult();
            if (countQuery != null) {
                List countParametersBindings = countQuery.getParameterBindings();
                this.bindAdditionalParameters(methodMatchContext, countParametersBindings, countQuery.getAdditionalRequiredParameters());
                AnnotationValueBuilder builder = AnnotationValue.builder((String)DataMethodQuery.class.getName());
                String query = countQuery.getQuery();
                if (methodInfo.isRawQuery()) {
                    query = this.addRawQueryParameterPlaceholders(queryEncoder, query, countQuery.getQueryParts());
                }
                builder.member("value", query);
                builder.member("nativeQuery", method.booleanValue(Query.class, "nativeQuery").orElse(false).booleanValue());
                this.addQueryDefinition(methodMatchContext, (AnnotationValueBuilder<Annotation>)builder, DataMethod.OperationType.COUNT, countQuery, (TypedElement)methodMatchContext.getVisitorContext().getClassElement(Long.class).orElseThrow(), countParametersBindings, methodInfo.isEncodeEntityParameters());
                annotationBuilder.member("countQuery", builder.build());
            }
        });
    }

    private void addQueryDefinition(MethodMatchContext methodMatchContext, AnnotationValueBuilder<Annotation> annotationBuilder, DataMethod.OperationType operationType, QueryResult queryResult, TypedElement resultType, List<QueryParameterBinding> parameterBinding, boolean encodeEntityParameters) {
        if (methodMatchContext.getMethodElement().hasAnnotation(Procedure.class)) {
            annotationBuilder.member("procedure", true);
        }
        annotationBuilder.member("opType", (Enum)operationType);
        if (resultType != null) {
            annotationBuilder.member("resultType", new AnnotationClassValue[]{new AnnotationClassValue(resultType.getName())});
            ClassElement type = resultType.getType();
            if (!TypeUtils.isVoid(type)) {
                annotationBuilder.member("resultDataType", (Enum)TypeUtils.resolveDataType(type, this.dataTypes));
            }
        }
        if (queryResult != null) {
            Sort sort;
            long offset;
            int max;
            if (parameterBinding.stream().anyMatch(QueryParameterBinding::isExpandable)) {
                annotationBuilder.member("expandableQuery", queryResult.getQueryParts().toArray(new String[0]));
            }
            if ((max = queryResult.getMax()) > -1) {
                annotationBuilder.member("limit", max);
            }
            if ((offset = queryResult.getOffset()) > 0L) {
                annotationBuilder.member("offset", offset);
            }
            if ((sort = queryResult.getSort()).isSorted()) {
                annotationBuilder.member("sorts", (AnnotationValue[])sort.getOrderBy().stream().map(order -> AnnotationValue.builder((String)"order").value(order.getProperty()).member("direction", (Enum)order.getDirection()).member("ignoreCase", order.isIgnoreCase()).build()).toArray(AnnotationValue[]::new));
            }
        }
        if (CollectionUtils.isNotEmpty(parameterBinding)) {
            this.bindParameters(methodMatchContext.supportsImplicitQueries(), parameterBinding, encodeEntityParameters, annotationBuilder);
        }
    }

    private void bindParameters(boolean supportsImplicitQueries, List<QueryParameterBinding> parameterBinding, boolean finalEncodeEntityParameters, AnnotationValueBuilder<Annotation> annotationBuilder) {
        ArrayList<AnnotationValue> annotationValues = new ArrayList<AnnotationValue>(parameterBinding.size());
        for (QueryParameterBinding p : parameterBinding) {
            AnnotationValueBuilder builder = AnnotationValue.builder(DataMethodQueryParameter.class);
            if (p.getParameterIndex() != -1) {
                builder.member("parameterIndex", p.getParameterIndex());
            }
            if (p.getParameterBindingPath() != null) {
                builder.member("parameterBindingPath", p.getParameterBindingPath());
            }
            if (p.getPropertyPath() != null) {
                if (p.getPropertyPath().length == 1) {
                    builder.member("property", p.getPropertyPath()[0]);
                } else {
                    builder.member("propertyPath", p.getPropertyPath());
                }
            }
            if (!supportsImplicitQueries && !finalEncodeEntityParameters) {
                builder.member("dataType", (Enum)p.getDataType());
            }
            builder.member("jsonDataType", (Enum)p.getJsonDataType());
            if (p.getConverterClassName() != null) {
                builder.member("converter", new AnnotationClassValue[]{new AnnotationClassValue(p.getConverterClassName())});
            }
            if (p.isAutoPopulated()) {
                builder.member("autoPopulated", true);
            }
            if (p.isRequiresPreviousPopulatedValue()) {
                builder.member("requiresPreviousPopulatedValue", true);
            }
            if (p.isExpandable()) {
                builder.member("expandable", true);
            }
            if (p.isExpression()) {
                Object value;
                builder.member("expression", true);
                if (!supportsImplicitQueries) {
                    builder.member("name", p.getName());
                }
                if ((value = p.getValue()) != null) {
                    if (value instanceof String) {
                        String expression = (String)value;
                        String originatingClassName = DataMethodQueryParameter.class.getName();
                        String packageName = NameUtils.getPackageName((String)originatingClassName);
                        String simpleClassName = NameUtils.getSimpleName((String)originatingClassName);
                        String exprClassName = "%s.$%s%s".formatted(packageName, simpleClassName, "$Expr");
                        Integer expressionIndex = EvaluatedExpressionReferenceCounter.nextIndex((String)exprClassName);
                        builder.members(Map.of("value", new EvaluatedExpressionReference((Object)expression, originatingClassName, "value", exprClassName + expressionIndex)));
                    } else {
                        throw new IllegalStateException("The expression value should be a String!");
                    }
                }
            }
            if (supportsImplicitQueries) {
                builder.member("name", p.getKey());
            }
            if (p.getRole() != null) {
                builder.member("role", p.getRole());
            }
            if (p.getTableAlias() != null) {
                builder.member("tableAlias", p.getTableAlias());
            }
            annotationValues.add(builder.build());
        }
        AnnotationValue[] annotations = annotationValues.toArray(new AnnotationValue[0]);
        annotationBuilder.member("parameters", annotations);
    }

    private void bindAdditionalParameters(MethodMatchContext methodMatchContext, List<QueryParameterBinding> parameterBinding, Map<String, String> params) {
        SourcePersistentEntity entity = methodMatchContext.getRootEntity();
        ParameterElement[] parameters = methodMatchContext.getParameters();
        Map<String, DataType> configuredDataTypes = Utils.getConfiguredDataTypes(methodMatchContext.getRepositoryClass());
        ListIterator<QueryParameterBinding> iterator = parameterBinding.listIterator();
        while (iterator.hasNext()) {
            QueryParameterBinding queryParameterBinding = iterator.next();
            if (!(queryParameterBinding instanceof AdditionalParameterBinding)) continue;
            AdditionalParameterBinding additionalParameterBinding = (AdditionalParameterBinding)queryParameterBinding;
            iterator.set(this.createAdditionalBinding(additionalParameterBinding.bindingContext(), methodMatchContext, entity, parameters, additionalParameterBinding.getName(), configuredDataTypes));
        }
        if (CollectionUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                String key = param.getKey();
                String name = param.getValue();
                parameterBinding.add(this.createAdditionalBinding(BindingParameter.BindingContext.create().name(key), methodMatchContext, entity, parameters, name, configuredDataTypes));
            }
        }
    }

    private QueryParameterBinding createAdditionalBinding(BindingParameter.BindingContext bindingContext, MatchContext matchContext, SourcePersistentEntity entity, ParameterElement[] parameters, String name, Map<String, DataType> configuredDataTypes) {
        List parameterExpressions = matchContext.getMethodElement().getAnnotationMetadata().getAnnotationValuesByType(ParameterExpression.class);
        Optional<AnnotationValue> parameterExpression = parameterExpressions.stream().filter(av -> av.stringValue("name").orElse("").equals(name)).findFirst();
        if (parameterExpression.isPresent()) {
            ClassElement type = RawQueryMethodMatcher.extractExpressionType(matchContext, (AnnotationValue<ParameterExpression>)parameterExpression.orElseThrow());
            return new SourceParameterExpressionImpl(configuredDataTypes, name, type, null).bind(bindingContext);
        }
        ParameterElement parameter = Arrays.stream(parameters).filter(p -> p.stringValue(Parameter.class).orElse(p.getName()).equals(name)).findFirst().orElse(null);
        if (parameter == null) {
            throw new MatchFailedException("A @Where(..) definition requires a parameter called [" + name + "] which is not present in the method signature.");
        }
        PersistentPropertyPath propertyPath = entity.getPropertyPath(name);
        bindingContext = bindingContext.incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
        return new SourceParameterExpressionImpl(configuredDataTypes, matchContext.parameters, parameter, false, null).bind(bindingContext);
    }

    private String addRawQueryParameterPlaceholders(QueryBuilder queryEncoder, String query, List<String> queryParts) {
        if (queryEncoder instanceof SqlQueryBuilder) {
            SqlQueryBuilder sqlQueryBuilder = (SqlQueryBuilder)queryEncoder;
            Iterator<String> iterator = queryParts.iterator();
            String first = iterator.next();
            if (queryParts.size() < 2) {
                return first;
            }
            StringBuilder sb = new StringBuilder(first);
            int i = 1;
            while (iterator.hasNext()) {
                sb.append(sqlQueryBuilder.formatParameter(i++).name());
                sb.append(iterator.next());
            }
            return sb.toString();
        }
        return query;
    }

    private @Nullable SourcePersistentEntity resolvePersistentEntity(MethodElement element, Map<Element, String> parametersInRole, List<ParameterElement> parametersNotInRole) {
        ClassElement returnType = element.getGenericReturnType();
        SourcePersistentEntity entity = this.resolveEntityForCurrentClass();
        if (entity == null) {
            entity = Utils.resolvePersistentEntity(returnType, this.entityResolver);
        }
        if (entity != null) {
            List propertiesInRole = entity.getPersistentProperties().stream().filter(pp -> pp.getAnnotationMetadata().hasStereotype(TypeRole.class)).collect(Collectors.toList());
            for (PersistentProperty persistentProperty : propertiesInRole) {
                String role = persistentProperty.getAnnotationMetadata().getValue(TypeRole.class, "role", String.class).orElse(null);
                if (role == null) continue;
                parametersInRole.put((Element)((SourcePersistentProperty)persistentProperty).getPropertyElement(), role);
            }
            return entity;
        }
        SourcePersistentEntity sourcePersistentEntity = this.resolvePersistentEntityFromLifecycleMethods(element, parametersNotInRole);
        if (sourcePersistentEntity != null) {
            return sourcePersistentEntity;
        }
        if (element.hasStereotype(Query.class)) {
            return null;
        }
        ClassElement owningType = element.getOwningType();
        Iterator iterator = owningType.getMethods().iterator();
        if (iterator.hasNext()) {
            MethodElement method = (MethodElement)iterator.next();
            return this.resolvePersistentEntityFromLifecycleMethods(method, this.getParametersNotInRole(method.getParameters()));
        }
        throw new MatchFailedException("Could not resolved root entity. Either implement the Repository interface or define the entity as part of the signature", (Element)element);
    }

    private @Nullable SourcePersistentEntity resolvePersistentEntityFromLifecycleMethods(MethodElement element, List<ParameterElement> parametersNotInRole) {
        if ((element.hasStereotype(Insert.class) || element.hasStereotype(Update.class) || element.hasStereotype(Delete.class)) && !parametersNotInRole.isEmpty()) {
            ClassElement type = parametersNotInRole.iterator().next().getGenericType();
            if (type.isArray()) {
                type = type.fromArray();
            } else if (type.isAssignable(Iterable.class)) {
                type = (ClassElement)type.getTypeArguments(Iterable.class).entrySet().iterator().next().getValue();
            }
            if (type.hasStereotype(MappedEntity.class)) {
                return this.entityResolver.apply(type);
            }
        }
        return null;
    }

    private @Nullable SourcePersistentEntity resolveEntityForCurrentClass() {
        ClassElement ce;
        Map typeArguments = this.currentRepository.getTypeArguments(GenericRepository.class);
        String argName = "E";
        if (typeArguments.isEmpty()) {
            argName = "T";
            typeArguments = this.currentRepository.getTypeArguments(SPRING_REPO);
        }
        if (typeArguments.isEmpty()) {
            argName = "T";
            typeArguments = this.currentRepository.getTypeArguments(JAKARTA_DATA_REPO);
        }
        if (!typeArguments.isEmpty() && (ce = (ClassElement)typeArguments.get(argName)) != null) {
            return this.entityResolver.apply(ce);
        }
        return null;
    }

    private void annotateEntityRepresentationIfPresent(ClassElement classElement) {
        AnnotationValue entityRepresentationAnnotationValue;
        SourcePersistentEntity entity = this.resolveEntityForCurrentClass();
        if (entity != null && (entityRepresentationAnnotationValue = entity.getAnnotation(EntityRepresentation.class)) != null) {
            classElement.annotate(entityRepresentationAnnotationValue);
        }
    }

    private void annotateQueryResultIfApplicable(MethodElement element, MethodMatchInfo methodInfo, SourcePersistentEntity entity) {
        AnnotationValue entityRepresentationAnnotationValue;
        if (methodInfo.getOperationType() == DataMethod.OperationType.QUERY && methodInfo.getResultType().equals((Object)entity.getType()) && (entityRepresentationAnnotationValue = entity.getAnnotation(EntityRepresentation.class)) != null) {
            EntityRepresentation.Type type = (EntityRepresentation.Type)entityRepresentationAnnotationValue.getRequiredValue("type", EntityRepresentation.Type.class);
            String column = (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
            JsonDataType jsonDataType = JsonDataType.DEFAULT;
            QueryResult.Type queryResultType = type == EntityRepresentation.Type.TABULAR ? QueryResult.Type.TABULAR : QueryResult.Type.JSON;
            element.annotate(io.micronaut.data.annotation.QueryResult.class, builder -> builder.member("type", (Enum)queryResultType).member("jsonDataType", (Enum)jsonDataType).member("column", column));
        }
    }

    private String getClassNameKey(ClassElement classElement) {
        List boundGenericTypes = classElement.getBoundGenericTypes();
        if (CollectionUtils.isNotEmpty((Collection)boundGenericTypes)) {
            StringBuilder keyBuff = new StringBuilder(classElement.getName());
            keyBuff.append("<");
            for (ClassElement boundGenericType : boundGenericTypes) {
                keyBuff.append(boundGenericType.getName());
                keyBuff.append(",");
            }
            keyBuff.deleteCharAt(keyBuff.length() - 1);
            keyBuff.append(">");
            return keyBuff.toString();
        }
        return classElement.getName();
    }

    static {
        LinkedHashMap<String, String> roles = new LinkedHashMap<String, String>();
        roles.put(Pageable.class.getName(), "pageable");
        roles.put(Sort.class.getName(), "sort");
        roles.put(CursoredPage.class.getName(), "cursoredPage");
        roles.put(Page.class.getName(), "page");
        roles.put(Slice.class.getName(), "slice");
        roles.put(Limit.class.getName(), "querylimit");
        roles.put(PredicateSpecification.class.getName(), "specificationPredicate");
        roles.put(DeleteSpecification.class.getName(), "specificationUpdate");
        roles.put(CriteriaDeleteBuilder.class.getName(), "specificationUpdate");
        roles.put(UpdateSpecification.class.getName(), "specificationUpdate");
        roles.put(CriteriaUpdateBuilder.class.getName(), "specificationUpdate");
        roles.put(QuerySpecification.class.getName(), "specificationQuery");
        roles.put(CriteriaQueryBuilder.class.getName(), "specificationQuery");
        roles.put("org.springframework.data.domain.Pageable", "pageable");
        roles.put("org.springframework.data.domain.Page", "page");
        roles.put("org.springframework.data.domain.Slice", "slice");
        roles.put("org.springframework.data.domain.Sort", "sort");
        roles.put("org.springframework.data.jpa.domain.Specification", "specificationPredicate");
        roles.put("org.springframework.data.jpa.domain.UpdateSpecification", "specificationUpdate");
        roles.put("org.springframework.data.jpa.domain.DeleteSpecification", "specificationUpdate");
        roles.put("jakarta.data.page.Page", "page");
        roles.put("jakarta.data.page.CursoredPage", "cursoredPage");
        roles.put("jakarta.data.page.PageRequest", "pageable");
        roles.put("jakarta.data.Order", "sort");
        roles.put("jakarta.data.Sort", "sort");
        roles.put("jakarta.data.Limit", "querylimit");
        roles.put("jakarta.data.restrict.Restriction", "specificationPredicate");
        COMMON_TYPE_ROLES = Collections.unmodifiableMap(roles);
        COMMON_ANNOTATION_ROLES = List.of(Map.entry("jakarta.data.repository.Is", "specificationConstraint"));
    }
}

