/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.FindInterceptorDef;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public class MethodMatchContext
extends MatchContext {
    private SourcePersistentEntity entity;
    private final Map<Element, String> parametersInRole;
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;
    private final Function<String, SourcePersistentEntity> entityBySimplyNameResolver;

    MethodMatchContext(@NonNull QueryBuilder queryBuilder, @NonNull ClassElement repositoryClass, @NonNull SourcePersistentEntity entity, @NonNull VisitorContext visitorContext, @NonNull ClassElement returnType, @NonNull MethodElement methodElement, @NonNull Map<Element, String> parametersInRole, @NonNull Map<String, String> typeRoles, @NonNull List<Map.Entry<String, String>> annotationRoles, @NonNull ParameterElement[] parameters, @NonNull Function<ClassElement, SourcePersistentEntity> entityResolver, @NonNull Map<ClassElement, FindInterceptorDef> findInterceptors, @NonNull Function<String, SourcePersistentEntity> entityBySimplyNameResolver) {
        super(queryBuilder, repositoryClass, visitorContext, methodElement, typeRoles, annotationRoles, returnType, parameters, findInterceptors);
        this.entity = entity;
        this.parametersInRole = Collections.unmodifiableMap(parametersInRole);
        this.entityResolver = entityResolver;
        this.entityBySimplyNameResolver = entityBySimplyNameResolver;
    }

    public Function<String, SourcePersistentEntity> getEntityBySimplyNameResolver() {
        return this.entityBySimplyNameResolver;
    }

    public boolean hasParameterInRole(@NonNull String role) {
        return role != null && this.parametersInRole.containsValue(role);
    }

    public @Nullable Element findParameterInRole(@NonNull String role) {
        for (Map.Entry<Element, String> e : this.parametersInRole.entrySet()) {
            if (!e.getValue().equals(role)) continue;
            return e.getKey();
        }
        return null;
    }

    public @NonNull Map<Element, String> getParametersInRole() {
        return this.parametersInRole;
    }

    public SourcePersistentEntity getRootEntity() {
        return this.entity;
    }

    public void setRootEntity(SourcePersistentEntity entity) {
        this.entity = entity;
    }

    public @NonNull List<ParameterElement> getParametersNotInRole() {
        return Arrays.stream(this.getParameters()).filter(p -> !this.parametersInRole.containsKey(p)).toList();
    }

    public @NonNull List<ParameterElement> getParametersInRoleList() {
        return Arrays.stream(this.getParameters()).filter(this.parametersInRole::containsKey).toList();
    }

    public @NonNull SourcePersistentEntity getEntity(@NonNull ClassElement element) {
        return this.entityResolver.apply(element);
    }

    public void findImplicitRootEntity() {
        if (this.parameters.length == 1) {
            ClassElement rootType = this.parameters[0].getGenericType();
            if (rootType.isArray()) {
                rootType = rootType.fromArray();
            } else if (TypeUtils.isIterableOfEntity(rootType)) {
                rootType = (ClassElement)rootType.getFirstTypeArgument().orElseThrow(() -> new ProcessingException((Element)this.methodElement, "Cannot determine implicit root entity type"));
            }
            if (TypeUtils.isEntity(rootType)) {
                this.setRootEntity(this.getEntity(rootType));
            }
        }
    }
}

