/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.impl.QueryModelPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.stream.Collectors;

public class DeleteCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    private final boolean isReturning;

    public DeleteCriteriaMethodMatch(List<MethodNameParser.Match> matches, boolean isReturning) {
        super(matches);
        this.isReturning = isReturning;
    }

    protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaDelete<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        boolean predicatedApplied = false;
        for (MethodNameParser.Match match : this.matches) {
            if (match.id() == QueryMatchId.PREDICATE) {
                this.applyPredicates(match.part(), matchContext.getParameters(), root, query, cb);
                predicatedApplied = true;
            }
            if (match.id() != QueryMatchId.RETURNING) continue;
            this.applyProjections(match.part(), root, query, cb);
        }
        if (!predicatedApplied) {
            this.applyPredicates(matchContext.getParametersNotInRole(), root, query, cb);
        }
        this.applyJoinSpecs(root, this.joinSpecsAtMatchContext(matchContext, true));
    }

    protected <T> void applyProjections(String projection, PersistentEntityRoot<T> root, PersistentEntityCriteriaDelete<T> query, PersistentEntityCriteriaBuilder cb) {
        if (!this.isReturning) {
            return;
        }
        List<Selection<?>> selections = this.findSelections(projection, root, cb, null);
        if (selections.isEmpty()) {
            query.returning(root);
        } else if (selections.size() == 1) {
            query.returning(selections.get(0));
        } else {
            throw new MatchFailedException("Multi-selection is not supported");
        }
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        List<SourcePersistentProperty> dtoProjectionProperties;
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        PersistentEntityCriteriaDelete criteriaQuery = cb.createCriteriaDelete((Class)null);
        PersistentEntityRoot root = criteriaQuery.from((PersistentEntity)matchContext.getRootEntity());
        this.apply(matchContext, root, criteriaQuery, cb);
        FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = interceptorMatch.returnType();
        ClassElement interceptorType = interceptorMatch.interceptor();
        boolean optimisticLock = ((AbstractPersistentEntityCriteriaDelete)criteriaQuery).hasVersionRestriction();
        AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
        AbstractCriteriaMethodMatch.MethodResult result = this.analyzeMethodResult(matchContext, resultType, interceptorMatch, true);
        if (result.isDto() && !result.isRuntimeDtoConversion() && !(dtoProjectionProperties = this.getDtoProjectionProperties(matchContext.getRootEntity(), resultType)).isEmpty()) {
            List selectionList = dtoProjectionProperties.stream().map(p -> {
                if (matchContext.getQueryBuilder().shouldAliasProjections()) {
                    return root.get(p.getName()).alias(p.getName());
                }
                return root.get(p.getName());
            }).collect(Collectors.toList());
            criteriaQuery.returningMulti(selectionList);
        }
        QueryBuilder queryBuilder = matchContext.getQueryBuilder();
        QueryModel queryModel = ((QueryModelPersistentEntityCriteriaQuery)criteriaQuery).getQueryModel();
        QueryResult queryResult = queryBuilder.buildDelete((AnnotationMetadata)annotationMetadataHierarchy, queryModel);
        return new MethodMatchInfo(this.getOperationType(), (TypedElement)resultType, interceptorType).optimisticLock(optimisticLock).queryResult(queryResult);
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        if (this.isReturning) {
            return DataMethod.OperationType.DELETE_RETURNING;
        }
        return DataMethod.OperationType.DELETE;
    }
}

