/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.processor.visitors.MatchFailedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
public final class MethodNameParser {
    private final List<MatchStep> matchSteps;

    private MethodNameParser(List<MatchStep> matchSteps) {
        this.matchSteps = matchSteps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Match> tryMatch(String input) {
        final ArrayList<Match> matches = new ArrayList<Match>();
        final Iterator<MatchStep> iterator = this.matchSteps.iterator();
        MatchChain matchChain = new MatchChain(){

            @Override
            public void matched(MatchId matchId, String matchedText, String next) {
                matches.add(new Match(matchId, matchedText));
                this.next(next);
            }

            @Override
            public void notMatched(MatchId matchId, String input) {
                this.next(input);
            }

            private void next(String input) {
                if (iterator.hasNext() && !input.isEmpty()) {
                    ((MatchStep)iterator.next()).match(input, this);
                }
            }
        };
        if (iterator.hasNext()) {
            iterator.next().match(input, matchChain);
        }
        return matches;
    }

    public static final class Builder {
        private final List<MatchStep> matchSteps = new ArrayList<MatchStep>();

        private Builder() {
        }

        public Builder match(MatchId matchId, String ... prefixes) {
            String prefixPattern = String.join((CharSequence)"|", prefixes);
            Pattern pattern = Pattern.compile("^(" + prefixPattern + ")(.*)$");
            this.matchSteps.add((input, chain) -> {
                Matcher matcher = pattern.matcher(input);
                if (matcher.matches()) {
                    chain.matched(matchId, matcher.group(1), matcher.group(2));
                }
            });
            return this;
        }

        public Builder tryMatch(MatchId matchId, String ... prefixes) {
            String prefixPattern = String.join((CharSequence)"|", prefixes);
            Pattern pattern = Pattern.compile("^(" + prefixPattern + ")(.*)$");
            this.matchSteps.add((input, chain) -> {
                Matcher matcher = pattern.matcher(input);
                if (matcher.matches()) {
                    chain.matched(matchId, matcher.group(1), matcher.group(2));
                } else {
                    chain.notMatched(matchId, input);
                }
            });
            return this;
        }

        public Builder tryMatchExactly(MatchId matchId, String text) {
            this.matchSteps.add((input, chain) -> {
                if (input.equals(text)) {
                    chain.matched(matchId, text, "");
                } else {
                    chain.notMatched(matchId, input);
                }
            });
            return this;
        }

        public Builder tryMatchPrefixedNumber(MatchId matchId, String ... prefixes) {
            Pattern pattern = Pattern.compile("^(" + String.join((CharSequence)"|", prefixes) + ")(\\d+)(.*)$");
            this.matchSteps.add((input, chain) -> {
                Matcher matcher = pattern.matcher(input);
                if (matcher.matches()) {
                    chain.matched(matchId, matcher.group(2), matcher.group(3));
                } else {
                    chain.notMatched(matchId, input);
                }
            });
            return this;
        }

        public Builder tryMatchLast(MatchId matchId, String ... suffixes) {
            this.matchSteps.add((input, chain) -> {
                for (String suffix : suffixes) {
                    if (!input.endsWith(suffix)) continue;
                    chain.matched(matchId, suffix, input.substring(0, input.length() - suffix.length()));
                    return;
                }
                chain.notMatched(matchId, input);
            });
            return this;
        }

        public Builder tryMatchLastOccurrencePrefixed(MatchId matchId, String error, String ... prefixes) {
            this.matchSteps.add((input, chain) -> {
                for (String prefix : prefixes) {
                    int matchIndex = input.lastIndexOf(prefix);
                    if (matchIndex == -1) continue;
                    String prefixedWord = input.substring(matchIndex + prefix.length());
                    if (!prefixedWord.isEmpty() || error == null) {
                        chain.matched(matchId, prefixedWord, input.substring(0, matchIndex));
                        return;
                    }
                    throw new MatchFailedException(error);
                }
                chain.notMatched(matchId, input);
            });
            return this;
        }

        public Builder tryMatchFirstOccurrencePrefixed(MatchId matchId, String ... prefixes) {
            this.matchSteps.add((input, chain) -> {
                for (String prefix : prefixes) {
                    String prefixedWord;
                    int matchIndex = input.indexOf(prefix);
                    if (matchIndex == -1 || (prefixedWord = input.substring(matchIndex + prefix.length())).isEmpty()) continue;
                    chain.matched(matchId, prefixedWord, input.substring(0, matchIndex));
                    return;
                }
                chain.notMatched(matchId, input);
            });
            return this;
        }

        public Builder takeRest(MatchId matchId) {
            this.matchSteps.add((input, chain) -> {
                if (!input.isEmpty()) {
                    chain.matched(matchId, input, "");
                }
            });
            return this;
        }

        public Builder failOnRest(String error) {
            this.matchSteps.add((input, chain) -> {
                if (!input.isEmpty()) {
                    throw new MatchFailedException(error + ": " + input);
                }
            });
            return this;
        }

        public MethodNameParser build() {
            return new MethodNameParser(this.matchSteps);
        }
    }

    private static interface MatchStep {
        public void match(String var1, MatchChain var2);
    }

    private static interface MatchChain {
        public void matched(MatchId var1, String var2, String var3);

        public void notMatched(MatchId var1, String var2);
    }

    public record Match(MatchId id, String part) {
    }

    public static interface MatchId {
    }
}

