/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.QueryModelPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class QueryCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    public QueryCriteriaMethodMatch(List<MethodNameParser.Match> matches) {
        super(matches);
    }

    protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        boolean predicatedApplied = false;
        boolean projectionApplied = false;
        for (MethodNameParser.Match match : this.matches) {
            if (match.id() == QueryMatchId.PROJECTION) {
                this.applyProjections(matchContext, match.part(), root, query, cb);
                projectionApplied = true;
                continue;
            }
            if (match.id() == QueryMatchId.PREDICATE) {
                this.applyPredicates(match.part(), matchContext.getParameters(), root, query, cb);
                predicatedApplied = true;
                continue;
            }
            if (match.id() == QueryMatchId.ORDER) {
                this.applyOrderBy(match.part(), root, query, cb);
                continue;
            }
            if (match.id() == QueryMatchId.FOR_UPDATE) {
                query.forUpdate(true);
                continue;
            }
            if (match.id() == QueryMatchId.LIMIT) {
                String str = match.part();
                try {
                    int max = StringUtils.isNotEmpty((CharSequence)str) ? Integer.parseInt(str) : 1;
                    if (max <= -1) continue;
                    query.max(max);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new MatchFailedException("Invalid number specified to top: " + str);
                }
            }
            if (match.id() == QueryMatchId.FIRST) {
                query.max(1);
                continue;
            }
            if (match.id() != QueryMatchId.DISTINCT) continue;
            this.applyDistinct(query);
        }
        if (!predicatedApplied) {
            this.applyPredicates(matchContext.getParametersNotInRole(), root, query, cb);
        }
        if (!projectionApplied) {
            this.applyProjections(matchContext, "", root, query, cb);
        }
        this.applyJoinSpecs(root, this.joinSpecsAtMatchContext(matchContext, true));
    }

    protected <T> void applyDistinct(PersistentEntityCriteriaQuery<T> query) {
        if (query.isDistinct()) {
            throw new MatchFailedException("Distinct already specified!");
        }
        query.distinct(true);
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        List<SourcePersistentProperty> dtoProjectionProperties;
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        PersistentEntityCriteriaQuery criteriaQuery = cb.createQuery();
        this.apply(matchContext, criteriaQuery.from((PersistentEntity)matchContext.getRootEntity()), criteriaQuery, cb);
        FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = interceptorMatch.returnType();
        ClassElement interceptorType = interceptorMatch.interceptor();
        boolean optimisticLock = ((AbstractPersistentEntityCriteriaQuery)criteriaQuery).hasVersionRestriction();
        SourcePersistentEntityCriteriaQuery query = (SourcePersistentEntityCriteriaQuery)criteriaQuery;
        AbstractCriteriaMethodMatch.MethodResult result = this.analyzeMethodResult(matchContext, query.getQueryResultTypeName(), matchContext.getRootEntity().getClassElement(), interceptorMatch, false);
        if (result.isDto() && !result.isRuntimeDtoConversion() && !(dtoProjectionProperties = this.getDtoProjectionProperties(matchContext.getRootEntity(), resultType)).isEmpty()) {
            Root root = (Root)query.getRoots().iterator().next();
            List selectionList = dtoProjectionProperties.stream().map(p -> {
                if (matchContext.getQueryBuilder().shouldAliasProjections()) {
                    return root.get(p.getName()).alias(p.getName());
                }
                return root.get(p.getName());
            }).collect(Collectors.toList());
            query.multiselect(selectionList);
        }
        AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
        QueryBuilder queryBuilder = matchContext.getQueryBuilder();
        QueryModel queryModel = ((QueryModelPersistentEntityCriteriaQuery)criteriaQuery).getQueryModel();
        QueryResult queryResult = queryBuilder.buildQuery((AnnotationMetadata)annotationMetadataHierarchy, queryModel);
        ClassElement genericReturnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(genericReturnType)) {
            genericReturnType = genericReturnType.getFirstTypeArgument().orElse(matchContext.getRootEntity().getType());
        }
        QueryResult countQueryResult = null;
        if (matchContext.isTypeInRole(genericReturnType, "page")) {
            QueryModel countQuery = QueryModel.from((PersistentEntity)queryModel.getPersistentEntity());
            countQuery.projections().count();
            QueryModel.Junction junction = queryModel.getCriteria();
            for (QueryModel.Criterion criterion : junction.getCriteria()) {
                countQuery.add(criterion);
            }
            for (JoinPath joinPath : queryModel.getJoinPaths()) {
                Association association = joinPath.getAssociation();
                if (association != null && !association.getKind().isSingleEnded()) continue;
                Join.Type joinType = joinPath.getJoinType();
                switch (joinType) {
                    case INNER: 
                    case FETCH: {
                        joinType = Join.Type.DEFAULT;
                        break;
                    }
                    case LEFT_FETCH: {
                        joinType = Join.Type.LEFT;
                        break;
                    }
                    case RIGHT_FETCH: {
                        joinType = Join.Type.RIGHT;
                        break;
                    }
                }
                countQuery.join(joinPath.getPath(), joinType, null);
            }
            countQueryResult = queryBuilder.buildQuery((AnnotationMetadata)annotationMetadataHierarchy, countQuery);
        }
        return new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)result.resultType(), interceptorType).dto(result.isDto()).optimisticLock(optimisticLock).queryResult(queryResult).countQueryResult(countQueryResult);
    }

    private <T> void applyOrderBy(String orderBy, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb) {
        String[] orderDefItems;
        ArrayList<Order> orders = new ArrayList<Order>();
        for (String orderDef : orderDefItems = orderBy.split("And")) {
            String propertyName;
            String prop = NameUtils.decapitalize((String)orderDef);
            if (prop.endsWith("Desc")) {
                propertyName = prop.substring(0, prop.length() - 4);
                orders.add(cb.desc(this.findOrderProperty(root, propertyName)));
                continue;
            }
            if (prop.endsWith("Asc")) {
                propertyName = prop.substring(0, prop.length() - 3);
                orders.add(cb.asc(this.findOrderProperty(root, propertyName)));
                continue;
            }
            orders.add(cb.asc(this.findOrderProperty(root, prop)));
        }
        if (!orders.isEmpty()) {
            query.orderBy(orders);
        }
    }

    private <T> PersistentPropertyPath<?> findOrderProperty(PersistentEntityRoot<T> root, String propertyName) {
        if (root.getPersistentEntity().getPropertyByName(propertyName) != null) {
            return root.get(propertyName);
        }
        PersistentPropertyPath<Object> property = this.findProperty(root, propertyName);
        if (property != null) {
            return property;
        }
        throw new MatchFailedException("Cannot order by non-existent property: " + propertyName);
    }

    private <T> void applyProjections(MethodMatchContext matchContext, String projection, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        this.applyProjections(projection, root, query, cb, matchContext.getReturnType().getSimpleName());
    }

    protected <T> void applyProjections(String projectionPart, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb, String returnTypeName) {
        List<Selection<?>> selectionList = this.findSelections(projectionPart, root, cb, returnTypeName);
        if (selectionList.isEmpty()) {
            return;
        }
        if (selectionList.size() == 1) {
            query.select(selectionList.iterator().next());
        } else {
            query.multiselect(selectionList);
        }
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        return DataMethod.OperationType.QUERY;
    }
}

