/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.annotated;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Delete;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.DeleteCriteriaMethodMatch;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.processing.ProcessingException;
import java.util.Arrays;
import java.util.List;

@Internal
public final class DeleteAnnotatedMethodMatcher
implements MethodMatcher {
    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (matchContext.getMethodElement().hasStereotype(Delete.class)) {
            SourcePersistentEntity rootEntity;
            if (matchContext.getRootEntity() == null) {
                throw new ProcessingException((Element)matchContext.getMethodElement(), "Repository does not have a well-defined primary entity type");
            }
            ParameterElement[] parameters = matchContext.getParameters();
            ParameterElement entityParameter = null;
            ParameterElement entitiesParameter = null;
            if (matchContext.getParametersNotInRole().size() == 1) {
                entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
                entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
            }
            if (!(rootEntity = matchContext.getRootEntity()).hasIdentity() && !rootEntity.hasCompositeIdentity()) {
                throw new MatchFailedException("Delete all not supported for entities with no ID");
            }
            if (entityParameter == null && entitiesParameter == null && parameters.length != 0) {
                return new DeleteCriteriaMethodMatch(List.of(), false);
            }
            final ParameterElement finalEntityParameter = entityParameter;
            final ParameterElement finalEntitiesParameter = entitiesParameter;
            return new DeleteCriteriaMethodMatch(List.of(), false){

                @Override
                protected boolean supportedByImplicitQueries() {
                    return finalEntityParameter != null || finalEntitiesParameter != null;
                }

                @Override
                protected ParameterElement getEntityParameter() {
                    return finalEntityParameter;
                }

                @Override
                protected ParameterElement getEntitiesParameter() {
                    return finalEntitiesParameter;
                }
            };
        }
        return null;
    }

    @Override
    public int getOrder() {
        return -3000;
    }
}

