/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntitySubquery;
import io.micronaut.data.processor.model.criteria.impl.QueryResultAnalyzer;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityRoot;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Selection;
import java.util.function.Function;

@Internal
final class SourcePersistentEntitySubqueryImpl<T>
extends AbstractPersistentEntitySubquery<T>
implements SourcePersistentEntitySubquery<T> {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;

    SourcePersistentEntitySubqueryImpl(AbstractQuery<?> parentQuery, ExpressionType<T> resultType, Function<ClassElement, SourcePersistentEntity> entityResolver, CriteriaBuilder criteriaBuilder) {
        super(parentQuery, resultType, criteriaBuilder);
        this.entityResolver = entityResolver;
    }

    @Override
    public <X> PersistentEntityRoot<X> from(ClassElement entityClassElement) {
        return this.from(new SourcePersistentEntity(entityClassElement, this.entityResolver));
    }

    public <X> PersistentEntityRoot<X> from(Class<X> entityClass) {
        throw new IllegalStateException("Unsupported operation");
    }

    public <X> PersistentEntityRoot<X> from(PersistentEntity persistentEntity) {
        SourcePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new SourcePersistentEntityRoot((SourcePersistentEntity)persistentEntity, this.criteriaBuilder);
        return newEntityRoot;
    }

    @Override
    public String getQueryResultTypeName() {
        Selection selection = this.selection;
        if (selection instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            QueryResultAnalyzer selectionVisitor = new QueryResultAnalyzer();
            selectionVisitable.visitSelection((SelectionVisitor)selectionVisitor);
            return selectionVisitor.getQueryResultTypeName();
        }
        return null;
    }

    public <U> PersistentEntitySubquery<U> subquery(ExpressionType<U> type) {
        return new SourcePersistentEntitySubqueryImpl<U>((AbstractQuery<?>)this, type, this.entityResolver, this.criteriaBuilder);
    }
}

