/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.model.criteria.impl.QueryResultAnalyzer;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterExpressionImpl;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityRoot;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Selection;
import java.util.function.Function;

@Internal
final class SourcePersistentEntityCriteriaUpdateImpl<T>
extends AbstractPersistentEntityCriteriaUpdate<T>
implements SourcePersistentEntityCriteriaUpdate<T> {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;
    private final CriteriaBuilder criteriaBuilder;

    public SourcePersistentEntityCriteriaUpdateImpl(Function<ClassElement, SourcePersistentEntity> entityResolver, Class<T> root, CriteriaBuilder criteriaBuilder) {
        this.entityResolver = entityResolver;
        this.criteriaBuilder = criteriaBuilder;
    }

    @Override
    public PersistentEntityRoot<T> from(ClassElement entityClassElement) {
        return this.from(new SourcePersistentEntity(entityClassElement, this.entityResolver));
    }

    public PersistentEntityRoot<T> from(Class<T> entityClass) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public PersistentEntityRoot<T> from(PersistentEntity persistentEntity) {
        SourcePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new SourcePersistentEntityRoot((SourcePersistentEntity)persistentEntity, this.criteriaBuilder);
        return newEntityRoot;
    }

    protected void setValue(String attributeName, Object value) {
        if (value instanceof SourceParameterExpressionImpl) {
            SourceParameterExpressionImpl sourceParameterExpression = (SourceParameterExpressionImpl)((Object)value);
            sourceParameterExpression.setUpdate(true);
        }
        super.setValue(attributeName, value);
    }

    @Override
    public String getQueryResultTypeName() {
        Selection selection = this.returning;
        if (selection instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            QueryResultAnalyzer selectionVisitor = new QueryResultAnalyzer();
            selectionVisitable.visitSelection((SelectionVisitor)selectionVisitor);
            return selectionVisitor.getQueryResultTypeName();
        }
        return null;
    }
}

