/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.jpa.jx;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Index;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class IndexAnnotationMapper
implements NamedAnnotationMapper {
    private static final Function<String, String[]> COLUMN_LIST_SPLITTER = cols -> (String[])Arrays.stream(cols.split(",")).map(String::trim).toArray(String[]::new);

    @NonNull
    public String getName() {
        return "javax.persistence.Index";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(Index.class);
        annotation.stringValue("name").ifPresent(name -> builder.member("name", name));
        annotation.stringValue("columnList").ifPresent(columns -> builder.member("columns", COLUMN_LIST_SPLITTER.apply((String)columns)));
        annotation.booleanValue("unique").ifPresent(name -> builder.member("unique", name.booleanValue()));
        return Collections.singletonList(builder.build());
    }
}

