/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPrefixPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class SaveEntityMethodMatcher
extends AbstractPrefixPatternMethodMatcher {
    public static final List<String> PREFIXES = Collections.unmodifiableList(Arrays.asList("save", "persist", "store", "insert"));

    public SaveEntityMethodMatcher() {
        super(PREFIXES);
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        ParameterElement[] parameters = matchContext.getParameters();
        if (parameters.length > 0 && Arrays.stream(parameters).anyMatch(p -> (TypeUtils.isIterableOfEntity(p.getGenericType()) || TypeUtils.isEntity(p.getGenericType())) && SaveEntityMethodMatcher.isValidSaveReturnType(matchContext))) {
            return mc -> {
                ParameterElement[] parameters1 = mc.getParameters();
                ParameterElement entityParameter = Arrays.stream(parameters1).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
                ParameterElement entitiesParameter = Arrays.stream(parameters1).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
                if (entityParameter == null && entitiesParameter == null) {
                    throw new MatchFailedException("Cannot implement save method for specified arguments and return type", (Element)mc.getMethodElement());
                }
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, DataMethod.OperationType.INSERT, mc);
                MethodMatchInfo methodMatchInfo = new MethodMatchInfo(DataMethod.OperationType.INSERT, (TypedElement)entry.getKey(), FindersUtils.getInterceptorElement(mc, entry.getValue()));
                if (!mc.supportsImplicitQueries()) {
                    AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{mc.getRepositoryClass().getAnnotationMetadata(), mc.getAnnotationMetadata()});
                    methodMatchInfo.encodeEntityParameters(true).queryResult(mc.getQueryBuilder().buildInsert((AnnotationMetadata)annotationMetadataHierarchy, (PersistentEntity)mc.getRootEntity()));
                }
                if (entitiesParameter != null) {
                    methodMatchInfo.addParameterRole("entities", entitiesParameter.getName());
                }
                if (entityParameter != null) {
                    methodMatchInfo.addParameterRole("entity", entityParameter.getName());
                }
                return methodMatchInfo;
            };
        }
        return null;
    }

    static boolean isValidSaveReturnType(@NonNull MatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(null);
        }
        if (returnType == null) {
            return true;
        }
        if (TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType)) {
            return true;
        }
        if (TypeUtils.isIterableOfEntity(returnType)) {
            return true;
        }
        if (returnType.isAssignable(Iterable.class)) {
            return true;
        }
        return TypeUtils.isEntity(returnType);
    }
}

