/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class AnnotationMetadataHierarchy
implements AnnotationMetadata {
    private final AnnotationMetadata[] hierarchy;

    public AnnotationMetadataHierarchy(AnnotationMetadata ... hierarchy) {
        if (ArrayUtils.isNotEmpty((Object[])hierarchy)) {
            List<AnnotationMetadata> list = Arrays.asList(hierarchy);
            Collections.reverse(list);
            this.hierarchy = list.toArray(new AnnotationMetadata[0]);
        } else {
            this.hierarchy = new AnnotationMetadata[]{AnnotationMetadata.EMPTY_METADATA};
        }
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return (String[])Arrays.stream(this.hierarchy).flatMap(am -> Stream.of(am.stringValues(annotation, member))).toArray(String[]::new);
    }

    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.booleanValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        return Arrays.stream(this.hierarchy).anyMatch(am -> am.isTrue(annotation, member));
    }

    public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o = annotationMetadata.longValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.stringValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o = annotationMetadata.intValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.enumValue(annotation, member, enumType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @NonNull
    public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        Class[] classes = (Class[])Arrays.stream(this.hierarchy).flatMap(am -> Stream.of(am.classValues(annotation, member))).toArray(Class[]::new);
        return classes;
    }

    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.classValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @NonNull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getDeclaredAnnotationNamesByStereotype(stereotype).stream()).collect(Collectors.toList());
    }

    @NonNull
    public Set<String> getDeclaredAnnotationNames() {
        return this.hierarchy[0].getDeclaredAnnotationNames();
    }

    @NonNull
    public Set<String> getAnnotationNames() {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getDeclaredAnnotationNames().stream()).collect(Collectors.toSet());
    }

    @NonNull
    public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalValues values = annotationMetadata.getValues(annotation, valueType);
            if (values.isEmpty()) continue;
            return values;
        }
        return OptionalValues.empty();
    }

    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional defaultValue = annotationMetadata.getDefaultValue(annotation, member, requiredType);
            if (!defaultValue.isPresent()) continue;
            return defaultValue;
        }
        return Optional.empty();
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@NonNull Class<T> annotationType) {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getDeclaredAnnotationValuesByType(annotationType).stream()).collect(Collectors.toList());
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        return this.hierarchy[0].getDeclaredAnnotationValuesByType(annotationType);
    }

    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return this.hierarchy[0].hasDeclaredAnnotation(annotation);
    }

    public boolean hasAnnotation(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasDeclaredAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStereotype(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasDeclaredStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return this.hierarchy[0].hasDeclaredStereotype(annotation);
    }

    @NonNull
    public Map<String, Object> getDefaultValues(@NonNull String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Map defaultValues = annotationMetadata.getDefaultValues(annotation);
            if (defaultValues.isEmpty()) continue;
            return defaultValues;
        }
        return Collections.emptyMap();
    }
}

