/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpdateByMethod
extends DynamicFinder {
    public UpdateByMethod() {
        super("update");
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.UPDATE;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        boolean isMatch = super.isMethodMatch(methodElement, matchContext);
        if (isMatch) {
            if (!TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
                matchContext.possiblyFail("Update methods only support void or number based return types");
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        if (query == null) {
            matchContext.fail("Cannot implement batch update operation that doesn't perform a query");
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getProjections())) {
            matchContext.fail("Projections are not supported on batch updates");
            return null;
        }
        List criterionList = query.getCriteria().getCriteria();
        if (CollectionUtils.isEmpty((Collection)criterionList)) {
            matchContext.fail("Cannot implement batch update operation that doesn't perform a query");
            return null;
        }
        SourcePersistentEntity rootEntity = matchContext.getRootEntity();
        HashSet<String> queryParameters = new HashSet<String>();
        QueryParameter versionMatchMethodParameter = null;
        for (QueryModel.Criterion criterion : criterionList) {
            QueryModel.PropertyCriterion pc;
            Object v;
            if (!(criterion instanceof QueryModel.PropertyCriterion) || !((v = (pc = (QueryModel.PropertyCriterion)criterion).getValue()) instanceof QueryParameter)) continue;
            QueryParameter queryParameter = (QueryParameter)v;
            queryParameters.add(queryParameter.getName());
            if (!(criterion instanceof QueryModel.VersionEquals)) continue;
            versionMatchMethodParameter = queryParameter;
        }
        SourcePersistentEntity entity = matchContext.getRootEntity();
        List updateProperties = matchContext.getParametersNotInRole().stream().map(p -> p.stringValue(Parameter.class).orElse(p.getName())).filter(parameterName -> !queryParameters.contains(parameterName)).map(parameterName -> {
            Optional path = entity.getPath((String)parameterName);
            if (path.isPresent()) {
                return (String)path.get();
            }
            matchContext.fail("Cannot perform batch update for non-existent property: " + parameterName);
            return null;
        }).collect(Collectors.toList());
        rootEntity.getPersistentProperties().stream().filter(p -> p != null && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false) != false).map(PersistentProperty::getName).collect(Collectors.toCollection(() -> updateProperties));
        if (versionMatchMethodParameter != null && entity.getVersion() != null) {
            updateProperties.add(entity.getVersion().getName());
        }
        if (CollectionUtils.isEmpty(updateProperties)) {
            matchContext.fail("At least one parameter required to update");
            return null;
        }
        return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, FindersUtils.pickUpdateInterceptor(matchContext, matchContext.getReturnType()).getValue()), MethodMatchInfo.OperationType.UPDATE, (String[])updateProperties.stream().toArray(String[]::new));
    }
}

