/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.specification;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractListMethod;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;

@Internal
public class FindPageSpecificationMethod
extends AbstractListMethod {
    public static final String[] PREFIXES = new String[]{"get", "find", "search", "query"};

    public FindPageSpecificationMethod() {
        super(PREFIXES);
    }

    @Override
    public int getOrder() {
        return -200;
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        VisitorContext visitorContext = matchContext.getVisitorContext();
        ClassElement returnType = matchContext.getReturnType();
        return super.isMethodMatch(methodElement, matchContext) && returnType.isAssignable("org.springframework.data.domain.Page") && visitorContext.getClassElement("io.micronaut.data.spring.jpa.intercept.FindPageSpecificationInterceptor").isPresent() && visitorContext.getClassElement("org.springframework.data.jpa.domain.Specification").isPresent() && this.areParametersValid(methodElement);
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        ClassElement interceptorElement = this.getInterceptorElement(matchContext, "io.micronaut.data.spring.jpa.intercept.FindPageSpecificationInterceptor");
        return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, interceptorElement);
    }

    private boolean areParametersValid(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        int len = parameters.length;
        return len == 2 && parameters[0].getType().isAssignable("org.springframework.data.jpa.domain.Specification") && parameters[1].getType().isAssignable("org.springframework.data.domain.Pageable");
    }
}

