/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UpdateMethod
extends AbstractPatternBasedMethod {
    public UpdateMethod() {
        super(Pattern.compile("^update\\w*$"));
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.UPDATE;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        boolean isMatch;
        boolean bl = isMatch = super.isMethodMatch(methodElement, matchContext) && methodElement.getParameters().length > 1 && this.hasIdParameter(methodElement.getParameters());
        if (isMatch) {
            if (!TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
                matchContext.possiblyFail("Update methods only support void or number based return types");
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean hasIdParameter(ParameterElement[] parameters) {
        return Arrays.stream(parameters).anyMatch(p -> p.hasAnnotation(Id.class));
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        List<ParameterElement> parameters = matchContext.getParametersNotInRole();
        List remainingParameters = parameters.stream().filter(p -> !p.hasAnnotation(Id.class) && !p.hasAnnotation(Version.class)).collect(Collectors.toList());
        ParameterElement idParameter = parameters.stream().filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
        if (idParameter == null) {
            matchContext.fail("ID required for update method, but not specified");
            return null;
        }
        SourcePersistentEntity entity = matchContext.getRootEntity();
        if (entity.hasIdentity()) {
            String idParameterType;
            SourcePersistentProperty identity = entity.getIdentity();
            String idType = TypeUtils.getTypeName(identity.getType());
            if (!idType.equals(idParameterType = TypeUtils.getTypeName(idParameter.getType()))) {
                matchContext.fail("ID type of method [" + idParameterType + "] does not match ID type of entity: " + idType);
            }
        } else {
            matchContext.fail("Cannot update by ID for entity that has no ID");
        }
        ParameterElement versionMatchMethodParameter = null;
        QueryModel query = QueryModel.from((PersistentEntity)entity);
        query.idEq(new QueryParameter(idParameter.getName()));
        SourcePersistentProperty version = entity.getVersion();
        if (version != null && (versionMatchMethodParameter = (ParameterElement)parameters.stream().filter(p -> p.hasAnnotation(Version.class)).findFirst().orElse(null)) != null) {
            query.versionEq(new QueryParameter(versionMatchMethodParameter.getName()));
        }
        ArrayList<String> propertiesToUpdate = new ArrayList<String>(remainingParameters.size());
        for (ParameterElement parameter : remainingParameters) {
            String name = parameter.stringValue(Parameter.class).orElse(parameter.getName());
            SourcePersistentProperty prop = entity.getPropertyByName(name);
            if (prop == null) {
                matchContext.fail("Cannot update non-existent property: " + name);
                return null;
            }
            if (prop.isGenerated()) {
                matchContext.fail("Cannot update a generated property: " + name);
                return null;
            }
            propertiesToUpdate.add(name);
        }
        entity.getPersistentProperties().stream().filter(p -> p != null && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false) != false).map(PersistentProperty::getName).collect(Collectors.toCollection(() -> propertiesToUpdate));
        if (versionMatchMethodParameter != null && entity.getVersion() != null) {
            propertiesToUpdate.add(entity.getVersion().getName());
        }
        ClassElement returnType = matchContext.getReturnType();
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.pickUpdateInterceptor(matchContext, returnType);
        MethodMatchInfo info = new MethodMatchInfo((TypedElement)entry.getKey(), query, this.getInterceptorElement(matchContext, entry.getValue()), MethodMatchInfo.OperationType.UPDATE, (String[])propertiesToUpdate.stream().toArray(String[]::new));
        info.addParameterRole("id", idParameter.getName());
        if (versionMatchMethodParameter != null) {
            info.setOptimisticLock(true);
        }
        return info;
    }
}

