/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.factory.Restrictions;

public abstract class CriterionMethodExpression {
    private static final String IGNORE_CASE_SUFFIX = "IgnoreCase";
    protected final boolean ignoreCase;
    protected String propertyName;
    protected String[] argumentNames;
    protected int argumentsRequired = 1;

    protected CriterionMethodExpression(String propertyName) {
        if (propertyName.endsWith(IGNORE_CASE_SUFFIX)) {
            this.propertyName = propertyName.substring(0, propertyName.length() - IGNORE_CASE_SUFFIX.length());
            this.ignoreCase = true;
        } else {
            this.propertyName = propertyName;
            this.ignoreCase = false;
        }
    }

    public abstract QueryModel.Criterion createCriterion();

    public int getArgumentsRequired() {
        return this.argumentsRequired;
    }

    public void setArgumentNames(String[] argumentNames) {
        this.argumentNames = argumentNames;
    }

    public static class NotEqual
    extends CriterionMethodExpression {
        public NotEqual(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            String argument = this.argumentNames[0];
            if (argument != null) {
                return Restrictions.ne((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0])).ignoreCase(this.ignoreCase);
            }
            return Restrictions.isNotNull((String)this.propertyName);
        }
    }

    public static class Equal
    extends CriterionMethodExpression {
        public Equal(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            String argument = this.argumentNames[0];
            if (argument != null) {
                return Restrictions.eq((String)this.propertyName, (QueryParameter)new QueryParameter(argument)).ignoreCase(this.ignoreCase);
            }
            return Restrictions.isNull((String)this.propertyName);
        }
    }

    public static class IsNotEmpty
    extends CriterionMethodExpression {
        public IsNotEmpty(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.isNotEmpty((String)this.propertyName);
        }
    }

    public static class IsEmpty
    extends CriterionMethodExpression {
        public IsEmpty(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.isEmpty((String)this.propertyName);
        }
    }

    public static class IsNotNull
    extends CriterionMethodExpression {
        public IsNotNull(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.isNotNull((String)this.propertyName);
        }
    }

    public static class False
    extends CriterionMethodExpression {
        public False(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.isFalse((String)this.propertyName);
        }
    }

    public static class True
    extends CriterionMethodExpression {
        public True(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.isTrue((String)this.propertyName);
        }
    }

    public static class IsNull
    extends CriterionMethodExpression {
        public IsNull(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.isNull((String)this.propertyName);
        }
    }

    public static class InRange
    extends Between {
        public InRange(String propertyName) {
            super(propertyName);
        }
    }

    public static class Between
    extends CriterionMethodExpression {
        public Between(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 2;
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.between((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]), (QueryParameter)new QueryParameter(this.argumentNames[1]));
        }
    }

    public static class In
    extends InList {
        public In(String propertyName) {
            super(propertyName);
        }
    }

    public static class InList
    extends CriterionMethodExpression {
        public InList(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.in((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class NotInList
    extends CriterionMethodExpression {
        public NotInList(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            QueryModel.Negation negation = new QueryModel.Negation();
            negation.add((QueryModel.Criterion)Restrictions.in((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0])));
            return negation;
        }
    }

    public static class Rlike
    extends CriterionMethodExpression {
        public Rlike(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.rlike((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class Ilike
    extends CriterionMethodExpression {
        public Ilike(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.ilike((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class EndingWith
    extends EndsWith {
        public EndingWith(String propertyName) {
            super(propertyName);
        }
    }

    public static class EndsWith
    extends CriterionMethodExpression {
        public EndsWith(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.endsWith((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0])).ignoreCase(this.ignoreCase);
        }
    }

    public static class StartingWith
    extends StartsWith {
        public StartingWith(String propertyName) {
            super(propertyName);
        }
    }

    public static class StartsWith
    extends CriterionMethodExpression {
        public StartsWith(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.startsWith((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0])).ignoreCase(this.ignoreCase);
        }
    }

    public static class Containing
    extends Contains {
        public Containing(String propertyName) {
            super(propertyName);
        }
    }

    public static class Contains
    extends CriterionMethodExpression {
        public Contains(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.contains((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class Like
    extends CriterionMethodExpression {
        public Like(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.like((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class LessThanEquals
    extends CriterionMethodExpression {
        public LessThanEquals(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.lte((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class LessThan
    extends CriterionMethodExpression {
        public LessThan(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.lt((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class GreaterThanEquals
    extends CriterionMethodExpression {
        public GreaterThanEquals(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.gte((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }

    public static class Before
    extends LessThan {
        public Before(String propertyName) {
            super(propertyName);
        }
    }

    public static class After
    extends GreaterThan {
        public After(String propertyName) {
            super(propertyName);
        }
    }

    public static class GreaterThan
    extends CriterionMethodExpression {
        public GreaterThan(String propertyName) {
            super(propertyName);
        }

        @Override
        public QueryModel.Criterion createCriterion() {
            return Restrictions.gt((String)this.propertyName, (QueryParameter)new QueryParameter(this.argumentNames[0]));
        }
    }
}

