/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;

public class FindByFinder
extends DynamicFinder {
    public static final String[] PREFIXES = new String[]{"find", "get", "query", "retrieve", "read", "search"};

    public FindByFinder() {
        super(PREFIXES);
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && this.isCompatibleReturnType(methodElement, matchContext);
    }

    protected boolean isCompatibleReturnType(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        ClassElement returnType = methodElement.getGenericReturnType();
        if (!returnType.getName().equals("void")) {
            return returnType.hasStereotype(Introspected.class) || returnType.isPrimitive() || ClassUtils.isJavaBasicType((String)returnType.getName()) || TypeUtils.isContainerType(returnType);
        }
        return false;
    }
}

