/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.FindAllInterceptor;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.FindOptionalInterceptor;
import io.micronaut.data.intercept.FindPageInterceptor;
import io.micronaut.data.intercept.FindSliceInterceptor;
import io.micronaut.data.intercept.FindStreamInterceptor;
import io.micronaut.data.intercept.UpdateInterceptor;
import io.micronaut.data.intercept.async.FindAllAsyncInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.async.FindPageAsyncInterceptor;
import io.micronaut.data.intercept.async.FindSliceAsyncInterceptor;
import io.micronaut.data.intercept.reactive.FindAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindPageReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindSliceReactiveInterceptor;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.factory.Projections;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.ProjectionMethodExpression;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;

public abstract class AbstractPatternBasedMethod
implements MethodCandidate {
    private static final Pattern ORDER_BY_PATTERN = Pattern.compile("(.*)OrderBy([\\w\\d]+)");
    protected final Pattern pattern;

    protected AbstractPatternBasedMethod(@NonNull Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        return this.pattern.matcher(methodElement.getName()).find();
    }

    protected String matchOrder(String querySequence, List<Sort.Order> orders) {
        if (ORDER_BY_PATTERN.matcher(querySequence).matches()) {
            Matcher matcher = ORDER_BY_PATTERN.matcher(querySequence);
            StringBuffer buffer = new StringBuffer();
            if (matcher.find()) {
                matcher.appendReplacement(buffer, "$1");
                String orderDefGroup = matcher.group(2);
                if (StringUtils.isNotEmpty((CharSequence)orderDefGroup)) {
                    String[] orderDefItems;
                    for (String orderDef : orderDefItems = orderDefGroup.split("And")) {
                        String prop = NameUtils.decapitalize((String)orderDef);
                        if (prop.endsWith("Desc")) {
                            orders.add(Sort.Order.desc((String)prop.substring(0, prop.length() - 4)));
                            continue;
                        }
                        if (prop.endsWith("Asc")) {
                            orders.add(Sort.Order.asc((String)prop.substring(0, prop.length() - 3)));
                            continue;
                        }
                        orders.add(Sort.Order.asc((String)prop));
                    }
                }
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return querySequence;
    }

    protected void matchProjections(@NonNull MethodMatchContext matchContext, List<ProjectionMethodExpression> projectionExpressions, String projectionSequence) {
        ProjectionMethodExpression currentExpression = ProjectionMethodExpression.matchProjection(matchContext, projectionSequence);
        if (currentExpression != null) {
            projectionExpressions.add(currentExpression);
        }
    }

    @Nullable
    protected MethodMatchInfo buildInfo(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        ClassElement returnType = matchContext.getReturnType();
        ClassElement typeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (!returnType.getName().equals("void")) {
            if (this.isValidResultType(returnType)) {
                if (TypeUtils.areTypesCompatible(returnType, queryResultType)) {
                    if (this.isFindByIdQuery(matchContext, queryResultType, query)) {
                        Class<FindByIdInterceptor> type = FindByIdInterceptor.class;
                        return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), query, this.getInterceptorElement(matchContext, type));
                    }
                    if (query instanceof RawQuery) {
                        AnnotationMetadata annotationMetadata = matchContext.getAnnotationMetadata();
                        boolean readOnly = annotationMetadata.booleanValue(Query.class, "readOnly").orElse(true);
                        if (readOnly) {
                            String q = annotationMetadata.stringValue(Query.class).orElse(null);
                            if (q != null) {
                                if ((q = q.trim().toLowerCase(Locale.ENGLISH)).startsWith("update")) {
                                    return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, UpdateInterceptor.class));
                                }
                                if (q.startsWith("delete")) {
                                    return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, DeleteAllInterceptor.class));
                                }
                                return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, FindOneInterceptor.class));
                            }
                            return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, FindOneInterceptor.class));
                        }
                        return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, UpdateInterceptor.class));
                    }
                    return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, FindOneInterceptor.class));
                }
                if (query != null && returnType.hasStereotype(Introspected.class) && queryResultType.hasStereotype(MappedEntity.class)) {
                    if (this.attemptProjection(matchContext, queryResultType, query, returnType)) {
                        return null;
                    }
                    return new MethodMatchInfo((TypedElement)returnType, query, this.getInterceptorElement(matchContext, FindOneInterceptor.class), true);
                }
                matchContext.fail("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + returnType.getName());
                return null;
            }
            if (typeArgument != null) {
                boolean isPage = matchContext.isTypeInRole(typeArgument, "page");
                boolean isSlice = matchContext.isTypeInRole(typeArgument, "slice");
                if (returnType.isAssignable(CompletionStage.class) || returnType.isAssignable(Future.class)) {
                    Class interceptorType;
                    ClassElement firstTypeArgument;
                    if (typeArgument.isAssignable(Iterable.class) || isSlice || isPage) {
                        firstTypeArgument = typeArgument.getFirstTypeArgument().orElse(null);
                        if (firstTypeArgument == null) {
                            matchContext.fail("Async return type missing type argument");
                            return null;
                        }
                    } else {
                        firstTypeArgument = typeArgument;
                    }
                    if (isPage) {
                        interceptorType = FindPageAsyncInterceptor.class;
                    } else if (isSlice) {
                        interceptorType = FindSliceAsyncInterceptor.class;
                    } else if (typeArgument.isAssignable(Iterable.class)) {
                        interceptorType = FindAllAsyncInterceptor.class;
                    } else if (this.isValidResultType(typeArgument)) {
                        interceptorType = this.isFindByIdQuery(matchContext, queryResultType, query) ? FindByIdAsyncInterceptor.class : FindOneAsyncInterceptor.class;
                    } else {
                        matchContext.fail("Unsupported Async return type: " + firstTypeArgument.getName());
                        return null;
                    }
                    ClassElement finalResultType = firstTypeArgument;
                    if (TypeUtils.isObjectClass(finalResultType)) {
                        finalResultType = matchContext.getRootEntity().getType();
                    }
                    boolean dto = this.resolveDtoIfNecessary(matchContext, queryResultType, query, finalResultType);
                    if (matchContext.isFailing()) {
                        return null;
                    }
                    return new MethodMatchInfo((TypedElement)finalResultType, query, this.getInterceptorElement(matchContext, interceptorType), dto);
                }
                if (returnType.isAssignable(Publisher.class) || returnType.getPackageName().equals("io.reactivex")) {
                    boolean isContainerType;
                    ClassElement finalResultType = TypeUtils.isObjectClass(typeArgument) ? matchContext.getRootEntity().getType() : typeArgument;
                    boolean bl = isContainerType = isSlice || isPage;
                    if (isContainerType) {
                        finalResultType = typeArgument.getFirstTypeArgument().orElse(matchContext.getRootEntity().getType());
                    }
                    Class interceptorType = isPage ? FindPageReactiveInterceptor.class : (isSlice ? FindSliceReactiveInterceptor.class : (this.isReactiveSingleResult(returnType) ? (this.isFindByIdQuery(matchContext, queryResultType, query) ? FindByIdReactiveInterceptor.class : FindOneReactiveInterceptor.class) : FindAllReactiveInterceptor.class));
                    boolean dto = this.resolveDtoIfNecessary(matchContext, queryResultType, query, finalResultType);
                    if (matchContext.isFailing()) {
                        return null;
                    }
                    return new MethodMatchInfo((TypedElement)finalResultType, query, this.getInterceptorElement(matchContext, interceptorType), dto);
                }
                boolean dto = false;
                if (!TypeUtils.areTypesCompatible(typeArgument, queryResultType)) {
                    if (typeArgument.hasStereotype(Introspected.class) && queryResultType.hasStereotype(MappedEntity.class)) {
                        QueryModel projectionQuery;
                        QueryModel queryModel = projectionQuery = query != null ? query : QueryModel.from((PersistentEntity)matchContext.getRootEntity());
                        if (this.attemptProjection(matchContext, queryResultType, projectionQuery, typeArgument)) {
                            return null;
                        }
                        query = projectionQuery;
                        dto = true;
                    } else {
                        matchContext.fail("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + typeArgument.getName());
                        return null;
                    }
                }
                if (matchContext.isTypeInRole(matchContext.getReturnType(), "page")) {
                    return new MethodMatchInfo((TypedElement)typeArgument, query, this.getInterceptorElement(matchContext, FindPageInterceptor.class), dto);
                }
                if (matchContext.isTypeInRole(matchContext.getReturnType(), "slice")) {
                    return new MethodMatchInfo((TypedElement)typeArgument, query, this.getInterceptorElement(matchContext, FindSliceInterceptor.class), dto);
                }
                if (returnType.isAssignable(Iterable.class)) {
                    return new MethodMatchInfo((TypedElement)typeArgument, query, this.getInterceptorElement(matchContext, FindAllInterceptor.class), dto);
                }
                if (returnType.isAssignable(Stream.class)) {
                    return new MethodMatchInfo((TypedElement)typeArgument, query, this.getInterceptorElement(matchContext, FindStreamInterceptor.class), dto);
                }
                if (returnType.isAssignable(Optional.class)) {
                    return new MethodMatchInfo((TypedElement)typeArgument, query, this.getInterceptorElement(matchContext, FindOptionalInterceptor.class), dto);
                }
                if (returnType.isAssignable(Publisher.class)) {
                    return new MethodMatchInfo((TypedElement)typeArgument, query, this.getInterceptorElement(matchContext, FindAllReactiveInterceptor.class), dto);
                }
            }
        }
        matchContext.fail("Unsupported Repository method return type");
        return null;
    }

    protected ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, Class<? extends DataInterceptor> type) {
        return matchContext.getVisitorContext().getClassElement(type).orElseGet(() -> new DynamicClassElement(type));
    }

    protected ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, String type) {
        return (ClassElement)matchContext.getVisitorContext().getClassElement(type).orElseThrow(() -> new IllegalStateException("Unable to apply interceptor of type: " + type + ". The interceptor was not found on the classpath. Check your annotation processor configuration and try again."));
    }

    private boolean isFindByIdQuery(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        return matchContext.supportsImplicitQueries() && query != null && queryResultType.getName().equals(matchContext.getRootEntity().getName()) && this.isIdEquals(query) != false;
    }

    private Boolean isIdEquals(@NonNull QueryModel query) {
        List criteria = query.getCriteria().getCriteria();
        return criteria.size() == 1 && criteria.stream().findFirst().map(c -> c instanceof QueryModel.IdEquals).orElse(false) != false;
    }

    private boolean resolveDtoIfNecessary(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query, @NonNull ClassElement returnType) {
        boolean dto = false;
        if (!TypeUtils.areTypesCompatible(returnType, queryResultType)) {
            if (query != null && returnType.hasStereotype(Introspected.class) && queryResultType.hasStereotype(MappedEntity.class)) {
                if (!this.attemptProjection(matchContext, queryResultType, query, returnType)) {
                    dto = true;
                }
            } else {
                matchContext.fail("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + returnType.getName());
            }
        }
        return dto;
    }

    private boolean isValidResultType(ClassElement returnType) {
        return returnType.hasStereotype(Introspected.class) || ClassUtils.isJavaBasicType((String)returnType.getName()) || returnType.isPrimitive();
    }

    private boolean isReactiveSingleResult(ClassElement returnType) {
        return returnType.hasStereotype(SingleResult.class) || returnType.isAssignable("io.reactivex.Single") || returnType.isAssignable("reactor.core.publisher.Mono");
    }

    private boolean attemptProjection(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @NonNull QueryModel query, ClassElement returnType) {
        List beanProperties = returnType.getBeanProperties();
        SourcePersistentEntity entity = matchContext.getEntity(queryResultType);
        for (PropertyElement beanProperty : beanProperties) {
            String propertyName = beanProperty.getName();
            SourcePersistentProperty pp = entity.getPropertyByName(propertyName);
            if (pp == null) {
                pp = entity.getIdOrVersionPropertyByName(propertyName);
            }
            if (pp == null) {
                matchContext.fail("Property " + propertyName + " is not present in entity: " + entity.getName());
                return true;
            }
            if (!TypeUtils.areTypesCompatible(beanProperty.getType(), pp.getType())) {
                matchContext.fail("Property [" + propertyName + "] of type [" + beanProperty.getType().getName() + "] is not compatible with equivalent property declared in entity: " + entity.getName());
                return true;
            }
            QueryBuilder queryBuilder = matchContext.getQueryBuilder();
            if (queryBuilder.shouldAliasProjections()) {
                query.projections().add((QueryModel.Projection)Projections.property((String)propertyName).aliased());
                continue;
            }
            query.projections().add((QueryModel.Projection)Projections.property((String)propertyName));
        }
        return false;
    }

    protected boolean applyOrderBy(@NonNull MethodMatchContext context, @NonNull QueryModel query, @NonNull List<Sort.Order> orderList) {
        if (CollectionUtils.isNotEmpty(orderList)) {
            SourcePersistentEntity entity = context.getRootEntity();
            for (Sort.Order order : orderList) {
                String prop = order.getProperty();
                if (entity.getPath(prop).isPresent()) continue;
                context.fail("Cannot order by non-existent property: " + prop);
                return true;
            }
            query.sort(Sort.of(orderList));
        }
        return false;
    }

    protected boolean applyJoinSpecs(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query, @Nonnull SourcePersistentEntity rootEntity, @NonNull List<AnnotationValue<Join>> joinSpecs) {
        for (AnnotationValue<Join> joinSpec : joinSpecs) {
            String path = joinSpec.stringValue().orElse(null);
            Join.Type type = joinSpec.enumValue("type", Join.Type.class).orElse(Join.Type.FETCH);
            String alias = joinSpec.stringValue("alias").orElse(null);
            if (path == null) continue;
            PersistentProperty prop = rootEntity.getPropertyByPath(path).orElse(null);
            if (!(prop instanceof Association)) {
                matchContext.fail("Invalid join spec [" + path + "]. Property is not an association!");
                return true;
            }
            boolean hasExisting = query.getCriteria().getCriteria().stream().anyMatch(c -> {
                if (c instanceof AssociationQuery) {
                    AssociationQuery aq = (AssociationQuery)c;
                    return aq.getAssociation().equals(prop);
                }
                return false;
            });
            if (!hasExisting) {
                query.add((QueryModel.Criterion)new AssociationQuery(path, (Association)prop));
            }
            query.join(path, (Association)prop, type, alias);
        }
        return false;
    }

    protected RawQuery buildRawQuery(@NonNull MethodMatchContext matchContext) {
        MethodElement methodElement = matchContext.getMethodElement();
        String queryString = (String)methodElement.stringValue(Query.class).orElseThrow(() -> new IllegalStateException("Should only be called if Query has value!"));
        List<ParameterElement> parameters = Arrays.asList(matchContext.getParameters());
        LinkedHashMap<String, String> parameterBinding = new LinkedHashMap<String, String>(parameters.size());
        boolean namedParameters = matchContext.getRepositoryClass().booleanValue(RepositoryConfiguration.class, "namedParameters").orElse(true);
        if (namedParameters) {
            Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(queryString);
            while (matcher.find()) {
                String name = matcher.group(2);
                Optional<ParameterElement> element = parameters.stream().filter(p -> p.getName().equals(name)).findFirst();
                if (element.isPresent()) {
                    parameterBinding.put(name, element.get().getName());
                    continue;
                }
                matchContext.fail("No method parameter found for named Query parameter : " + name);
                return null;
            }
        } else {
            Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(queryString);
            int index = 1;
            while (matcher.find()) {
                String name = matcher.group(2);
                Optional<ParameterElement> element = parameters.stream().filter(p -> p.getName().equals(name)).findFirst();
                if (element.isPresent()) {
                    parameterBinding.put(String.valueOf(index++), element.get().getName());
                    continue;
                }
                matchContext.fail("No method parameter found for named Query parameter : " + name);
                return null;
            }
        }
        return new RawQuery(matchContext.getRootEntity(), parameterBinding);
    }

    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.QUERY;
    }

    private static class DynamicClassElement
    implements ClassElement {
        private final Class<? extends DataInterceptor> type;

        DynamicClassElement(Class<? extends DataInterceptor> type) {
            this.type = type;
        }

        public boolean isAssignable(String type) {
            return false;
        }

        @Nonnull
        public String getName() {
            return this.type.getName();
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.type.getModifiers());
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.type.getModifiers());
        }

        @Nonnull
        public Object getNativeType() {
            return this.type;
        }
    }
}

