/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.jta;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public class JtaTransactionalMapper
implements NamedAnnotationMapper {
    @NonNull
    public String getName() {
        return "javax.transaction.Transactional";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        boolean springManagement = visitorContext.getClassElement("io.micronaut.spring.tx.annotation.Transactional").isPresent();
        AnnotationValueBuilder builder = AnnotationValue.builder((String)(springManagement ? "io.micronaut.spring.tx.annotation.Transactional" : "io.micronaut.transaction.annotation.TransactionalAdvice"));
        annotation.getValue(String.class).ifPresent(type -> builder.member("propagation", type));
        annotation.get((CharSequence)"rollbackOn", String[].class).ifPresent(type -> builder.member("rollbackFor", type));
        annotation.get((CharSequence)"dontRollbackOn", String[].class).ifPresent(type -> builder.member("noRollbackFor", type));
        return Collections.singletonList(builder.build());
    }
}

