/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.intercept.ExistsByInterceptor;
import io.micronaut.data.intercept.async.ExistsByAsyncInterceptor;
import io.micronaut.data.intercept.reactive.ExistsByReactiveInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;

public class ExistsByFinder
extends DynamicFinder {
    public static final String[] PREFIXES = new String[]{"exists"};

    public ExistsByFinder() {
        super(PREFIXES);
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && (TypeUtils.doesReturnBoolean(methodElement) || TypeUtils.isReactiveOrFuture(matchContext.getReturnType()) && TypeUtils.isBoolean(matchContext.getReturnType().getFirstTypeArgument().orElse(null)));
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        Class<ExistsByInterceptor> interceptor = ExistsByInterceptor.class;
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isFutureType(returnType)) {
            interceptor = ExistsByAsyncInterceptor.class;
            returnType = returnType.getGenericType().getFirstTypeArgument().orElse(returnType);
        } else if (TypeUtils.isReactiveType(returnType)) {
            interceptor = ExistsByReactiveInterceptor.class;
            returnType = returnType.getGenericType().getFirstTypeArgument().orElse(returnType);
        }
        if (query == null) {
            QueryModel queryModel = query = matchContext.supportsImplicitQueries() ? query : QueryModel.from((PersistentEntity)matchContext.getRootEntity());
        }
        if (query != null) {
            query.projections().id();
        }
        return new MethodMatchInfo((TypedElement)returnType, query, interceptor);
    }
}

