/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.data.mongodb.conf.RequiresSyncMongo;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.async.AsyncUsingSyncTransactionOperations;
import jakarta.inject.Singleton;

@RequiresSyncMongo
@Factory
final class SynchronousMongoTransactionManagerFactory {
    SynchronousMongoTransactionManagerFactory() {
    }

    @Requires(missingProperty="mongodb.servers")
    @Primary
    @Singleton
    <T> AsyncUsingSyncTransactionOperations<T> buildPrimaryAsyncTransactionOperations(SynchronousTransactionManager<T> synchronousTransactionManager) {
        return new AsyncUsingSyncTransactionOperations(synchronousTransactionManager);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    <T> AsyncUsingSyncTransactionOperations<T> buildAsyncTransactionOperations(@Parameter SynchronousTransactionManager<T> synchronousTransactionManager) {
        return new AsyncUsingSyncTransactionOperations(synchronousTransactionManager);
    }
}

