/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.mongodb.conf.RequiresSyncMongo;
import io.micronaut.data.mongodb.transaction.MongoTransaction;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.CannotCreateTransactionException;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.support.AbstractSynchronousTransactionManager;
import io.micronaut.transaction.support.DefaultTransactionStatus;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@RequiresSyncMongo
@EachBean(value=MongoClient.class)
@Internal
public final class MongoSynchronousTransactionManager
extends AbstractSynchronousTransactionManager<ClientSession> {
    private final MongoClient mongoClient;
    private final String name;

    public MongoSynchronousTransactionManager(MongoClient mongoClient, @Nullable @Parameter String name) {
        this.mongoClient = mongoClient;
        this.name = name == null ? "default" : name;
    }

    protected Object getTransactionStateKey() {
        return this.mongoClient;
    }

    @Nullable
    public ClientSession findClientSession() {
        return (ClientSession)TransactionSynchronizationManager.getResource((Object)this.mongoClient);
    }

    public void closeClientSession() {
        ClientSession clientSession = (ClientSession)TransactionSynchronizationManager.unbindResource((Object)this.mongoClient);
        if (clientSession != null) {
            clientSession.close();
        }
    }

    public ClientSession getConnection() {
        ClientSession clientSession = this.findClientSession();
        if (clientSession == null) {
            throw new NoTransactionException("No active MongoDB client session!");
        }
        return clientSession;
    }

    public boolean hasConnection() {
        return this.findClientSession() != null;
    }

    protected ClientSession getConnection(Object transaction) {
        return ((MongoTransaction)transaction).getClientSession();
    }

    protected Object doGetTransaction() throws TransactionException {
        ClientSession clientSession = (ClientSession)TransactionSynchronizationManager.getResource((Object)this.mongoClient);
        return new MongoTransaction(clientSession);
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        MongoTransaction mongoTransaction = (MongoTransaction)transaction;
        return mongoTransaction.hasActiveTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        MongoTransaction mongoTransaction = (MongoTransaction)transaction;
        try {
            mongoTransaction.setName(definition.getName());
            if (!mongoTransaction.hasClientSession()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Acquired ClientSession for MongoDB transaction [{}] of datasource: [{}]", (Object)mongoTransaction, (Object)this.name);
                }
                ClientSession clientSession = this.mongoClient.startSession();
                mongoTransaction.setClientSessionHolder(clientSession, true);
            }
            TransactionOptions.Builder txOptionsBuilder = TransactionOptions.builder();
            Duration timeout = this.determineTimeout(definition);
            if (timeout != TransactionDefinition.TIMEOUT_DEFAULT) {
                txOptionsBuilder = txOptionsBuilder.maxCommitTime(Long.valueOf(timeout.toMillis()), TimeUnit.MILLISECONDS);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting MongoDB transaction [{}] of datasource: [{}]", transaction, (Object)this.name);
            }
            mongoTransaction.beginTransaction(txOptionsBuilder.build());
            if (mongoTransaction.isNewClientSession()) {
                TransactionSynchronizationManager.bindResource((Object)this.mongoClient, (Object)mongoTransaction.getClientSession());
            }
        }
        catch (Throwable ex) {
            mongoTransaction.close();
            throw new CannotCreateTransactionException("Could not open MongoDB client session for transaction", ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus<ClientSession> status) throws TransactionException {
        MongoTransaction transaction = (MongoTransaction)status.getTransaction();
        if (transaction.isRollbackOnly()) {
            throw new TransactionException("Transaction marked as rollback only!");
        }
        if (status.isDebug()) {
            this.logger.debug("Committing MongoDB transaction [{}] of datasource: [{}]", (Object)transaction, (Object)this.name);
        }
        try {
            transaction.commitTransaction();
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not commit MongoDB transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus<ClientSession> status) throws TransactionException {
        MongoTransaction transaction = (MongoTransaction)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Rolling back MongoDB transaction [{}] of datasource: [{}]", (Object)transaction, (Object)this.name);
        }
        try {
            transaction.abortTransaction();
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not roll back MongoDB transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        return TransactionSynchronizationManager.unbindResource((Object)this.mongoClient);
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource((Object)this.mongoClient, (Object)suspendedResources);
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        MongoTransaction mongoTransaction = (MongoTransaction)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Setting MongoDB transaction [{}] to rollback-only, of datasource: [{}]", (Object)mongoTransaction, (Object)this.name);
        }
        mongoTransaction.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        MongoTransaction mongoTransaction = (MongoTransaction)transaction;
        if (mongoTransaction.isNewClientSession()) {
            TransactionSynchronizationManager.unbindResource((Object)this.mongoClient);
        }
        mongoTransaction.close();
    }
}

